/*
 * Decompiled with CFR 0.152.
 */
package com.mottimotti.android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.MonthDisplayHelper;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TableLayout;
import android.widget.TableRow;
import com.mottimotti.android.R;
import com.mottimotti.android.widget.CalendarDay;
import com.mottimotti.android.widget.CalendarFilter;
import com.mottimotti.android.widget.CalendarWeek;
import com.mottimotti.android.widget.DayState;
import com.mottimotti.android.widget.TypeFaceTextView;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class CalendarTable
extends TableLayout {
    private static final int ROW_NUMBER = 6;
    private int blockedStateDrawable;
    private int blockedStateTextAppearance;
    private String blockedStateTypeface;
    private int blockedStateTextShadow;
    private int regularStateDrawable;
    private int regularStateTextAppearance;
    private String regularStateTypeface;
    private int regularStateTextShadow;
    private int inactiveStateDrawable;
    private int inactiveStateTextAppearance;
    private String inactiveStateTypeface;
    private int inactiveStateTextShadow;
    private int activeStateDrawable;
    private int activeStateTextAppearance;
    private String activeStateTypeface;
    private int activeStateTextShadow;
    private int currentStateDrawable;
    private int currentStateTextAppearance;
    private String currentStateTypeface;
    private int currentStateTextShadow;
    private int headerStateDrawable;
    private int headerStateTextAppearance;
    private String headerStateTypeface;
    private int headerStateTextShadow;
    private MonthDisplayHelper monthDisplayHelper;
    private boolean blockFutureDays;
    private int weekStartDay;
    private boolean isEdit = false;
    private List<Date> activeDates = new ArrayList<Date>();
    private OnMonthSelectedListener monthSelectedListener;
    private CellClickListener clickListener;

    public CalendarTable(Context context) {
        super(context);
    }

    public CalendarTable(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
        this.setUp();
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CalendarTable);
        this.blockFutureDays = a.getBoolean(0, false);
        this.weekStartDay = a.getInt(1, 1);
        this.blockedStateDrawable = a.getResourceId(2, 17170445);
        this.blockedStateTextAppearance = a.getResourceId(3, 16973892);
        this.blockedStateTypeface = a.getString(4);
        this.blockedStateTextShadow = a.getResourceId(5, 0);
        this.regularStateDrawable = a.getResourceId(6, 17170445);
        this.regularStateTextAppearance = a.getResourceId(7, 16973892);
        this.regularStateTypeface = a.getString(8);
        this.regularStateTextShadow = a.getResourceId(9, 0);
        this.inactiveStateDrawable = a.getResourceId(10, 17170445);
        this.inactiveStateTextAppearance = a.getResourceId(11, 16973892);
        this.inactiveStateTypeface = a.getString(12);
        this.inactiveStateTextShadow = a.getResourceId(13, 0);
        this.activeStateDrawable = a.getResourceId(14, 17170445);
        this.activeStateTextAppearance = a.getResourceId(15, 16973892);
        this.activeStateTypeface = a.getString(16);
        this.activeStateTextShadow = a.getResourceId(17, 0);
        this.currentStateDrawable = a.getResourceId(18, 17170445);
        this.currentStateTextAppearance = a.getResourceId(19, 16973892);
        this.currentStateTypeface = a.getString(20);
        this.currentStateTextShadow = a.getResourceId(17, 0);
        this.headerStateDrawable = a.getResourceId(22, 17170445);
        this.headerStateTextAppearance = a.getResourceId(23, 16973892);
        this.headerStateTypeface = a.getString(24);
        this.headerStateTextShadow = a.getResourceId(25, 0);
        a.recycle();
    }

    private void setUp() {
        this.setUpMonthDisplayHelper();
        this.setUpCalendarRows();
        this.setUpCalendarCells();
        this.showLastRowIfNeed();
    }

    private void setUpMonthDisplayHelper() {
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        int month = calendar.get(2);
        this.monthDisplayHelper = new MonthDisplayHelper(year, month, this.weekStartDay);
    }

    private void setUpCalendarRows() {
        int wrap_content = -2;
        int match_parent = -1;
        TableRow.LayoutParams params = new TableRow.LayoutParams(match_parent, wrap_content);
        for (int i = 0; i < 7; ++i) {
            TableRow tableRow = new TableRow(this.getContext());
            tableRow.setLayoutParams((ViewGroup.LayoutParams)params);
            this.addView((View)tableRow);
        }
    }

    private void setUpCalendarCells() {
        this.initCalendarHeader();
        this.initCalendarBody();
    }

    private void initCalendarHeader() {
        TableRow row = (TableRow)this.getChildAt(0);
        DateFormatSymbols symbols = new DateFormatSymbols();
        String[] dayNames = symbols.getShortWeekdays();
        String[] before = Arrays.copyOfRange(dayNames, 0, this.weekStartDay);
        String[] after = Arrays.copyOfRange(dayNames, this.weekStartDay, dayNames.length);
        ArrayList<String> days = new ArrayList<String>();
        days.addAll(Arrays.asList(after));
        days.addAll(Arrays.asList(before));
        for (String dayName : days) {
            if (dayName.equals("")) continue;
            CalendarCell cell = new CalendarCell(this.getContext());
            cell.setState(DayState.HEADER);
            cell.setText(String.format("%s.", dayName));
            row.addView((View)cell);
        }
    }

    private void initCalendarBody() {
        for (int row = 0; row < 6; ++row) {
            CalendarWeek week = new CalendarWeek(this, row);
            this.initRowCells(week, row);
        }
    }

    private void initRowCells(CalendarWeek week, int rowIndex) {
        TableRow row = (TableRow)this.getChildAt(rowIndex + 1);
        List<CalendarDay> days = week.getDays();
        for (CalendarDay day : days) {
            CalendarCell calendarDay = new CalendarCell(this.getContext());
            calendarDay.setDay(day);
            row.addView((View)calendarDay);
        }
    }

    private void showLastRowIfNeed() {
        boolean withinCurrentMonth = this.monthDisplayHelper.isWithinCurrentMonth(5, 0);
        this.getChildAt(6).setVisibility(withinCurrentMonth ? 0 : 8);
    }

    public void previousMonth() {
        this.monthDisplayHelper.previousMonth();
        this.dispatchPreviousMonthSelected();
        this.updateCalendarTable();
    }

    public void nextMonth() {
        this.monthDisplayHelper.nextMonth();
        this.dispatchNextMonthSelected();
        this.updateCalendarTable();
    }

    private void updateCalendarTable() {
        this.showLastRowIfNeed();
        int rowsCount = this.getChildCount();
        for (int row = 1; row < rowsCount; ++row) {
            TableRow rowView = (TableRow)this.getChildAt(row);
            this.updateRowCells(rowView, row - 1);
        }
    }

    private void updateRowCells(TableRow rowView, int rowIndex) {
        int columnsCount = rowView.getChildCount();
        CalendarWeek week = new CalendarWeek(this, rowIndex);
        List<CalendarDay> days = week.getDays();
        for (int column = 0; column < columnsCount; ++column) {
            CalendarCell cell = (CalendarCell)rowView.getChildAt(column);
            cell.setDay(days.get(column));
        }
    }

    public Calendar[] getCurrentCalendars() {
        CalendarFilter calendarFilters = new CalendarFilter(this.monthDisplayHelper);
        return calendarFilters.getFilters();
    }

    public Calendar getHelperCalendar() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, this.monthDisplayHelper.getYear());
        calendar.set(2, this.monthDisplayHelper.getMonth());
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.getTimeInMillis();
        return calendar;
    }

    public MonthDisplayHelper getMonthDisplayHelper() {
        return this.monthDisplayHelper;
    }

    public boolean isFutureDaysBlocked() {
        return this.blockFutureDays;
    }

    public void setActiveDates(List<Date> dates) {
        this.activeDates = dates;
        this.updateCalendarTable();
    }

    public List<Date> getActiveDates() {
        return this.activeDates;
    }

    public int getYear() {
        return this.getHelperCalendar().get(1);
    }

    public int getMonth() {
        return this.getHelperCalendar().get(2);
    }

    public int getDay() {
        return this.getHelperCalendar().get(5);
    }

    public void setBlockedStateDrawable(int blockedStateDrawable) {
        this.blockedStateDrawable = blockedStateDrawable;
    }

    public void setBlockedStateTextAppearance(int blockedStateTextAppearance) {
        this.blockedStateTextAppearance = blockedStateTextAppearance;
    }

    public void setBlockedStateTypeface(String blockedStateTypeface) {
        this.blockedStateTypeface = blockedStateTypeface;
    }

    public void setBlockedStateTextShadow(int blockedStateTextShadow) {
        this.blockedStateTextShadow = blockedStateTextShadow;
    }

    public void setRegularStateDrawable(int regularStateDrawable) {
        this.regularStateDrawable = regularStateDrawable;
    }

    public void setRegularStateTextAppearance(int regularStateTextAppearance) {
        this.regularStateTextAppearance = regularStateTextAppearance;
    }

    public void setRegularStateTypeface(String regularStateTypeface) {
        this.regularStateTypeface = regularStateTypeface;
    }

    public void setRegularStateTextShadow(int regularStateTextShadow) {
        this.regularStateTextShadow = regularStateTextShadow;
    }

    public void setInactiveStateDrawable(int inactiveStateDrawable) {
        this.inactiveStateDrawable = inactiveStateDrawable;
    }

    public void setInactiveStateTextAppearance(int inactiveStateTextAppearance) {
        this.inactiveStateTextAppearance = inactiveStateTextAppearance;
    }

    public void setInactiveStateTypeface(String inactiveStateTypeface) {
        this.inactiveStateTypeface = inactiveStateTypeface;
    }

    public void setInactiveStateTextShadow(int inactiveStateTextShadow) {
        this.inactiveStateTextShadow = inactiveStateTextShadow;
    }

    public void setActiveStateDrawable(int activeStateDrawable) {
        this.activeStateDrawable = activeStateDrawable;
    }

    public void setActiveStateTextAppearance(int activeStateTextAppearance) {
        this.activeStateTextAppearance = activeStateTextAppearance;
    }

    public void setActiveStateTypeface(String activeStateTypeface) {
        this.activeStateTypeface = activeStateTypeface;
    }

    public void setActiveStateTextShadow(int activeStateTextShadow) {
        this.activeStateTextShadow = activeStateTextShadow;
    }

    public void setCurrentStateDrawable(int currentStateDrawable) {
        this.currentStateDrawable = currentStateDrawable;
    }

    public void setCurrentStateTextAppearance(int currentStateTextAppearance) {
        this.currentStateTextAppearance = currentStateTextAppearance;
    }

    public void setCurrentStateTypeface(String currentStateTypeface) {
        this.currentStateTypeface = currentStateTypeface;
    }

    public void setCurrentStateTextShadow(int currentStateTextShadow) {
        this.currentStateTextShadow = currentStateTextShadow;
    }

    public void setHeaderStateDrawable(int headerStateDrawable) {
        this.headerStateDrawable = headerStateDrawable;
    }

    public void setHeaderStateTextAppearance(int headerStateTextAppearance) {
        this.headerStateTextAppearance = headerStateTextAppearance;
    }

    public void setHeaderStateTypeface(String headerStateTypeface) {
        this.headerStateTypeface = headerStateTypeface;
    }

    public void setHeaderStateTextShadow(int headerStateTextShadow) {
        this.headerStateTextShadow = headerStateTextShadow;
    }

    public void setMonthDisplayHelper(MonthDisplayHelper monthDisplayHelper) {
        this.monthDisplayHelper = monthDisplayHelper;
    }

    public void setBlockFutureDays(boolean blockFutureDays) {
        this.blockFutureDays = blockFutureDays;
        this.updateCalendarTable();
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        int year = savedState.currentYear;
        int month = savedState.currentMonth;
        this.monthDisplayHelper = new MonthDisplayHelper(year, month);
        this.updateCalendarTable();
        this.requestLayout();
    }

    public Parcelable onSaveInstanceState() {
        Calendar calendar = this.getHelperCalendar();
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.currentYear = calendar.get(1);
        savedState.currentMonth = calendar.get(2);
        return savedState;
    }

    public void setOnMonthSelectedListener(OnMonthSelectedListener selectedListener) {
        this.monthSelectedListener = selectedListener;
    }

    private void dispatchPreviousMonthSelected() {
        if (this.monthSelectedListener != null && !this.isEdit) {
            this.isEdit = true;
            Calendar[] calendars = this.getCurrentCalendars();
            this.monthSelectedListener.onPreviousMonthSelected(calendars[0], calendars[1]);
            this.isEdit = false;
        }
    }

    private void dispatchNextMonthSelected() {
        if (this.monthSelectedListener != null && !this.isEdit) {
            this.isEdit = true;
            Calendar[] calendars = this.getCurrentCalendars();
            this.monthSelectedListener.onNextMonthSelected(calendars[0], calendars[1]);
            this.isEdit = false;
        }
    }

    public void setCellClickListener(CellClickListener clickListener) {
        this.clickListener = clickListener;
    }

    private void dispatchCellClickListener(Calendar calendar) {
        if (this.clickListener != null) {
            this.clickListener.onClick(calendar);
        }
    }

    private class CalendarCell
    extends TypeFaceTextView
    implements View.OnClickListener {
        private CalendarDay day;
        private CalendarDay previousDay;

        public CalendarCell(Context context) {
            super(context);
            this.init();
        }

        public CalendarCell(Context context, AttributeSet attrs) {
            super(context, attrs);
            this.init();
        }

        public CalendarCell(Context context, AttributeSet attrs, int defStyle) {
            super(context, attrs, defStyle);
            this.init();
        }

        public void init() {
            this.setGravity(17);
            this.setClickable(true);
            this.setOnClickListener(this);
        }

        public void setState(DayState state) {
            switch (state) {
                case HEADER: {
                    this.applyHeaderState();
                    break;
                }
                case BLOCKED: {
                    this.applyBlockedState();
                    break;
                }
                case REGULAR: {
                    this.applyRegularSettings();
                    break;
                }
                case INACTIVE: {
                    this.applyInActiveSettings();
                    break;
                }
                case ACTIVE: {
                    this.applyActiveSettings();
                    break;
                }
                case CURRENT: {
                    this.applyCurrentState();
                }
            }
        }

        private void applyHeaderState() {
            this.setTextAppearance(this.getContext(), CalendarTable.this.headerStateTextAppearance);
            this.setTextShadowAppearance(this.getContext(), CalendarTable.this.headerStateTextShadow);
            this.setBackgroundResource(CalendarTable.this.headerStateDrawable);
            this.loadTypeface(CalendarTable.this.headerStateTypeface);
            this.setClickable(false);
        }

        private void applyRegularSettings() {
            this.setTextAppearance(this.getContext(), CalendarTable.this.regularStateTextAppearance);
            this.setTextShadowAppearance(this.getContext(), CalendarTable.this.regularStateTextShadow);
            this.setBackgroundResource(CalendarTable.this.regularStateDrawable);
            this.loadTypeface(CalendarTable.this.regularStateTypeface);
            this.setClickable(true);
        }

        private void applyBlockedState() {
            this.setTextAppearance(this.getContext(), CalendarTable.this.blockedStateTextAppearance);
            this.setTextShadowAppearance(this.getContext(), CalendarTable.this.blockedStateTextShadow);
            this.setBackgroundResource(CalendarTable.this.blockedStateDrawable);
            this.loadTypeface(CalendarTable.this.blockedStateTypeface);
            this.setClickable(false);
        }

        private void applyInActiveSettings() {
            this.setTextAppearance(this.getContext(), CalendarTable.this.inactiveStateTextAppearance);
            this.setTextShadowAppearance(this.getContext(), CalendarTable.this.inactiveStateTextShadow);
            this.setBackgroundResource(CalendarTable.this.inactiveStateDrawable);
            this.loadTypeface(CalendarTable.this.inactiveStateTypeface);
            this.setClickable(true);
        }

        private void applyActiveSettings() {
            this.setTextAppearance(this.getContext(), CalendarTable.this.activeStateTextAppearance);
            this.setTextShadowAppearance(this.getContext(), CalendarTable.this.activeStateTextShadow);
            this.setBackgroundResource(CalendarTable.this.activeStateDrawable);
            this.loadTypeface(CalendarTable.this.activeStateTypeface);
            this.setClickable(true);
        }

        private void applyCurrentState() {
            this.setTextAppearance(this.getContext(), CalendarTable.this.currentStateTextAppearance);
            this.setTextShadowAppearance(this.getContext(), CalendarTable.this.currentStateTextShadow);
            this.setBackgroundResource(CalendarTable.this.currentStateDrawable);
            this.loadTypeface(CalendarTable.this.currentStateTypeface);
            this.setClickable(true);
        }

        private void setTextShadowAppearance(Context context, int resid) {
            if (resid == 0) {
                this.setShadowLayer(0.0f, 0.0f, 0.0f, 0);
            } else {
                int[] attrsArray = new int[]{0x1010161, 16843106, 16843107, 16843108};
                TypedArray appearance = context.obtainStyledAttributes(resid, attrsArray);
                int color2 = appearance.getColor(0, 0);
                float shadowDx = appearance.getFloat(1, 0.0f);
                float shadowDy = appearance.getFloat(2, 0.0f);
                float radius = appearance.getFloat(3, 0.0f);
                appearance.recycle();
                this.setShadowLayer(radius, shadowDx, shadowDy, color2);
            }
        }

        public void setDay(CalendarDay day) {
            if (this.previousDay == null) {
                this.previousDay = day;
                this.setState(day.getState());
            } else {
                this.previousDay = this.day;
                if (this.previousDay.getState() != day.getState()) {
                    this.setState(day.getState());
                }
            }
            this.day = day;
            this.setText(day.toString());
        }

        public void onClick(View v) {
            CalendarTable.this.dispatchCellClickListener(this.day.getCalendar());
        }
    }

    public static interface CellClickListener {
        public void onClick(Calendar var1);
    }

    public static interface OnMonthSelectedListener {
        public void onPreviousMonthSelected(Calendar var1, Calendar var2);

        public void onNextMonthSelected(Calendar var1, Calendar var2);
    }

    static class SavedState
    extends View.BaseSavedState {
        int currentMonth;
        int currentYear;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            int[] val = new int[2];
            in.readIntArray(val);
            this.currentYear = val[0];
            this.currentMonth = val[1];
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeIntArray(new int[]{this.currentYear, this.currentMonth});
        }
    }
}

