/*
 * Decompiled with CFR 0.152.
 */
package com.monitorjbl.xlsx.impl;

import com.monitorjbl.xlsx.exceptions.NotSupportedException;
import java.util.Calendar;
import java.util.Date;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.ss.formula.FormulaParseException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public class StreamingCell
implements Cell {
    private static final String FALSE_AS_STRING = "0";
    private static final String TRUE_AS_STRING = "1";
    private int columnIndex;
    private int rowIndex;
    private final boolean use1904Dates;
    private Object contents;
    private Object rawContents;
    private String formula;
    private String numericFormat;
    private Short numericFormatIndex;
    private String type;
    private String cachedFormulaResultType;
    private Row row;
    private CellStyle cellStyle;

    public StreamingCell(int columnIndex, int rowIndex, boolean use1904Dates) {
        this.columnIndex = columnIndex;
        this.rowIndex = rowIndex;
        this.use1904Dates = use1904Dates;
    }

    public Object getContents() {
        return this.contents;
    }

    public void setContents(Object contents) {
        this.contents = contents;
    }

    public Object getRawContents() {
        return this.rawContents;
    }

    public void setRawContents(Object rawContents) {
        this.rawContents = rawContents;
    }

    public String getNumericFormat() {
        return this.numericFormat;
    }

    public void setNumericFormat(String numericFormat) {
        this.numericFormat = numericFormat;
    }

    public Short getNumericFormatIndex() {
        return this.numericFormatIndex;
    }

    public void setNumericFormatIndex(Short numericFormatIndex) {
        this.numericFormatIndex = numericFormatIndex;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if ("str".equals(type)) {
            this.cachedFormulaResultType = this.type;
        }
        this.type = type;
    }

    public void setRow(Row row) {
        this.row = row;
    }

    public void setCellStyle(CellStyle cellStyle) {
        this.cellStyle = cellStyle;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public Row getRow() {
        return this.row;
    }

    public int getCellType() {
        return this.getCellTypeEnum().getCode();
    }

    public CellType getCellTypeEnum() {
        if (this.contents == null || this.type == null) {
            return CellType.BLANK;
        }
        if ("n".equals(this.type)) {
            return CellType.NUMERIC;
        }
        if ("s".equals(this.type) || "inlineStr".equals(this.type)) {
            return CellType.STRING;
        }
        if ("str".equals(this.type)) {
            return CellType.FORMULA;
        }
        if ("b".equals(this.type)) {
            return CellType.BOOLEAN;
        }
        if ("e".equals(this.type)) {
            return CellType.ERROR;
        }
        throw new UnsupportedOperationException("Unsupported cell type '" + this.type + "'");
    }

    public String getStringCellValue() {
        return this.contents == null ? "" : (String)this.contents;
    }

    public double getNumericCellValue() {
        return this.rawContents == null ? 0.0 : Double.parseDouble((String)this.rawContents);
    }

    public Date getDateCellValue() {
        if (this.getCellType() == 1) {
            throw new IllegalStateException("Cell type cannot be CELL_TYPE_STRING");
        }
        return this.rawContents == null ? null : HSSFDateUtil.getJavaDate((double)this.getNumericCellValue(), (boolean)this.use1904Dates);
    }

    public boolean getBooleanCellValue() {
        int cellType = this.getCellType();
        switch (cellType) {
            case 3: {
                return false;
            }
            case 4: {
                return this.rawContents != null && TRUE_AS_STRING.equals(this.rawContents);
            }
            case 2: {
                throw new NotSupportedException();
            }
        }
        throw StreamingCell.typeMismatch(4, cellType, false);
    }

    private static RuntimeException typeMismatch(int expectedTypeCode, int actualTypeCode, boolean isFormulaCell) {
        String msg = "Cannot get a " + StreamingCell.getCellTypeName(expectedTypeCode) + " value from a " + StreamingCell.getCellTypeName(actualTypeCode) + " " + (isFormulaCell ? "formula " : "") + "cell";
        return new IllegalStateException(msg);
    }

    private static String getCellTypeName(int cellTypeCode) {
        switch (cellTypeCode) {
            case 3: {
                return "blank";
            }
            case 1: {
                return "text";
            }
            case 4: {
                return "boolean";
            }
            case 5: {
                return "error";
            }
            case 0: {
                return "numeric";
            }
            case 2: {
                return "formula";
            }
        }
        return "#unknown cell type (" + cellTypeCode + ")#";
    }

    public CellStyle getCellStyle() {
        return this.cellStyle;
    }

    public String getCellFormula() {
        if (this.type == null || !"str".equals(this.type)) {
            throw new IllegalStateException("This cell does not have a formula");
        }
        return this.formula;
    }

    public int getCachedFormulaResultType() {
        return this.getCachedFormulaResultTypeEnum().getCode();
    }

    public CellType getCachedFormulaResultTypeEnum() {
        if (this.type != null && "str".equals(this.type)) {
            if (this.contents == null || this.cachedFormulaResultType == null) {
                return CellType.BLANK;
            }
            if ("n".equals(this.cachedFormulaResultType)) {
                return CellType.NUMERIC;
            }
            if ("s".equals(this.cachedFormulaResultType) || "inlineStr".equals(this.cachedFormulaResultType)) {
                return CellType.STRING;
            }
            if ("str".equals(this.cachedFormulaResultType)) {
                return CellType.FORMULA;
            }
            if ("b".equals(this.cachedFormulaResultType)) {
                return CellType.BOOLEAN;
            }
            if ("e".equals(this.cachedFormulaResultType)) {
                return CellType.ERROR;
            }
            throw new UnsupportedOperationException("Unsupported cell type '" + this.cachedFormulaResultType + "'");
        }
        throw new IllegalStateException("Only formula cells have cached results");
    }

    public void setCellType(int cellType) {
        throw new NotSupportedException();
    }

    public void setCellType(CellType cellType) {
        throw new NotSupportedException();
    }

    public Sheet getSheet() {
        throw new NotSupportedException();
    }

    public void setCellValue(double value) {
        throw new NotSupportedException();
    }

    public void setCellValue(Date value) {
        throw new NotSupportedException();
    }

    public void setCellValue(Calendar value) {
        throw new NotSupportedException();
    }

    public void setCellValue(RichTextString value) {
        throw new NotSupportedException();
    }

    public void setCellValue(String value) {
        throw new NotSupportedException();
    }

    public void setCellFormula(String formula) throws FormulaParseException {
        throw new NotSupportedException();
    }

    public XSSFRichTextString getRichStringCellValue() {
        XSSFRichTextString rt;
        CellType cellType = this.getCellTypeEnum();
        switch (cellType) {
            case BLANK: {
                rt = new XSSFRichTextString("");
                break;
            }
            case STRING: {
                rt = new XSSFRichTextString(this.getStringCellValue());
                break;
            }
            default: {
                throw new NotSupportedException();
            }
        }
        return rt;
    }

    public void setCellValue(boolean value) {
        throw new NotSupportedException();
    }

    public void setCellErrorValue(byte value) {
        throw new NotSupportedException();
    }

    public byte getErrorCellValue() {
        throw new NotSupportedException();
    }

    public void setAsActiveCell() {
        throw new NotSupportedException();
    }

    public CellAddress getAddress() {
        throw new NotSupportedException();
    }

    public void setCellComment(Comment comment) {
        throw new NotSupportedException();
    }

    public Comment getCellComment() {
        throw new NotSupportedException();
    }

    public void removeCellComment() {
        throw new NotSupportedException();
    }

    public Hyperlink getHyperlink() {
        throw new NotSupportedException();
    }

    public void setHyperlink(Hyperlink link) {
        throw new NotSupportedException();
    }

    public void removeHyperlink() {
        throw new NotSupportedException();
    }

    public CellRangeAddress getArrayFormulaRange() {
        throw new NotSupportedException();
    }

    public boolean isPartOfArrayFormulaGroup() {
        throw new NotSupportedException();
    }
}

