/*
 * Decompiled with CFR 0.152.
 */
package com.monitorjbl.xlsx.impl;

import com.monitorjbl.xlsx.exceptions.CloseException;
import com.monitorjbl.xlsx.impl.StreamingCell;
import com.monitorjbl.xlsx.impl.StreamingRow;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class StreamingSheetReader
implements Iterable<Row> {
    private static final Logger log = LoggerFactory.getLogger(StreamingSheetReader.class);
    private final SharedStringsTable sst;
    private final StylesTable stylesTable;
    private final XMLEventReader parser;
    private final DataFormatter dataFormatter = new DataFormatter();
    private int rowCacheSize;
    private List<Row> rowCache = new ArrayList<Row>();
    private Iterator<Row> rowCacheIterator;
    private String lastContents;
    private StreamingRow currentRow;
    private StreamingCell currentCell;

    public StreamingSheetReader(SharedStringsTable sst, StylesTable stylesTable, XMLEventReader parser, int rowCacheSize) {
        this.sst = sst;
        this.stylesTable = stylesTable;
        this.parser = parser;
        this.rowCacheSize = rowCacheSize;
    }

    private boolean getRow() {
        try {
            this.rowCache.clear();
            while (this.rowCache.size() < this.rowCacheSize && this.parser.hasNext()) {
                this.handleEvent(this.parser.nextEvent());
            }
            this.rowCacheIterator = this.rowCache.iterator();
            return this.rowCacheIterator.hasNext();
        }
        catch (XMLStreamException | SAXException e) {
            log.debug("End of stream");
            return false;
        }
    }

    private void handleEvent(XMLEvent event) throws SAXException {
        if (event.getEventType() == 4) {
            Characters c = event.asCharacters();
            this.lastContents = this.lastContents + c.getData();
        } else if (event.getEventType() == 1) {
            StartElement startElement = event.asStartElement();
            String tagLocalName = startElement.getName().getLocalPart();
            if ("row".equals(tagLocalName)) {
                Attribute rowIndex = startElement.getAttributeByName(new QName("r"));
                this.currentRow = new StreamingRow(Integer.parseInt(rowIndex.getValue()) - 1);
            } else if ("c".equals(tagLocalName)) {
                Attribute ref = startElement.getAttributeByName(new QName("r"));
                String[] coord = ref.getValue().split("(?<=\\D)(?=\\d)|(?<=\\d)(?=\\D)");
                this.currentCell = new StreamingCell(CellReference.convertColStringToIndex((String)coord[0]), Integer.parseInt(coord[1]) - 1);
                this.setFormatString(startElement, this.currentCell);
                Attribute type = startElement.getAttributeByName(new QName("t"));
                if (type != null) {
                    this.currentCell.setType(type.getValue());
                } else {
                    this.currentCell.setType("n");
                }
                Attribute style = startElement.getAttributeByName(new QName("s"));
                if (style != null) {
                    String indexStr = style.getValue();
                    try {
                        int index = Integer.parseInt(indexStr);
                        this.currentCell.setCellStyle((CellStyle)this.stylesTable.getStyleAt(index));
                    }
                    catch (NumberFormatException nfe) {
                        log.warn("Ignoring invalid style index {}", (Object)indexStr);
                    }
                }
            }
            this.lastContents = "";
        } else if (event.getEventType() == 2) {
            EndElement endElement = event.asEndElement();
            String tagLocalName = endElement.getName().getLocalPart();
            if ("v".equals(tagLocalName) || "t".equals(tagLocalName)) {
                this.currentCell.setRawContents(this.unformattedContents());
                this.currentCell.setContents(this.formattedContents());
            } else if ("row".equals(tagLocalName) && this.currentRow != null) {
                this.rowCache.add(this.currentRow);
            } else if ("c".equals(tagLocalName)) {
                this.currentRow.getCellMap().put(this.currentCell.getColumnIndex(), this.currentCell);
            }
        }
    }

    void setFormatString(StartElement startElement, StreamingCell cell) {
        Attribute cellStyle = startElement.getAttributeByName(new QName("s"));
        String cellStyleString = cellStyle != null ? cellStyle.getValue() : null;
        XSSFCellStyle style = null;
        if (cellStyleString != null) {
            style = this.stylesTable.getStyleAt(Integer.parseInt(cellStyleString));
        } else if (this.stylesTable.getNumCellStyles() > 0) {
            style = this.stylesTable.getStyleAt(0);
        }
        if (style != null) {
            cell.setNumericFormatIndex(style.getDataFormat());
            String formatString = style.getDataFormatString();
            if (formatString != null) {
                cell.setNumericFormat(formatString);
            } else {
                cell.setNumericFormat(BuiltinFormats.getBuiltinFormat((int)cell.getNumericFormatIndex().shortValue()));
            }
        } else {
            cell.setNumericFormatIndex(null);
            cell.setNumericFormat(null);
        }
    }

    String formattedContents() {
        switch (this.currentCell.getType()) {
            case "s": {
                int idx = Integer.parseInt(this.lastContents);
                return new XSSFRichTextString(this.sst.getEntryAt(idx)).toString();
            }
            case "inlineStr": {
                return new XSSFRichTextString(this.lastContents).toString();
            }
            case "str": {
                return '\"' + this.lastContents + '\"';
            }
            case "e": {
                return "ERROR:  " + this.lastContents;
            }
            case "n": {
                if (this.currentCell.getNumericFormat() != null && this.lastContents.length() > 0) {
                    return this.dataFormatter.formatRawCellContents(Double.parseDouble(this.lastContents), (int)this.currentCell.getNumericFormatIndex().shortValue(), this.currentCell.getNumericFormat());
                }
                return this.lastContents;
            }
        }
        return this.lastContents;
    }

    String unformattedContents() {
        switch (this.currentCell.getType()) {
            case "s": {
                int idx = Integer.parseInt(this.lastContents);
                return new XSSFRichTextString(this.sst.getEntryAt(idx)).toString();
            }
            case "inlineStr": {
                return new XSSFRichTextString(this.lastContents).toString();
            }
        }
        return this.lastContents;
    }

    @Override
    public Iterator<Row> iterator() {
        return new StreamingRowIterator();
    }

    public void close() {
        try {
            this.parser.close();
        }
        catch (XMLStreamException e) {
            throw new CloseException(e);
        }
    }

    static File writeInputStreamToFile(InputStream is, int bufferSize) throws IOException {
        File f = Files.createTempFile("tmp-", ".xlsx", new FileAttribute[0]).toFile();
        try (FileOutputStream fos = new FileOutputStream(f);){
            int read;
            byte[] bytes = new byte[bufferSize];
            while ((read = is.read(bytes)) != -1) {
                fos.write(bytes, 0, read);
            }
            is.close();
            fos.close();
            File file = f;
            return file;
        }
    }

    class StreamingRowIterator
    implements Iterator<Row> {
        public StreamingRowIterator() {
            if (StreamingSheetReader.this.rowCacheIterator == null) {
                this.hasNext();
            }
        }

        @Override
        public boolean hasNext() {
            return StreamingSheetReader.this.rowCacheIterator != null && StreamingSheetReader.this.rowCacheIterator.hasNext() || StreamingSheetReader.this.getRow();
        }

        @Override
        public Row next() {
            return (Row)StreamingSheetReader.this.rowCacheIterator.next();
        }

        @Override
        public void remove() {
            throw new RuntimeException("NotSupported");
        }
    }
}

