/*
 * Decompiled with CFR 0.152.
 */
package com.monitorjbl.json;

import com.monitorjbl.json.JsonView;
import com.monitorjbl.json.Match;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class DefaultView {
    private final Map<Class, Match> matches = new HashMap<Class, Match>();

    private DefaultView() {
    }

    public JsonView getMatch(Object obj) {
        if (obj == null) {
            return null;
        }
        JsonView view = JsonView.with((Object)obj);
        boolean found = false;
        if (obj instanceof Collection) {
            for (Object o : (Collection)obj) {
                Match m = this.contains(o.getClass());
                if (m == null) continue;
                view = view.onClass(o.getClass(), m);
                found = true;
            }
        } else if (obj instanceof Map) {
            Map map = (Map)obj;
            for (Map.Entry e : map.entrySet()) {
                Match k = this.contains(e.getKey().getClass());
                Match v = this.contains(e.getValue().getClass());
                if (k != null) {
                    view = view.onClass(e.getKey().getClass(), k);
                    found = true;
                }
                if (v == null) continue;
                view = view.onClass(e.getValue().getClass(), v);
                found = true;
            }
        } else {
            Match m = this.contains(obj.getClass());
            if (m != null) {
                view = view.onClass(obj.getClass(), m);
                found = true;
            }
        }
        if (found) {
            return view;
        }
        return null;
    }

    public DefaultView onClass(Class cls, Match match) {
        this.matches.put(cls, match);
        return this;
    }

    private Match contains(Class cls) {
        if (cls == null) {
            return null;
        }
        Class current = cls;
        while (!current.equals(Object.class)) {
            if (this.matches.containsKey(current)) {
                return this.matches.get(current);
            }
            for (Class<?> iface : cls.getInterfaces()) {
                if (!this.matches.containsKey(iface)) continue;
                return this.matches.get(iface);
            }
            current = current.getSuperclass();
        }
        return null;
    }

    public static DefaultView create() {
        return new DefaultView();
    }
}

