/*
 * Decompiled with CFR 0.152.
 */
package com.monitorjbl.json;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;

public class Match {
    private final Set<String> includes = new HashSet<String>();
    private final Set<String> excludes = new HashSet<String>();
    private final Map<String, BiFunction<Object, Object, Object>> transforms = new HashMap<String, BiFunction<Object, Object, Object>>();

    Match() {
    }

    public Match include(String ... fields) {
        if (fields != null) {
            this.includes.addAll(Arrays.asList(fields));
        }
        return this;
    }

    public Match exclude(String ... fields) {
        if (fields != null) {
            this.excludes.addAll(Arrays.asList(fields));
        }
        return this;
    }

    public <X, Y, Z> Match transform(String field, BiFunction<X, Y, Z> transformer) {
        this.transforms.put(field, transformer);
        return this;
    }

    Set<String> getIncludes() {
        return this.includes;
    }

    Set<String> getExcludes() {
        return this.excludes;
    }

    Map<String, BiFunction<Object, Object, Object>> getTransforms() {
        return this.transforms;
    }

    public static Match match() {
        return new Match();
    }

    public String toString() {
        return "Match{includes=" + this.includes + ", excludes=" + this.excludes + ", transforms=" + this.transforms + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Match match = (Match)o;
        if (this.includes != null ? !this.includes.equals(match.includes) : match.includes != null) {
            return false;
        }
        if (this.excludes != null ? !this.excludes.equals(match.excludes) : match.excludes != null) {
            return false;
        }
        return this.transforms != null ? this.transforms.equals(match.transforms) : match.transforms == null;
    }

    public int hashCode() {
        int result = this.includes != null ? this.includes.hashCode() : 0;
        result = 31 * result + (this.excludes != null ? this.excludes.hashCode() : 0);
        result = 31 * result + (this.transforms != null ? this.transforms.hashCode() : 0);
        return result;
    }
}

