/*
 * Decompiled with CFR 0.152.
 */
package com.monday_consulting.maven.plugins.fsm.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.codehaus.plexus.util.xml.Xpp3Dom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Xpp3DomIterator
implements Iterator<Xpp3Dom>,
Iterable<Xpp3Dom> {
    private Xpp3Dom root;
    private LinkedList<Xpp3Dom> list = new LinkedList();
    private Xpp3Dom current;

    public Xpp3DomIterator(Xpp3Dom dom) {
        this.root = dom;
        this.list.add(this.root);
    }

    @Override
    public boolean hasNext() {
        return this.current != null && 0 < this.current.getChildCount() || !this.list.isEmpty();
    }

    @Override
    public Xpp3Dom next() {
        if (this.current == null) {
            this.current = this.list.isEmpty() ? null : this.list.pop();
        } else if (0 < this.current.getChildCount()) {
            this.list.addAll(0, Arrays.asList(this.current.getChildren()));
            this.current = this.list.pop();
        } else {
            this.current = !this.list.isEmpty() ? this.list.pop() : null;
        }
        return this.current;
    }

    @Override
    public void remove() {
        if (this.current != null) {
            Xpp3Dom parent = this.current.getParent();
            if (parent == null) {
                this.list.clear();
                this.root = null;
            } else {
                int pos = -1;
                Xpp3Dom[] arr = parent.getChildren();
                for (int i = 0; i < arr.length; ++i) {
                    if (!arr[i].getName().equals(this.current.getName())) continue;
                    pos = i;
                    break;
                }
                if (-1 < pos) {
                    parent.removeChild(pos);
                    this.current = null;
                }
            }
        }
    }

    @Override
    public Iterator<Xpp3Dom> iterator() {
        return this;
    }
}

