/*
 * Decompiled with CFR 0.152.
 */
package com.monday_consulting.maven.plugins.fsm.util;

import com.monday_consulting.maven.plugins.fsm.util.Module;
import com.monday_consulting.maven.plugins.fsm.util.Xpp3DomIterator;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrototypeXml {
    private final Log log;
    private final List<DependencyJoint> dependencyJointList = new ArrayList<DependencyJoint>();
    private Xpp3Dom prototypeDom;

    public PrototypeXml(Log log, File prototypeXml) throws XmlPullParserException, IOException {
        this.log = log;
        this.prototypeDom = Xpp3DomBuilder.build((Reader)new XmlStreamReader(prototypeXml));
        if (log.isDebugEnabled()) {
            this.log.debug((CharSequence)"Getting dependency-joints\nDependency-Joints to fill:");
        }
        for (Xpp3Dom xpp3Dom : new Xpp3DomIterator(this.prototypeDom)) {
            if (!xpp3Dom.getName().equals("dependencies")) continue;
            if (xpp3Dom.getValue().equals("")) {
                log.error((CharSequence)"Prototype-Xml-Error:\nTried to retrieve dependency-joint, but because its value was empty, no connection to a module can be made");
            }
            this.dependencyJointList.add(new DependencyJoint(xpp3Dom.getValue(), xpp3Dom));
            if (!log.isDebugEnabled()) continue;
            log.debug((CharSequence)("\t" + xpp3Dom.getValue()));
        }
    }

    public void fillPrototypeDom(Map<String, Module> moduleList) throws MojoExecutionException {
        for (DependencyJoint dJ : this.dependencyJointList) {
            Module moduleToInsert = moduleList.get(dJ.getDependencyTagValue());
            if (moduleToInsert == null) {
                throw new MojoExecutionException("For the to be added Dependencies for the DependencyTagValue: " + dJ.getDependencyTagValue() + " no configuration could be found");
            }
            Xpp3Dom domToInsert = moduleToInsert.getModuleDependencyDom();
            Xpp3Dom dom = dJ.getRoot();
            Xpp3Dom parent = dom.getParent();
            if (parent == null) {
                this.prototypeDom = domToInsert;
                this.log.warn((CharSequence)("Insert-Into-Prototype-Dom-Error\nDependency-Joint-Dom: " + dom.getName() + " has no Elements?! Dependencies cant be added as root"));
                continue;
            }
            int pos = -1;
            Xpp3Dom[] arr = parent.getChildren();
            for (int i = 0; i < arr.length; ++i) {
                if (!arr[i].equals((Object)dom)) continue;
                pos = i;
                break;
            }
            if (-1 < pos) {
                parent.removeChild(pos);
            } else {
                this.log.warn((CharSequence)("Insert-Into-Prototype-Dom-Error\nDependency-Joint-Dom: " + dom.getName() + " was not found in parent! It will be added as child under root"));
                parent.addChild(domToInsert);
            }
            for (Xpp3Dom d : domToInsert.getChildren()) {
                parent.addChild(d);
            }
        }
    }

    public Xpp3Dom getPrototypeDom() {
        return this.prototypeDom;
    }

    private static final class DependencyJoint {
        private final String dependencyTagValue;
        private final Xpp3Dom root;

        public DependencyJoint(String dependencyTagValue, Xpp3Dom root) {
            this.dependencyTagValue = dependencyTagValue;
            this.root = root;
        }

        public String getDependencyTagValue() {
            return this.dependencyTagValue;
        }

        public Xpp3Dom getRoot() {
            return this.root;
        }
    }
}

