/*
 * Decompiled with CFR 0.152.
 */
package com.monday_consulting.maven.plugins.fsm.util;

import com.monday_consulting.maven.plugins.fsm.jaxb.ExcludeType;
import com.monday_consulting.maven.plugins.fsm.jaxb.IncludeType;
import com.monday_consulting.maven.plugins.fsm.jaxb.ModuleType;
import com.monday_consulting.maven.plugins.fsm.jaxb.Resource;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.xml.Xpp3Dom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Module {
    private final Log log;
    private final ModuleType moduleType;
    private final String prefix;
    private final List<String> dependencyScopes;
    private final String dependencyTagValueInXml;
    private final Resource resource;
    private String groupId;
    private String artifactId;
    private String type;
    private String version;
    private String classifier;
    private MavenProject project;
    private List<Artifact> resolvedModuleArtifacts;
    private Xpp3Dom moduleDependencyDom;

    public Module(Log log, ModuleType moduleType, List<String> scopes) throws MojoFailureException, MojoExecutionException {
        this.log = log;
        this.moduleType = moduleType;
        String[] coords = moduleType.getId().split(":");
        if (coords.length < 1) {
            throw new MojoExecutionException("Module-Construction failed: artifactString <=> artifact-coords are empty");
        }
        if (coords.length >= 1) {
            this.groupId = coords[0];
        }
        if (coords.length >= 2) {
            this.artifactId = coords[1];
        }
        if (coords.length >= 3) {
            this.type = coords[2];
        }
        if (coords.length >= 4) {
            this.version = coords[3];
        }
        if (coords.length >= 5) {
            this.classifier = coords[4];
        }
        this.prefix = this.moduleType.getPrefix();
        this.dependencyScopes = scopes;
        this.dependencyTagValueInXml = this.moduleType.getDependencyTagValueInXml();
        this.resource = this.moduleType.getResource();
    }

    private Xpp3Dom getWebResourceTmpDom(String name, String dirPath) {
        Xpp3Dom tmpDom = new Xpp3Dom("resource");
        tmpDom.setAttribute("target", "/" + dirPath.replace("\\", "/"));
        String prefix = this.getResource().getPrefix();
        prefix = prefix == null ? "" : prefix;
        String value = prefix + name;
        tmpDom.setValue(value.replace("\\", "/"));
        return tmpDom;
    }

    public void setResolvedModuleArtifacts(List<Artifact> resolvedModuleArtifacts) throws MojoFailureException {
        this.resolvedModuleArtifacts = resolvedModuleArtifacts;
        boolean isJarArtifact = this.getProject().getArtifact().getType().equals("jar");
        if (isJarArtifact) {
            if (this.project == null) {
                throw new MojoFailureException("For this module no maven project was set.");
            }
            this.log.info((CharSequence)("Adding the project-artifact itself: " + this.project.getArtifact().getArtifactId() + ", with absolute-file: " + this.project.getArtifact().getFile().getAbsoluteFile() + "; finalname: " + this.project.getBuild().getFinalName()));
            resolvedModuleArtifacts.add(this.project.getArtifact());
        }
        this.moduleDependencyDom = this.fillDependenciesXml(isJarArtifact, this.getFilteredModuleArtifacts(resolvedModuleArtifacts), this.getIncludes(), this.getExcludes(this.getIncludes()));
    }

    private Xpp3Dom fillDependenciesXml(boolean isJarArtifact, List<Artifact> filteredModuleArtifacts, Map<String, IncludeType> includes, Map<String, ExcludeType> excludes) throws MojoFailureException {
        Xpp3Dom tmpDom;
        Xpp3Dom dom = new Xpp3Dom("root");
        for (Artifact artifact : filteredModuleArtifacts) {
            tmpDom = new Xpp3Dom("resource");
            if (this.moduleType.getFirstSpiritScope() != null && !this.moduleType.getFirstSpiritScope().isEmpty()) {
                tmpDom.setAttribute("scope", this.moduleType.getFirstSpiritScope().trim());
            }
            ExcludeType excludeType = excludes.get(artifact.getArtifactId());
            IncludeType includeType = includes.get(artifact.getArtifactId());
            if (excludeType != null) {
                this.log.info((CharSequence)("Artifact: " + artifact.getArtifactId() + " excluded!"));
                excludes.remove(excludeType.getArtifactId());
                continue;
            }
            if (includeType != null) {
                if (Boolean.valueOf(includeType.getOverride()).booleanValue()) {
                    this.log.info((CharSequence)("Artifact: " + artifact.getArtifactId() + " overridden by Include"));
                    tmpDom.setValue(this.getPrefix() + includeType.getFileName());
                } else {
                    this.log.info((CharSequence)("Artifact: " + includeType.getArtifactId() + " is defined in Includes, but is not set to override existing dependencies"));
                    tmpDom.setValue(this.getPrefix() + artifact.getFile().getAbsoluteFile());
                    dom.addChild(tmpDom);
                }
                includes.remove(includeType.getArtifactId());
                continue;
            }
            tmpDom.setValue(this.getPrefix() + artifact.getFile().getName());
            dom.addChild(tmpDom);
        }
        for (String excludeKey : excludes.keySet()) {
            this.log.info((CharSequence)("Artifact: " + excludeKey + " defined but not used!"));
        }
        for (IncludeType includeType : includes.values()) {
            this.log.info((CharSequence)("Artifact: " + includeType.getArtifactId() + " included"));
            tmpDom = new Xpp3Dom("resource");
            if (this.moduleType.getFirstSpiritScope() != null && !this.moduleType.getFirstSpiritScope().isEmpty()) {
                tmpDom.setAttribute("scope", this.moduleType.getFirstSpiritScope().trim());
            }
            tmpDom.setValue(this.getPrefix() + includeType.getFileName());
            dom.addChild(tmpDom);
        }
        if (!isJarArtifact) {
            this.handleArchiveFileIncludes(dom);
        }
        return dom;
    }

    private Map<String, ExcludeType> getExcludes(Map<String, IncludeType> includes) throws MojoFailureException {
        HashMap<String, ExcludeType> excludes = new HashMap<String, ExcludeType>();
        if (this.moduleType.getExcludes() != null) {
            for (ExcludeType excludeType : this.moduleType.getExcludes().getExclude()) {
                if (Boolean.valueOf(excludeType.getOverrideIncludes()).booleanValue() && includes.containsKey(excludeType.getArtifactId())) {
                    this.log.info((CharSequence)("Possible configuration problem: Excluding the configured Inclusion of Artifact: " + excludeType.getArtifactId()));
                    includes.remove(excludeType.getArtifactId());
                }
                if (excludes.containsKey(excludeType.getArtifactId())) {
                    throw new MojoFailureException("Exclusion of ArtifactId: " + excludeType.getArtifactId() + " is defined twice!");
                }
                excludes.put(excludeType.getArtifactId(), excludeType);
            }
        }
        return excludes;
    }

    private Map<String, IncludeType> getIncludes() throws MojoFailureException {
        HashMap<String, IncludeType> includes = new HashMap<String, IncludeType>();
        if (this.moduleType.getIncludes() != null) {
            for (IncludeType includeType : this.moduleType.getIncludes().getInclude()) {
                if (includes.containsKey(includeType.getArtifactId())) {
                    throw new MojoFailureException("Inclusion of ArtifactId: " + includeType.getArtifactId() + " is defined twice!");
                }
                includes.put(includeType.getArtifactId(), includeType);
            }
        }
        return includes;
    }

    private List<Artifact> getFilteredModuleArtifacts(List<Artifact> resolvedModuleArtifacts) {
        ArrayList<Artifact> filteredModuleArtifacts = new ArrayList<Artifact>();
        this.log.info((CharSequence)("Plugin will include dependencies with scope null for the project-artifact itself and with user defined scopes: " + Arrays.toString(this.dependencyScopes.toArray())));
        for (Artifact resolvedModuleArtifact : resolvedModuleArtifacts) {
            if (this.dependencyScopes.contains(resolvedModuleArtifact.getScope()) || resolvedModuleArtifact.getScope() == null) {
                this.log.info((CharSequence)(" +included: " + resolvedModuleArtifact.getArtifactId() + " with scope: " + resolvedModuleArtifact.getScope()));
                filteredModuleArtifacts.add(resolvedModuleArtifact);
                continue;
            }
            this.log.info((CharSequence)(" -filtered: " + resolvedModuleArtifact.getArtifactId() + " with scope: " + resolvedModuleArtifact.getScope()));
        }
        return Collections.unmodifiableList(filteredModuleArtifacts);
    }

    private void handleArchiveFileIncludes(Xpp3Dom dom) throws MojoFailureException {
        try {
            Resource resource;
            if (this.project == null) {
                throw new MojoFailureException("For this module no maven project was set.");
            }
            String targetFileDir = "/target/" + this.project.getName() + "-" + this.project.getVersion();
            File baseDir = new File(this.project.getBasedir() + targetFileDir);
            if (!baseDir.exists()) {
                File artifactFile = this.project.getArtifact().getFile();
                ZipFile fileToExtract = new ZipFile(artifactFile);
                baseDir = new File(this.project.getParent().getBasedir().getAbsolutePath() + targetFileDir);
                fileToExtract.extractAll(baseDir.getAbsolutePath());
            }
            if ((resource = this.getResource()) == null) {
                throw new MojoFailureException("Module " + this.project.getArtifactId() + " from archive type " + this.project.getArtifact().getType() + " detected. No <resource> configuration found");
            }
            if (resource.getPrefix() == null || resource.getPrefix().isEmpty()) {
                this.log.warn((CharSequence)"No <prefix> defined. Prefix would be set to root");
            } else {
                if (resource.getIncludes() == null || resource.getIncludes().getInclude() == null || resource.getIncludes().getInclude().isEmpty()) {
                    throw new MojoFailureException("Module " + this.project.getArtifactId() + " from archive type " + this.project.getArtifact().getType() + " detected. No <includes> configured");
                }
                if (resource.getWebXml() == null || resource.getWebXml().isEmpty()) {
                    throw new MojoFailureException("Module " + this.project.getArtifactId() + " from archive type " + this.project.getArtifact().getType() + " detected. No <web-xml> defined");
                }
            }
            List<String> includes = resource.getIncludes().getInclude();
            List<Object> excludes = resource.getExcludes() != null ? resource.getExcludes().getExclude() : new ArrayList();
            excludes.add(resource.getWebXml());
            DirectoryScanner ds = new DirectoryScanner();
            ds.setIncludes(includes.toArray(new String[includes.size()]));
            ds.setExcludes(excludes.toArray(new String[excludes.size()]));
            ds.setBasedir(baseDir);
            ds.setCaseSensitive(true);
            ds.scan();
            for (String incl : ds.getIncludedFiles()) {
                int indexOf = incl.lastIndexOf(File.separator);
                String dir = "";
                if (indexOf > 0) {
                    dir = incl.substring(0, indexOf);
                }
                this.log.info((CharSequence)(" +included: Archive resource: " + incl));
                dom.addChild(this.getWebResourceTmpDom(incl, dir));
            }
        }
        catch (ZipException e) {
            throw new MojoFailureException("Could not extract artifact file.", (Throwable)e);
        }
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getDependencyTagValueInXml() {
        return this.dependencyTagValueInXml;
    }

    public Resource getResource() {
        return this.resource;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public List<Artifact> getResolvedModuleArtifacts() {
        return this.resolvedModuleArtifacts;
    }

    public Xpp3Dom getModuleDependencyDom() {
        return this.moduleDependencyDom;
    }

    public List<String> getDependencyScopes() {
        return this.dependencyScopes;
    }
}

