/*
 * Decompiled with CFR 0.152.
 */
package com.monday_consulting.maven.plugins.fsm;

import com.monday_consulting.maven.plugins.fsm.jaxb.FsmMavenPluginType;
import com.monday_consulting.maven.plugins.fsm.jaxb.ModuleType;
import com.monday_consulting.maven.plugins.fsm.util.Module;
import com.monday_consulting.maven.plugins.fsm.util.PrototypeXml;
import com.monday_consulting.maven.plugins.fsm.util.XmlValidationEventHandler;
import com.monday_consulting.maven.plugins.fsm.util.resolver.MavenGetArtifactsResolver;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="dependencyToXML", defaultPhase=LifecyclePhase.PACKAGE, aggregator=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public class DependencyToXMLMojo
extends AbstractMojo {
    @Component
    private RepositorySystem repoSystem;
    @Component
    private ProjectBuilder projectBuilder;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject mavenProject;
    @Parameter(defaultValue="${reactorProjects}", readonly=true)
    private List<MavenProject> reactorProjects;
    @Parameter(defaultValue="${configXml}")
    private File configXml;
    @Parameter(defaultValue="${prototypeXml}")
    private File prototypeXml;
    @Parameter(defaultValue="${targetXml}")
    private File targetXml;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.getLog().info((CharSequence)"***Starting DependencyToXMLMojo");
            this.checkReactor(this.reactorProjects);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"Create config-xml-Object");
            }
            FsmMavenPluginType config = this.bindXmlConfigToPojo(this.configXml);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"Creating PrototypeXml-Object");
            }
            PrototypeXml prototype = new PrototypeXml(this.getLog(), this.prototypeXml);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Getting target-file: " + this.targetXml.getAbsoluteFile()));
                this.getLog().debug((CharSequence)"Enhance created Modules");
            }
            MavenGetArtifactsResolver resolver = new MavenGetArtifactsResolver(this.getLog(), this.reactorProjects, this.repoSystem, this.repoSession, this.projectBuilder, this.mavenProject);
            HashMap<String, Module> modules = new HashMap<String, Module>();
            for (ModuleType moduleType : config.getModules().getModule()) {
                if (modules.containsKey(moduleType.getDependencyTagValueInXml())) {
                    throw new MojoFailureException("Properties for Module: " + moduleType.getDependencyTagValueInXml() + "defined twice\tFix to prevent unpredictable behaviour!\tPlease contact Responsible Developer, XSD has to be fixed!");
                }
                modules.put(moduleType.getDependencyTagValueInXml(), resolver.resolve(moduleType, config.getScopes().getScope()));
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"Enhance Prototype for TargetXml");
            }
            prototype.fillPrototypeDom(modules);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"Write TargetXml-File");
            }
            this.writeDomToTarget(this.targetXml, prototype.getPrototypeDom());
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Dependencies written to Module-XML:\n\t" + prototype.getPrototypeDom().toString()));
            }
            this.getLog().info((CharSequence)"***DependencyToXMLMojo finished");
        }
        catch (XmlPullParserException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void checkReactor(List<MavenProject> reactorProjects) {
        for (MavenProject reactorProject : reactorProjects) {
            String msg = "Check resolved Artifacts for: \ngroudId:    " + reactorProject.getGroupId() + "\nartifactId: " + reactorProject.getArtifactId() + "\nversion:    " + reactorProject.getVersion();
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)msg);
            }
            if (reactorProject.getArtifacts() == null || reactorProject.getArtifacts().isEmpty()) {
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)"+  Dependencies not resolved or Reactor-Project has no dependencies!");
                continue;
            }
            for (Artifact artifact : reactorProject.getArtifacts()) {
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("  + " + artifact.getGroupId() + " : " + artifact.getArtifactId() + " : " + artifact.getVersion() + " : " + artifact.getType() + " : " + artifact.getFile()));
            }
        }
    }

    private FsmMavenPluginType bindXmlConfigToPojo(File configXml) throws MojoExecutionException {
        this.getLog().debug((CharSequence)"***Constructing ConfigXml-Object");
        try {
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = sf.newSchema(((Object)((Object)this)).getClass().getResource("/fsm-plugin.xsd"));
            StreamSource streamSource = new StreamSource(configXml);
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{FsmMavenPluginType.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            unmarshaller.setSchema(schema);
            unmarshaller.setEventHandler((ValidationEventHandler)new XmlValidationEventHandler(this.getLog()));
            JAXBElement jaxbElement = unmarshaller.unmarshal((Source)streamSource, FsmMavenPluginType.class);
            return (FsmMavenPluginType)jaxbElement.getValue();
        }
        catch (SAXException e) {
            throw new MojoExecutionException((Object)e, "Error while parsing file with SAX", e.getMessage());
        }
        catch (JAXBException e) {
            throw new MojoExecutionException((Object)e, "Error while binding xml-file with JAXB", e.getMessage());
        }
    }

    private void writeDomToTarget(File target, Xpp3Dom dom) throws IOException {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("writing: " + dom.getName() + " to: " + target.getAbsoluteFile()));
        }
        XmlStreamWriter writer = WriterFactory.newXmlWriter((File)target);
        PrettyPrintXMLWriter pretty = new PrettyPrintXMLWriter((Writer)writer);
        Xpp3DomWriter.write((XMLWriter)pretty, (Xpp3Dom)dom);
        writer.close();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)(dom.getName() + " written to: " + target.getAbsoluteFile()));
        }
    }
}

