/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.cmd.parser;

import com.moilioncircle.redis.replicator.cmd.CommandParser;
import com.moilioncircle.redis.replicator.cmd.CommandParsers;
import com.moilioncircle.redis.replicator.cmd.impl.XGroupCommand;
import com.moilioncircle.redis.replicator.cmd.impl.XGroupCreateCommand;
import com.moilioncircle.redis.replicator.cmd.impl.XGroupDelConsumerCommand;
import com.moilioncircle.redis.replicator.cmd.impl.XGroupDestroyCommand;
import com.moilioncircle.redis.replicator.cmd.impl.XGroupSetIdCommand;
import com.moilioncircle.redis.replicator.util.Strings;

public class XGroupParser
implements CommandParser<XGroupCommand> {
    @Override
    public XGroupCommand parse(Object[] command) {
        String next;
        int idx = 1;
        if (Strings.isEquals(next = CommandParsers.toRune(command[idx++]), "CREATE")) {
            byte[] key = CommandParsers.toBytes(command[idx]);
            byte[] group = CommandParsers.toBytes(command[++idx]);
            byte[] id = CommandParsers.toBytes(command[++idx]);
            if (++idx >= command.length) {
                return new XGroupCreateCommand(key, group, id, false);
            }
            if (Strings.isEquals(next = CommandParsers.toRune(command[idx++]), "MKSTREAM")) {
                return new XGroupCreateCommand(key, group, id, true);
            }
            throw new UnsupportedOperationException(next);
        }
        if (Strings.isEquals(next, "SETID")) {
            byte[] key = CommandParsers.toBytes(command[idx]);
            byte[] group = CommandParsers.toBytes(command[++idx]);
            byte[] id = CommandParsers.toBytes(command[++idx]);
            ++idx;
            return new XGroupSetIdCommand(key, group, id);
        }
        if (Strings.isEquals(next, "DESTROY")) {
            byte[] key = CommandParsers.toBytes(command[idx]);
            byte[] group = CommandParsers.toBytes(command[++idx]);
            ++idx;
            return new XGroupDestroyCommand(key, group);
        }
        if (Strings.isEquals(next, "DELCONSUMER")) {
            byte[] key = CommandParsers.toBytes(command[idx]);
            byte[] group = CommandParsers.toBytes(command[++idx]);
            byte[] consumer = CommandParsers.toBytes(command[++idx]);
            ++idx;
            return new XGroupDelConsumerCommand(key, group, consumer);
        }
        throw new UnsupportedOperationException(next);
    }
}

