/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.cmd;

import com.moilioncircle.redis.replicator.cmd.RedisCodec;
import com.moilioncircle.redis.replicator.io.RedisInputStream;
import java.io.IOException;

@FunctionalInterface
public interface BulkReplyHandler {
    public byte[] handle(long var1, RedisInputStream var3) throws IOException;

    public static class SimpleBulkReplyHandler
    implements BulkReplyHandler {
        private final RedisCodec codec;

        public SimpleBulkReplyHandler() {
            this.codec = null;
        }

        public SimpleBulkReplyHandler(RedisCodec codec) {
            this.codec = codec;
        }

        @Override
        public byte[] handle(long len, RedisInputStream in) throws IOException {
            byte[] reply = len == 0L ? new byte[]{} : in.readBytes(len).first();
            int c = in.read();
            if (c != 13) {
                throw new AssertionError((Object)("expect '\\r' but :" + (char)c));
            }
            c = in.read();
            if (c != 10) {
                throw new AssertionError((Object)("expect '\\n' but :" + (char)c));
            }
            return this.codec == null ? reply : this.codec.decode(reply);
        }
    }
}

