/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.cmd.parser;

import com.moilioncircle.redis.replicator.cmd.CommandParser;
import com.moilioncircle.redis.replicator.cmd.impl.ExistType;
import com.moilioncircle.redis.replicator.cmd.impl.ZAddCommand;
import com.moilioncircle.redis.replicator.cmd.parser.CommandParsers;
import com.moilioncircle.redis.replicator.rdb.datatype.ZSetEntry;
import java.util.ArrayList;

public class ZAddParser
implements CommandParser<ZAddCommand> {
    @Override
    public ZAddCommand parse(Object[] command) {
        int idx = 1;
        Boolean isCh = null;
        Boolean isIncr = null;
        ExistType existType = ExistType.NONE;
        ArrayList<ZSetEntry> list = new ArrayList<ZSetEntry>();
        String key = CommandParsers.objToString(command[idx]);
        byte[] rawKey = CommandParsers.objToBytes(command[idx]);
        ++idx;
        boolean et = false;
        while (idx < command.length) {
            String param = CommandParsers.objToString(command[idx]);
            if (!et && "NX".equalsIgnoreCase(param)) {
                existType = ExistType.NX;
                et = true;
                ++idx;
                continue;
            }
            if (!et && "XX".equalsIgnoreCase(param)) {
                existType = ExistType.XX;
                et = true;
                ++idx;
                continue;
            }
            if (isCh == null && "CH".equalsIgnoreCase(param)) {
                isCh = true;
            } else if (isIncr == null && "INCR".equalsIgnoreCase(param)) {
                isIncr = true;
            } else {
                double score = Double.parseDouble(param);
                String member = CommandParsers.objToString(command[++idx]);
                byte[] rawMember = CommandParsers.objToBytes(command[idx]);
                list.add(new ZSetEntry(member, score, rawMember));
            }
            ++idx;
        }
        ZSetEntry[] zSetEntries = new ZSetEntry[list.size()];
        list.toArray(zSetEntries);
        return new ZAddCommand(key, existType, isCh, isIncr, zSetEntries, rawKey);
    }
}

