/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.analytics;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.moe.pushlibrary.MoEHelper;
import com.moe.pushlibrary.models.Event;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.Logger;
import com.moengage.core.MoECoreEvaluator;
import com.moengage.core.MoEDAO;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.MoEUtils;
import com.moengage.core.analytics.SourceProcessor;
import com.moengage.core.model.RemoteConfig;
import com.moengage.core.model.TrafficSource;
import com.moengage.core.model.UserSession;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class AnalyticsHelper {
    private static final String TAG = "AnalyticsHelper";
    private static AnalyticsHelper instance = null;
    private UserSession session;
    private MoECoreEvaluator evaluator;
    private SourceProcessor sourceProcessor;

    private AnalyticsHelper(Context context) {
        this.session = MoEDAO.getInstance(context).getLastSavedSession();
        this.evaluator = MoEDispatcher.getInstance(context).getCoreEvaluator();
        this.sourceProcessor = new SourceProcessor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AnalyticsHelper getInstance(Context context) {
        if (instance != null) return instance;
        Class<AnalyticsHelper> clazz = AnalyticsHelper.class;
        synchronized (AnalyticsHelper.class) {
            if (instance != null) return instance;
            instance = new AnalyticsHelper(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public void onEventTracked(Event event, Context context) {
        try {
            Logger.v("AnalyticsHelper onEventTracked() : Will update last interaction time if required. Event: " + event.details);
            if (!event.isInteractiveEvent) {
                Logger.v("AnalyticsHelper onEventTracked() : No operation required. Tracked event is non-interactive");
                return;
            }
            if (event.eventName.equals("EVENT_ACTION_USER_ATTRIBUTE")) {
                Logger.v("AnalyticsHelper updateSession() : Need not update session info since user attribute is tracked.");
                return;
            }
            if (MoEHelper.isAppInForeground()) {
                Logger.v("AnalyticsHelper updateSession() : App is in foreground no action required.");
                this.updateLastInteractionTime(MoEUtils.currentTime());
                return;
            }
            if (this.session == null) {
                Logger.v("AnalyticsHelper onEventTracked() : No previous session. Will create a new session");
                this.batchPreviousDataAndCreateNewSession(context, null, true);
                return;
            }
            if (this.evaluator.hasSessionExpired(this.session.getLastInteractionTime(), RemoteConfig.getConfig().sessionInActiveTime, MoEUtils.currentTime())) {
                Logger.v("AnalyticsHelper onEventTracked() : Session has expired.");
                this.batchPreviousDataAndCreateNewSession(context, null, true);
                return;
            }
            this.updateLastInteractionTime(MoEUtils.currentTime());
        }
        catch (Exception e) {
            Logger.e("AnalyticsHelper onEventTracked() : Exception: ", e);
        }
    }

    void updateLastInteractionTime(long time) {
        if (this.session != null) {
            this.session.setLastInteractionTime(time);
        }
    }

    @WorkerThread
    public void onAppOpen(Activity activity) {
        if (this.session != null) {
            Logger.v("AnalyticsHelper onAppOpen() : Current Session " + this.session.toString());
        }
        this.updateUserSessionIfRequired(activity);
    }

    public void onNotificationClicked(Context context, Bundle pushPayload, boolean isAppInBackground) {
        try {
            TrafficSource source = null;
            Logger.v("AnalyticsHelper onNotificationClicked() : ");
            MoEHelperUtils.dumpIntentExtras(pushPayload);
            String deepLink = this.getDeepLinkFromPayload(pushPayload);
            if (!MoEUtils.isEmptyString(deepLink)) {
                Uri uri = Uri.parse((String)deepLink);
                source = this.sourceProcessor.getTrafficSourceFromUrl(uri, RemoteConfig.getConfig().additionalSourceIdentifiers);
            }
            if (source == null || TrafficSource.isEmpty(source)) {
                Bundle actionButtonExtras;
                Bundle extras = pushPayload;
                if (pushPayload.containsKey("action_payload") && (actionButtonExtras = this.getActionButtonExtras(pushPayload)) != null) {
                    extras = actionButtonExtras;
                }
                source = this.sourceProcessor.getTrafficSourceFromExtras(extras, RemoteConfig.getConfig().additionalSourceIdentifiers);
            }
            this.updateSessionIfRequired(context, source, isAppInBackground);
        }
        catch (Exception e) {
            Logger.e("AnalyticsHelper onNotificationClicked() : ", e);
        }
    }

    private Bundle getActionButtonExtras(Bundle pushPayload) {
        try {
            String actionString = pushPayload.getString("action_payload");
            JSONObject actionJson = new JSONObject(actionString);
            if ("m_nav".equals(actionJson.getString("action_tag")) && actionJson.has("extras")) {
                return MoEHelperUtils.convertJSONObjecttoBundle(actionJson.getJSONObject("extras"));
            }
        }
        catch (Exception e) {
            Logger.e("AnalyticsHelper getActionButtonExtras() : ", e);
        }
        return null;
    }

    @Nullable
    private String getDeepLinkFromPayload(Bundle pushPayload) throws JSONException {
        String actionPayload;
        JSONObject actionJson;
        if (pushPayload.containsKey("moe_webUrl")) {
            return pushPayload.getString("moe_webUrl");
        }
        if (pushPayload.containsKey("gcm_webUrl")) {
            return pushPayload.getString("gcm_webUrl");
        }
        if (pushPayload.containsKey("action_payload") && (actionJson = new JSONObject(actionPayload = pushPayload.getString("action_payload"))).has("uri")) {
            return actionJson.getString("uri");
        }
        return null;
    }

    private void updateUserSessionIfRequired(Activity activity) {
        try {
            Context context = activity.getApplicationContext();
            TrafficSource currentSource = this.sourceProcessor.getTrafficSourceFromActivity(activity, RemoteConfig.getConfig().additionalSourceIdentifiers);
            this.updateSessionIfRequired(context, currentSource, MoEHelper.isAppInBackground());
        }
        catch (Exception e) {
            Logger.e("AnalyticsHelper onAppOpen() : Exception: ", e);
        }
    }

    private void updateSessionIfRequired(Context context, TrafficSource currentSource, boolean isAppInBackground) {
        if (this.session == null) {
            Logger.v("AnalyticsHelper updateSessionIfRequired() : No saved session for user will create a new session.");
            this.batchPreviousDataAndCreateNewSession(context, currentSource, MoEHelper.isAppInBackground());
            return;
        }
        boolean hasSessionExpired = this.evaluator.hasSessionExpired(this.session.getLastInteractionTime(), RemoteConfig.getConfig().sessionInActiveTime, MoEUtils.currentTime());
        if (hasSessionExpired) {
            Logger.v("AnalyticsHelper updateSessionIfRequired() : Previous session has expired. Will create a new session.");
            this.batchPreviousDataAndCreateNewSession(context, currentSource, MoEHelper.isAppInBackground());
            return;
        }
        TrafficSource savedSource = this.session.getSource();
        boolean hasSourceChanged = this.evaluator.hasSourceChanged(savedSource, currentSource);
        if (hasSourceChanged) {
            Logger.v("AnalyticsHelper updateSessionIfRequired() : Source changed. will create a new session");
            this.batchPreviousDataAndCreateNewSession(context, currentSource, isAppInBackground);
        }
    }

    @WorkerThread
    private void batchPreviousDataAndCreateNewSession(Context context, TrafficSource currentSource, boolean isFromBackground) {
        MoEDispatcher.getInstance(context).getBatchHelper().createAndSaveBatches(context, this.session);
        MoEDispatcher.getInstance(context).sendInteractionData();
        this.createAndPersistNewSession(context, currentSource, isFromBackground);
    }

    private UserSession createAndPersistNewSession(Context context, TrafficSource currentSource, boolean isFromBackground) {
        this.session = this.createNewSession(currentSource, isFromBackground);
        Logger.v("AnalyticsHelper createAndPersistNewSession() : New session: " + this.session.toString());
        this.persistUserSession(context, this.session);
        return this.session;
    }

    private UserSession createNewSession(@Nullable TrafficSource currentSource, boolean isFromBackground) {
        long currentTime = MoEUtils.currentTime();
        UserSession session = new UserSession();
        session.setSessionId(UUID.randomUUID().toString());
        session.setStartTime(MoEUtils.getTimeInISO(currentTime));
        if (currentSource != null) {
            session.setSource(currentSource);
        }
        session.setLastInteractionTime(currentTime);
        session.setBackgroundInitiated(isFromBackground);
        return session;
    }

    private void persistUserSession(Context context, UserSession userSession) {
        MoEDAO.getInstance(context).saveUserSession(userSession);
    }

    public void onAppClose(Context context) {
        this.updateLastInteractionTime(MoEUtils.currentTime());
        this.persistUserSession(context, this.session);
    }

    @WorkerThread
    public void onLogout(Context context) {
        this.createAndPersistNewSession(context, null, MoEHelper.isAppInBackground());
    }

    @Nullable
    public UserSession getSession() {
        return this.session;
    }
}

