/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.Context;
import android.support.annotation.NonNull;
import com.moe.pushlibrary.models.Event;
import com.moe.pushlibrary.models.UserAttribute;
import com.moengage.core.Logger;
import com.moengage.core.MoEDAO;
import com.moengage.core.MoEUtils;
import com.moengage.core.events.MoEEventManager;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import org.json.JSONObject;

class SetDeviceAttributeTask
extends SDKTask {
    private static final String TAG = "SetDeviceAttributeTask";
    private JSONObject deviceAttribute;

    SetDeviceAttributeTask(@NonNull Context context, @NonNull JSONObject deviceAttribute) {
        super(context);
        this.deviceAttribute = deviceAttribute;
    }

    @Override
    public TaskResult execute() {
        try {
            Logger.v("SetDeviceAttributeTask: executing Task");
            UserAttribute currentUserAttribute = MoEUtils.getUserAttributePoJo(this.deviceAttribute);
            UserAttribute savedUserAttribute = null;
            if (currentUserAttribute != null) {
                savedUserAttribute = MoEUtils.getSavedUserAttribute(this.context, currentUserAttribute.userAttributeName);
            }
            if (MoEUtils.shouldSendUserAttribute(currentUserAttribute, savedUserAttribute)) {
                Logger.d("SetDeviceAttributeTask : setUserAttribute User attribute not yet sent to server will send : " + this.deviceAttribute.toString());
                Event event = new Event("EVENT_ACTION_DEVICE_ATTRIBUTE", this.deviceAttribute);
                MoEEventManager.getInstance(this.context).writeDataPointToStorage(event);
                MoEDAO.getInstance(this.context).addOrUpdateUserAttribute(currentUserAttribute);
                this.taskResult.setIsSuccess(true);
            } else {
                Logger.d("SetDeviceAttributeTask : setUserAttributes already sent once, need not send duplicate attribute : " + this.deviceAttribute.toString());
                this.taskResult.setIsSuccess(false);
            }
            Logger.v("SetDeviceAttributeTask: completed Task");
        }
        catch (Exception e) {
            Logger.e("SetDeviceAttributeTask execute() : Exception: ", e);
        }
        return this.taskResult;
    }

    @Override
    public String getTaskTag() {
        return "SET_DEVICE_ATTRIBUTES";
    }

    @Override
    public boolean isSynchronous() {
        return false;
    }
}

