/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.moengage.core.APIManager;
import com.moengage.core.AdvertisingIdClient;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.SdkConfig;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.core.rest.Response;
import com.moengage.core.utils.JsonBuilder;
import com.moengage.core.utils.RestUtils;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class DeviceAddTask
extends SDKTask {
    private static final String TAG = "DeviceAddTask";
    private String requestTime;
    private String batchId;
    private ConfigurationProvider provider;
    private Bundle resultBundle;
    private JSONObject devicePreference;

    DeviceAddTask(Context context, JSONObject devicePreference) {
        super(context);
        this.provider = ConfigurationProvider.getInstance(this.context);
        this.resultBundle = new Bundle();
        this.devicePreference = devicePreference;
    }

    @Override
    public TaskResult execute() {
        Logger.v("DeviceAddTask execution started");
        try {
            String appId = MoEUtils.getAppId();
            if (TextUtils.isEmpty((CharSequence)appId)) {
                Logger.e("DeviceAddTask execute: Cannot make device add call, app id not present.");
                this.taskResult.setIsSuccess(false);
                return this.taskResult;
            }
            Response response = APIManager.deviceAdd(appId, this.getBody(), this.getRequestId());
            if (response != null && response.responseCode == 200) {
                this.taskResult.setIsSuccess(true);
            }
        }
        catch (Exception e) {
            Logger.f("DeviceAddTask execute() : ", e);
        }
        Logger.v("DeviceAddTask execution completed");
        this.taskResult.setPayload(this.resultBundle);
        return this.taskResult;
    }

    @Override
    public String getTaskTag() {
        return "DEVICE_ADD";
    }

    @Override
    public boolean isSynchronous() {
        return true;
    }

    private JSONObject getSDKMeta() throws JSONException {
        JSONObject metaJSON = new JSONObject();
        this.batchId = MoEUtils.getBatchId();
        this.requestTime = MoEUtils.currentISOTime();
        metaJSON.put("bid", (Object)this.batchId).put("request_time", (Object)this.requestTime).put("dev_pref", (Object)this.devicePreference);
        return metaJSON;
    }

    private JSONObject getQueryParams() throws JSONException {
        String miPushToken;
        JsonBuilder builder = RestUtils.getDefaultParams(this.context);
        builder.putString("device_tz", TimeZone.getDefault().getID());
        String fcmToken = this.provider.getFcmToken();
        if (!TextUtils.isEmpty((CharSequence)fcmToken) && !this.provider.isPushNotificationOptedOut()) {
            builder.putString("push_id", fcmToken);
            this.resultBundle.putBoolean("is_fcm_token_present", true);
        }
        if (!TextUtils.isEmpty((CharSequence)(miPushToken = this.provider.getMiPushToken())) && !this.provider.isPushNotificationOptedOut()) {
            builder.putString("mi_push_id", miPushToken);
            this.resultBundle.putBoolean("is_gcm_token_present", true);
        }
        if (!this.provider.isDataTrackingOptedOut()) {
            String androidId = MoEUtils.getAndroidID(this.context);
            if (!TextUtils.isEmpty((CharSequence)androidId)) {
                builder.putString("android_id", androidId);
            }
            if (!SdkConfig.getConfig().isGaidTrackingOptedOut) {
                AdvertisingIdClient.AdInfo adInfo;
                String gaid = this.provider.getStoredGAID();
                if (TextUtils.isEmpty((CharSequence)gaid) && (adInfo = MoEUtils.getAdvertisementInfo(this.context)) != null) {
                    gaid = adInfo.getId();
                    this.provider.storeGAID(gaid);
                }
                if (!TextUtils.isEmpty((CharSequence)gaid)) {
                    builder.putString("moe_gaid", gaid);
                }
            }
            builder.putString("os_ver", String.valueOf(Build.VERSION.SDK_INT));
            builder.putString("model", Build.MODEL);
            builder.putString("app_version_name", this.provider.getAppVersionName());
            String nwType = MoEUtils.getNetworkType(this.context);
            if (!TextUtils.isEmpty((CharSequence)nwType)) {
                builder.putString("networkType", nwType);
            }
        }
        return builder.build();
    }

    private JSONObject getBody() throws JSONException {
        JsonBuilder requestBody = this.getDeviceInfo().putJsonObject("meta", this.getSDKMeta()).putJsonObject("query_params", this.getQueryParams());
        return requestBody.build();
    }

    private JsonBuilder getDeviceInfo() throws JSONException {
        AdvertisingIdClient.AdInfo adInfo;
        String operator;
        JsonBuilder deviceInfo = new JsonBuilder();
        if (SdkConfig.getConfig().isDeviceAttributeTrackingOptedOut || this.provider.isDataTrackingOptedOut()) {
            return deviceInfo;
        }
        deviceInfo.putString("OS_VERSION", Build.VERSION.RELEASE).putInt("OS_API_LEVEL", Build.VERSION.SDK_INT).putString("DEVICE", Build.DEVICE).putString("MODEL", Build.MODEL).putString("PRODUCT", Build.PRODUCT).putString("MANUFACTURER", Build.MANUFACTURER);
        String deviceId = MoEUtils.getAndroidID(this.context);
        if (!TextUtils.isEmpty((CharSequence)deviceId)) {
            deviceInfo.putString("DEVICE_ID", deviceId);
        }
        if (!TextUtils.isEmpty((CharSequence)(operator = MoEUtils.getOperatorName(this.context)))) {
            deviceInfo.putString("CARRIER", operator);
        }
        WindowManager wm = (WindowManager)this.context.getSystemService("window");
        DisplayMetrics outMetrics = new DisplayMetrics();
        if (wm != null) {
            wm.getDefaultDisplay().getMetrics(outMetrics);
            deviceInfo.putInt("DENSITYDPI", outMetrics.densityDpi).putInt("WIDTH", outMetrics.widthPixels).putInt("HEIGHT", outMetrics.heightPixels);
        }
        if (!SdkConfig.getConfig().isGaidTrackingOptedOut && null != (adInfo = MoEUtils.getAdvertisementInfo(this.context))) {
            deviceInfo.putString("MOE_GAID", adInfo.getId()).putInt("MOE_ISLAT", adInfo.isLimitAdTrackingEnabled());
        }
        return deviceInfo;
    }

    private String getRequestId() {
        return MoEUtils.getSha1ForString(this.batchId + this.requestTime + this.provider.getCurrentUserId());
    }
}

