/*
 * Decompiled with CFR 0.152.
 */
package com.moe.pushlibrary;

import android.location.Location;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.moe.pushlibrary.models.GeoLocation;
import com.moengage.core.ISO8601Utils;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Deprecated
public class PayloadBuilder {
    private static final String TAG = "PayloadBuilder";
    private JSONObject generalAttrs;
    private JSONObject customAttrs = new JSONObject();
    private boolean isInteractiveEvent = true;
    private boolean hasCalledNonInteractiveApi;
    private static final String ATTR_TIMESTAMP = "timestamp";
    private static final String ATTR_LOCATION = "location";
    private static final String NON_INTERACTIVE_EVENT_ATTRIBUTE = "moe_non_interactive";

    private void notNullCheck(String attrName) throws Exception {
        if (MoEUtils.isEmptyString(attrName)) {
            throw new Exception("Action name cannot be empty");
        }
    }

    @Deprecated
    public PayloadBuilder putAttrInt(String attrName, int attrValue) {
        try {
            this.notNullCheck(attrName);
            this.generalAttrs.put(attrName.trim(), attrValue);
        }
        catch (Exception e) {
            Logger.f("PayloadBuilder: putAttrInt", e);
        }
        return this;
    }

    @Deprecated
    public PayloadBuilder putAttrString(String attrName, String attrValue) {
        try {
            this.notNullCheck(attrName);
            this.generalAttrs.put(attrName.trim(), (Object)attrValue);
        }
        catch (Exception e) {
            Logger.f("PayloadBuilder: putAttrString", e);
        }
        return this;
    }

    @Deprecated
    public PayloadBuilder putAttrBoolean(String attrName, boolean attrValue) {
        try {
            this.notNullCheck(attrName);
            this.generalAttrs.put(attrName.trim(), attrValue);
        }
        catch (Exception e) {
            Logger.f("PayloadBuilder: putAttrBoolean", e);
        }
        return this;
    }

    @Deprecated
    public PayloadBuilder putAttrFloat(String attrName, float attrValue) {
        try {
            this.notNullCheck(attrName);
            this.generalAttrs.put(attrName.trim(), (double)attrValue);
        }
        catch (Exception e) {
            Logger.f("PayloadBuilder: putAttrFloat", e);
        }
        return this;
    }

    @Deprecated
    public PayloadBuilder putAttrDouble(String attrName, double attrValue) {
        try {
            this.notNullCheck(attrName);
            this.generalAttrs.put(attrName.trim(), attrValue);
        }
        catch (Exception e) {
            Logger.f("PayloadBuilder: putAttrDouble", e);
        }
        return this;
    }

    @Deprecated
    public PayloadBuilder putAttrLong(String attrName, long attrValue) {
        try {
            this.notNullCheck(attrName);
            this.generalAttrs.put(attrName.trim(), attrValue);
        }
        catch (Exception e) {
            Logger.f("PayloadBuilder: putAttrLong", e);
        }
        return this;
    }

    @Deprecated
    public PayloadBuilder putAttrDate(String attrName, Date attrValue) {
        try {
            this.notNullCheck(attrName);
            JSONArray timeStamp = this.customAttrs.has(ATTR_TIMESTAMP) ? this.customAttrs.getJSONArray(ATTR_TIMESTAMP) : new JSONArray();
            JSONObject attr = new JSONObject();
            attr.put(attrName.trim(), attrValue.getTime());
            timeStamp.put((Object)attr);
            this.customAttrs.put(ATTR_TIMESTAMP, (Object)timeStamp);
        }
        catch (Exception e) {
            Logger.f("EventPayload: putAttrDate: ", e);
        }
        return this;
    }

    @Deprecated
    public PayloadBuilder putAttrDate(String attrName, String dateString, String dateFormat) {
        try {
            this.notNullCheck(attrName);
            SimpleDateFormat format = new SimpleDateFormat(dateFormat, Locale.ENGLISH);
            return this.putAttrDate(attrName.trim(), format.parse(dateString));
        }
        catch (Exception e) {
            Logger.f("EventPayload: putAttrDate 2: ", e);
            return this;
        }
    }

    @Deprecated
    public PayloadBuilder putAttrLocation(String attrName, GeoLocation attrValue) {
        try {
            this.notNullCheck(attrName);
            JSONArray location = this.customAttrs.has(ATTR_LOCATION) ? this.customAttrs.getJSONArray(ATTR_LOCATION) : new JSONArray();
            JSONObject attr = new JSONObject();
            attr.put(attrName.trim(), (Object)(attrValue.latitude + "," + attrValue.longitude));
            location.put((Object)attr);
            this.customAttrs.put(ATTR_LOCATION, (Object)location);
        }
        catch (Exception e) {
            Logger.f("EventPayload: putAttrLocation1: ", e);
        }
        return this;
    }

    @Deprecated
    public PayloadBuilder putAttrLocation(String attrName, Location attrValue) {
        try {
            this.notNullCheck(attrName);
            JSONArray location = this.customAttrs.has(ATTR_LOCATION) ? this.customAttrs.getJSONArray(ATTR_LOCATION) : new JSONArray();
            JSONObject attr = new JSONObject();
            attr.put(attrName.trim(), (Object)(attrValue.getLatitude() + "," + attrValue.getLongitude()));
            location.put((Object)attr);
            this.customAttrs.put(ATTR_LOCATION, (Object)location);
        }
        catch (Exception e) {
            Logger.f("EventPayload: putAttrLocation2: ", e);
        }
        return this;
    }

    @Deprecated
    public PayloadBuilder putAttrLocation(String attrName, double latitude, double longitude) {
        try {
            this.notNullCheck(attrName);
            JSONArray location = this.customAttrs.has(ATTR_LOCATION) ? this.customAttrs.getJSONArray(ATTR_LOCATION) : new JSONArray();
            JSONObject attr = new JSONObject();
            attr.put(attrName.trim(), (Object)(latitude + "," + longitude));
            location.put((Object)attr);
            this.customAttrs.put(ATTR_LOCATION, (Object)location);
        }
        catch (Exception e) {
            Logger.f("EventPayload: putAttrLocation3: ", e);
        }
        return this;
    }

    @Deprecated
    public PayloadBuilder putAttrDateEpoch(String attrName, long attrValue) {
        try {
            this.notNullCheck(attrName);
            JSONArray timeStamp = this.customAttrs.has(ATTR_TIMESTAMP) ? this.customAttrs.getJSONArray(ATTR_TIMESTAMP) : new JSONArray();
            JSONObject attr = new JSONObject();
            attr.put(attrName.trim(), attrValue);
            timeStamp.put((Object)attr);
            this.customAttrs.put(ATTR_TIMESTAMP, (Object)timeStamp);
        }
        catch (Exception e) {
            Logger.f("EventPayload: putAttrDate: ", e);
        }
        return this;
    }

    @Deprecated
    public PayloadBuilder putAttrJSONArray(@NonNull String attrName, @NonNull JSONArray attrValue) {
        try {
            this.notNullCheck(attrName);
            if (attrValue == null) {
                return this;
            }
            this.generalAttrs.put(attrName.trim(), (Object)attrValue);
        }
        catch (Exception e) {
            Logger.f("EventPayload: putAttrJSONArray: ", e);
        }
        return this;
    }

    @Deprecated
    public PayloadBuilder putAttrJSONObject(@NonNull String attrName, @NonNull JSONObject attrValue) {
        try {
            this.notNullCheck(attrName);
            if (attrValue == null) {
                return this;
            }
            this.generalAttrs.put(attrName.trim(), (Object)attrValue);
        }
        catch (Exception e) {
            Logger.f("EventPayload: putAttrJSONObject: ", e);
        }
        return this;
    }

    @Deprecated
    public PayloadBuilder putAttrObject(@NonNull String attrName, @NonNull Object attrValue) {
        try {
            this.notNullCheck(attrName);
            if (attrValue == null) {
                return this;
            }
            this.generalAttrs.put(attrName.trim(), attrValue);
        }
        catch (Exception e) {
            Logger.f("EventPayload: putAttrObject() : Exception ", e);
        }
        return this;
    }

    @Deprecated
    public PayloadBuilder putAttrISO8601Date(@NonNull String attrName, @NonNull String attrValue) {
        try {
            this.notNullCheck(attrName);
            if (TextUtils.isEmpty((CharSequence)attrValue)) {
                Logger.e("PayloadBuilder putAttrISO8601Date() : Attribute value cannot be empty");
                return this;
            }
            long epochValue = ISO8601Utils.parse(attrValue).getTime();
            this.putAttrDateEpoch(attrName, epochValue);
        }
        catch (Exception e) {
            Logger.f("PayloadBuilder putAttrISO8601Date() : ");
        }
        return this;
    }

    @Deprecated
    public JSONObject build() {
        try {
            JSONObject dataPoint = new JSONObject();
            boolean nothing = true;
            if (this.generalAttrs.length() > 0) {
                this.markEventAsNonInteractiveIfRequired();
                dataPoint.put("EVENT_ATTRS", (Object)this.generalAttrs.toString());
                nothing = false;
            }
            if (this.customAttrs.length() > 0) {
                dataPoint.put("EVENT_ATTRS_CUST", (Object)this.customAttrs.toString());
                nothing = false;
            }
            if (nothing) {
                dataPoint.put("EVENT_ATTRS", (Object)new JSONObject().toString());
            }
            dataPoint.put("EVENT_G_TIME", (Object)Long.toString(MoEUtils.currentTime()));
            dataPoint.put("EVENT_L_TIME", (Object)MoEUtils.getDateDataPointFormat());
            if (!this.isInteractiveEvent) {
                dataPoint.put("N_I_E", 1);
            }
            return dataPoint;
        }
        catch (Exception e) {
            Logger.f("PayloadBuilder build() Exception: ", e);
            return null;
        }
    }

    private void markEventAsNonInteractiveIfRequired() {
        try {
            if (this.generalAttrs.has(NON_INTERACTIVE_EVENT_ATTRIBUTE) && !this.hasCalledNonInteractiveApi) {
                Object attributeValue = this.generalAttrs.get(NON_INTERACTIVE_EVENT_ATTRIBUTE);
                if (attributeValue instanceof Integer) {
                    int isNonInteractive = (Integer)attributeValue;
                    this.isInteractiveEvent = isNonInteractive != 1;
                } else {
                    Logger.e("PayloadBuilder build() : moe_non_interactive is not tracked in the expected data-type. Expected data-type in integer.");
                }
            }
            if (this.generalAttrs.has(NON_INTERACTIVE_EVENT_ATTRIBUTE)) {
                this.generalAttrs.remove(NON_INTERACTIVE_EVENT_ATTRIBUTE);
            }
        }
        catch (JSONException e) {
            Logger.e("PayloadBuilder markEventAsNonInteractiveIfRequired() : Exception ", e);
        }
    }

    @Deprecated
    public PayloadBuilder setNonInteractive() {
        this.isInteractiveEvent = false;
        this.hasCalledNonInteractiveApi = true;
        return this;
    }

    @Deprecated
    public PayloadBuilder() {
        this.generalAttrs = new JSONObject();
    }
}

