/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.support.annotation.Nullable;
import com.moengage.core.model.RemoteConfiguration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ConfigurationCache {
    private HashMap<String, Object> configMap = new HashMap();
    private static ConfigurationCache instance;
    private static final String PUSH_SERVICE = "push_service";
    private static final String BAIDU_PUSH_STATE = "baidu_push_state";
    private static final String BACK_STACK_OPT_OUT = "is_back_stack_opted_out";
    private static final String EXTRAS_OPT_OUT = "is_extras_opted_out";
    private static final String OPT_OUT_DEFAULT_INAPP = "is_default_inapp_opted_out";
    private static final String MOE_APP_ID = "moe_app_id";
    private static final String MOE_DATA_REGION = "moe_data_region";
    private RemoteConfiguration remoteConfiguration;
    private List<String> activityOptOutList;
    private Set<String> sentScreenNames = new HashSet<String>();
    private static final String INTEGRATION_TYPE = "integration_type";
    private static final String INTEGRATION_VERSION = "integration_version";

    private ConfigurationCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConfigurationCache getInstance() {
        if (instance != null) return instance;
        Class<ConfigurationCache> clazz = ConfigurationCache.class;
        synchronized (ConfigurationCache.class) {
            if (instance != null) return instance;
            instance = new ConfigurationCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void setPushService(String pushService) {
        this.configMap.put(PUSH_SERVICE, pushService);
    }

    public String getPushService() {
        String pushService = "FCM";
        if (this.configMap.containsKey(PUSH_SERVICE)) {
            pushService = (String)this.configMap.get(PUSH_SERVICE);
        }
        return pushService;
    }

    void setBaiduPushState(boolean baiduPushState) {
        this.configMap.put(BAIDU_PUSH_STATE, baiduPushState);
    }

    public boolean getBaiduPushState() {
        return this.configMap.containsKey(BAIDU_PUSH_STATE) && this.configMap.get(BAIDU_PUSH_STATE) == Boolean.TRUE;
    }

    public void setBackStackOptOut(boolean backStackOptOut) {
        this.configMap.put(BACK_STACK_OPT_OUT, backStackOptOut);
    }

    public boolean isBackStackOptedOut() {
        return this.configMap.containsKey(BACK_STACK_OPT_OUT) && this.configMap.get(BACK_STACK_OPT_OUT) == Boolean.TRUE;
    }

    public void setExtrasOptOut(boolean extrasOptOut) {
        this.configMap.put(EXTRAS_OPT_OUT, extrasOptOut);
    }

    public boolean isExtrasOptedOut() {
        return this.configMap.containsKey(EXTRAS_OPT_OUT) && this.configMap.get(EXTRAS_OPT_OUT) == Boolean.TRUE;
    }

    public void setDefaultInAppOptOut(boolean defaultInAppOptOut) {
        this.configMap.put(OPT_OUT_DEFAULT_INAPP, defaultInAppOptOut);
    }

    public boolean isDefaultInAppOptedOut() {
        return this.configMap.containsKey(OPT_OUT_DEFAULT_INAPP) && this.configMap.get(OPT_OUT_DEFAULT_INAPP) == Boolean.TRUE;
    }

    void setMoEAppId(String appId) {
        this.configMap.put(MOE_APP_ID, appId);
    }

    String getMoEAppId() {
        return (String)this.configMap.get(MOE_APP_ID);
    }

    public void setMoEDataRegion(int region) {
        this.configMap.put(MOE_DATA_REGION, region);
    }

    public int getMoEDataRegion() {
        return this.configMap.containsKey(MOE_DATA_REGION) ? (Integer)this.configMap.get(MOE_DATA_REGION) : 1003;
    }

    public void setRemoteConfiguration(RemoteConfiguration configuration) {
        this.remoteConfiguration = configuration;
    }

    public RemoteConfiguration getRemoteConfiguration() {
        return this.remoteConfiguration;
    }

    void setActivityOptOutList(List<String> activityOptOutList) {
        this.activityOptOutList = activityOptOutList;
    }

    @Nullable
    List<String> getActivityOptOutList() {
        return this.activityOptOutList;
    }

    void initialiseSentScreens(Set<String> sentScreenNames) {
        this.sentScreenNames.addAll(sentScreenNames);
    }

    void addScreenToSentList(String screenName) {
        this.sentScreenNames.add(screenName);
    }

    Set<String> getSentScreenNames() {
        return this.sentScreenNames;
    }

    public void setIntegrationType(String integrationType) {
        this.configMap.put(INTEGRATION_TYPE, integrationType);
    }

    @Nullable
    public String getIntegrationType() {
        return this.configMap.containsKey(INTEGRATION_TYPE) ? String.valueOf(this.configMap.get(INTEGRATION_TYPE)) : null;
    }

    public void setIntegrationVersion(int integrationVersion) {
    }

    public void setIntegrationVersion(String integrationVersion) {
        this.configMap.put(INTEGRATION_VERSION, integrationVersion);
    }

    public String getIntegrationVersion() {
        return this.configMap.containsKey(INTEGRATION_VERSION) ? (String)this.configMap.get(INTEGRATION_VERSION) : "";
    }
}

