/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.moengage.core.ApiResponseUtility;
import com.moengage.core.Logger;
import com.moengage.core.remoteconfig.RemoteConfigDefault;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class RemoteConfiguration {
    private boolean logEntryStatus = RemoteConfigDefault.LOG_ENTRY_STATUS;
    @Nullable
    private String logEntryToken = RemoteConfigDefault.LOG_ENTRY_TOKEN;
    private long pushAmpSyncDelay = RemoteConfigDefault.PUSH_AMP_SYNC_INTERVAL;
    @Nullable
    private List<String> blacklistedEventList;
    private boolean appStatus = RemoteConfigDefault.ACCOUNT_STATUS;
    private boolean inAppStatus = RemoteConfigDefault.IN_APP_STATUS;
    private boolean geofenceStatus = RemoteConfigDefault.GEO_FENCE_STATUS;
    private boolean pushAmpStatus = RemoteConfigDefault.PUSH_AMP_STATUS;
    private int eventBatchCount = RemoteConfigDefault.EVENT_BATCH_COUNT;
    private long dataSyncRetryInterval = RemoteConfigDefault.DATA_SYNC_RETRY_INTERVAL;
    @Nullable
    private Set<String> flushEventList;
    private boolean periodicFlushStatus = RemoteConfigDefault.PERIODIC_FLUSH_STATE;
    private long periodicFlushTime = RemoteConfigDefault.PERIODIC_FLUSH_TIME;
    private long pushAmpCampaignExpiryTime = RemoteConfigDefault.PUSH_AMP_CAMPAIGN_EXPIRY_TIME;
    private boolean realTimeTriggerStatus = RemoteConfigDefault.REAL_TIME_TRIGGER_STATUS;
    private long realTimeTriggerSyncTime = RemoteConfigDefault.REAL_TIME_TRIGGER_SYNC_INTERVAL;
    @Nullable
    private Set<String> gdprWhitelistEventList;
    private long userAttributeCachingTime = RemoteConfigDefault.USER_ATTRIBUTE_CACHING_TIME;
    @Nullable
    private List<String> blockedUniqueIdRegex;
    private long sessionInActiveTime = RemoteConfigDefault.DEFAULT_SESSION_INACTIVE_TIME;
    private Set<String> sourceExtraIdentifier = new HashSet<String>();
    private boolean sessionTrackingStatus = RemoteConfigDefault.SESSION_TRACKING_STATUS;
    private boolean miPushStatus;
    private String miAppKey;
    private String miAppId;
    private static final String TAG = "RemoteConfiguration";
    private static final String RESPONSE_ATTR_LOG_ENTRY_STATUS = "le_s";
    private static final String RESPONSE_ATTR_LOG_ENTRY_TOKEN = "le_tkn";
    private static final String RESPONSE_ATTR_PUSH_AMP_SYNC_DELAY = "m_s_t";
    private static final String RESPONSE_ATTR_BLACKLIST_EVENT = "b_e";
    private static final String RESPONSE_ATTR_APP_STATE = "a_s";
    private static final String RESPONSE_ATTR_IN_APP_STATE = "i_s";
    private static final String RESPONSE_ATTR_GEO_STATE = "g_s";
    private static final String RESPONSE_ATTR_PUSH_AMP_STATE = "in_s";
    private static final String RESPONSE_ATTR_EVENT_SYNC_COUNT = "e_b_c";
    private static final String RESPONSE_ATTR_DATA_SYNC_RETRY_INTERVAL = "d_s_r_i";
    private static final String RESPONSE_ATTR_FLUSH_EVENTS = "f_e";
    private static final String RESPONSE_ATTR_PERIODIC_FLUSH_TIME = "p_f_t";
    private static final String RESPONSE_ATTR_PERIODIC_FLUSH_STATE = "p_f_s";
    private static final String RESPONSE_ATTR_CAMPAIGN_ID_EXPIRY = "cid_ex";
    private static final String RESPONSE_ATTR_REAL_TIME_TRIGGER_STATE = "d_t";
    private static final String RESPONSE_ATTR_REAL_TIME_TRIGGER_SYNC_TIME = "dt_s_t";
    private static final String RESPONSE_ATTR_GDPR_WHITELIST_EVENTS = "d_t_w_e";
    private static final String RESPONSE_ATTR_USER_ATTRIBUTE_CACHING_TIME = "u_a_c_t";
    private static final String RESPONSE_ATTR_BLOCKED_UNIQUE_ID_REGEX = "b_uid_r";
    private static final String RESPONSE_ATTR_SESSION_INACTIVE_TIME = "s_i_d";
    private static final String RESPONSE_ATTR_TRAFFIC_SOURCE_EXTRA_IDENTIFIERS = "src_ext";
    private static final String RESPONSE_ATTR_SESSION_TRACKING_STATE = "s_s_s";
    private static final String RESPONSE_ATTR_MI_PUSH_APP_ID = "mi_app_id";
    private static final String RESPONSE_ATTR_MI_PUSH_APP_KEY = "mi_app_key";
    private static final String RESPONSE_ATTR_MI_PUSH_STATUS = "mi_p_s";

    public RemoteConfiguration() {
        this.flushEventList = new HashSet<String>();
        this.flushEventList.addAll(RemoteConfigDefault.DEFAULT_FLUSH_EVENTS);
        this.gdprWhitelistEventList = new HashSet<String>();
        this.gdprWhitelistEventList.addAll(RemoteConfigDefault.DEFAULT_GDPR_WHITELIST_EVENTS);
        this.miPushStatus = RemoteConfigDefault.MI_PUSH_APP_STATUS;
    }

    public boolean isLogEntryEnabled() {
        return this.logEntryStatus;
    }

    public void setLogEntryStatus(boolean logEntryStatus) {
        this.logEntryStatus = logEntryStatus;
    }

    @Nullable
    public String getLogEntryToken() {
        return this.logEntryToken;
    }

    public void setLogEntryToken(@Nullable String logEntryToken) {
        this.logEntryToken = logEntryToken;
    }

    public long getPushAmpSyncDelay() {
        return this.pushAmpSyncDelay;
    }

    public void setPushAmpSyncDelay(long pushAmpSyncDelay) {
        this.pushAmpSyncDelay = pushAmpSyncDelay;
    }

    @Nullable
    public List<String> getBlacklistedEventList() {
        return this.blacklistedEventList;
    }

    public void setBlacklistedEventList(@Nullable List<String> blacklistedEventList) {
        this.blacklistedEventList = blacklistedEventList;
    }

    public boolean isAppEnabled() {
        return this.appStatus;
    }

    public void setAppStatus(boolean appStatus) {
        this.appStatus = appStatus;
    }

    public boolean isInAppEnabled() {
        return this.inAppStatus;
    }

    public void setInAppStatus(boolean inAppStatus) {
        this.inAppStatus = inAppStatus;
    }

    public boolean isGeofenceEnabled() {
        return this.geofenceStatus;
    }

    public void setGeofenceStatus(boolean geofenceStatus) {
        this.geofenceStatus = geofenceStatus;
    }

    public boolean isPushAmpEnabled() {
        return this.pushAmpStatus;
    }

    public void setPushAmpStatus(boolean pushAmpStatus) {
        this.pushAmpStatus = pushAmpStatus;
    }

    public int getEventBatchCount() {
        return this.eventBatchCount;
    }

    public void setEventBatchCount(int eventBatchCount) {
        this.eventBatchCount = eventBatchCount;
    }

    public long getDataSyncRetryInterval() {
        return this.dataSyncRetryInterval;
    }

    public void setDataSyncRetryInterval(long dataSyncRetryInterval) {
        this.dataSyncRetryInterval = dataSyncRetryInterval;
    }

    @Nullable
    public Set<String> getFlushEventList() {
        return this.flushEventList;
    }

    public void setFlushEventList(@Nullable Set<String> flushEventList) {
        if (this.flushEventList == null) {
            flushEventList = RemoteConfigDefault.DEFAULT_FLUSH_EVENTS;
        }
        if (flushEventList != null) {
            this.flushEventList.addAll(flushEventList);
        }
    }

    public boolean isPeriodicFlushEnabled() {
        return this.periodicFlushStatus;
    }

    public void setPeriodicFlushStatus(boolean periodicFlushStatus) {
        this.periodicFlushStatus = periodicFlushStatus;
    }

    public long getPeriodicFlushTime() {
        return this.periodicFlushTime;
    }

    public void setPeriodicFlushTime(long periodicFlushTime) {
        this.periodicFlushTime = periodicFlushTime;
    }

    public long getPushAmpCampaignExpiryTime() {
        return this.pushAmpCampaignExpiryTime;
    }

    public void setPushAmpCampaignExpiryTime(long pushAmpCampaignExpiryTime) {
        this.pushAmpCampaignExpiryTime = pushAmpCampaignExpiryTime;
    }

    public boolean isRealTimeTriggerEnabled() {
        return this.realTimeTriggerStatus;
    }

    public void setRealTimeTriggerStatus(boolean realTimeTriggerStatus) {
        this.realTimeTriggerStatus = realTimeTriggerStatus;
    }

    public long getRealTimeTriggerSyncTime() {
        return this.realTimeTriggerSyncTime;
    }

    public void setRealTimeTriggerSyncTime(long realTimeTriggerSyncTime) {
        this.realTimeTriggerSyncTime = realTimeTriggerSyncTime;
    }

    @Nullable
    public Set<String> getGdprWhitelistEventList() {
        return this.gdprWhitelistEventList;
    }

    public void setGdprWhitelistEventList(@Nullable Set<String> gdprWhitelistEventList) {
        if (gdprWhitelistEventList != null) {
            this.gdprWhitelistEventList.addAll(gdprWhitelistEventList);
        }
    }

    public long getUserAttributeCachingTime() {
        return this.userAttributeCachingTime;
    }

    public void setUserAttributeCachingTime(long userAttributeCachingTime) {
        this.userAttributeCachingTime = userAttributeCachingTime;
    }

    @Nullable
    public List<String> getBlockedUniqueIdRegex() {
        return this.blockedUniqueIdRegex;
    }

    public void setBlockedUniqueIdRegex(@Nullable List<String> blockedUniqueIdRegex) {
        this.blockedUniqueIdRegex = blockedUniqueIdRegex;
    }

    public long getSessionInActiveTime() {
        return this.sessionInActiveTime;
    }

    public void setSessionInActiveTime(long sessionInActiveTime) {
        this.sessionInActiveTime = sessionInActiveTime;
    }

    public Set<String> getSourceExtraIdentifier() {
        return this.sourceExtraIdentifier;
    }

    public void setSourceExtraIdentifier(Set<String> sourceExtraIdentifier) {
        this.sourceExtraIdentifier = sourceExtraIdentifier;
    }

    public boolean isSessionTrackingEnabled() {
        return this.sessionTrackingStatus;
    }

    public void setSessionTrackingStatus(boolean sessionTrackingStatus) {
        this.sessionTrackingStatus = sessionTrackingStatus;
    }

    public boolean isMiPushEnabled() {
        return this.miPushStatus;
    }

    public void setMiPushStatus(boolean miPushStatus) {
        this.miPushStatus = miPushStatus;
    }

    public String getMiAppKey() {
        return this.miAppKey;
    }

    public void setMiAppKey(String miAppKey) {
        this.miAppKey = miAppKey;
    }

    public String getMiAppId() {
        return this.miAppId;
    }

    public void setMiAppId(String miAppId) {
        this.miAppId = miAppId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteConfiguration that = (RemoteConfiguration)o;
        if (this.logEntryStatus != that.logEntryStatus) {
            return false;
        }
        if (this.pushAmpSyncDelay != that.pushAmpSyncDelay) {
            return false;
        }
        if (this.appStatus != that.appStatus) {
            return false;
        }
        if (this.inAppStatus != that.inAppStatus) {
            return false;
        }
        if (this.geofenceStatus != that.geofenceStatus) {
            return false;
        }
        if (this.pushAmpStatus != that.pushAmpStatus) {
            return false;
        }
        if (this.eventBatchCount != that.eventBatchCount) {
            return false;
        }
        if (this.dataSyncRetryInterval != that.dataSyncRetryInterval) {
            return false;
        }
        if (this.periodicFlushStatus != that.periodicFlushStatus) {
            return false;
        }
        if (this.periodicFlushTime != that.periodicFlushTime) {
            return false;
        }
        if (this.pushAmpCampaignExpiryTime != that.pushAmpCampaignExpiryTime) {
            return false;
        }
        if (this.realTimeTriggerStatus != that.realTimeTriggerStatus) {
            return false;
        }
        if (this.realTimeTriggerSyncTime != that.realTimeTriggerSyncTime) {
            return false;
        }
        if (this.userAttributeCachingTime != that.userAttributeCachingTime) {
            return false;
        }
        if (this.sessionInActiveTime != that.sessionInActiveTime) {
            return false;
        }
        if (this.logEntryToken != null ? !this.logEntryToken.equals(that.logEntryToken) : that.logEntryToken != null) {
            return false;
        }
        if (this.blacklistedEventList != null ? !this.blacklistedEventList.equals(that.blacklistedEventList) : that.blacklistedEventList != null) {
            return false;
        }
        if (this.flushEventList != null ? !this.flushEventList.equals(that.flushEventList) : that.flushEventList != null) {
            return false;
        }
        if (this.gdprWhitelistEventList != null ? !this.gdprWhitelistEventList.equals(that.gdprWhitelistEventList) : that.gdprWhitelistEventList != null) {
            return false;
        }
        return this.blockedUniqueIdRegex != null ? this.blockedUniqueIdRegex.equals(that.blockedUniqueIdRegex) : that.blockedUniqueIdRegex == null;
    }

    public static RemoteConfiguration fromJson(JSONObject configurationJson) {
        try {
            Set<String> identifiers;
            long syncDelay;
            RemoteConfiguration configuration = new RemoteConfiguration();
            if (configurationJson.has(RESPONSE_ATTR_LOG_ENTRY_STATUS)) {
                configuration.setLogEntryStatus(RemoteConfiguration.getStateFromResponse(configurationJson, RESPONSE_ATTR_LOG_ENTRY_STATUS, RemoteConfigDefault.LOG_ENTRY_STATUS));
            }
            if (configurationJson.has(RESPONSE_ATTR_LOG_ENTRY_TOKEN)) {
                configuration.setLogEntryToken(configurationJson.getString(RESPONSE_ATTR_LOG_ENTRY_TOKEN));
            }
            if (configurationJson.has(RESPONSE_ATTR_PUSH_AMP_SYNC_DELAY) && (syncDelay = configurationJson.getLong(RESPONSE_ATTR_PUSH_AMP_SYNC_DELAY)) > 0L) {
                configuration.setPushAmpSyncDelay(syncDelay * 1000L);
            }
            if (configurationJson.has(RESPONSE_ATTR_BLACKLIST_EVENT)) {
                configuration.setBlacklistedEventList(ApiResponseUtility.jsonArrayToStringList(configurationJson.getJSONArray(RESPONSE_ATTR_BLACKLIST_EVENT)));
            }
            if (configurationJson.has(RESPONSE_ATTR_APP_STATE)) {
                configuration.setAppStatus(RemoteConfiguration.getStateFromResponse(configurationJson, RESPONSE_ATTR_APP_STATE, RemoteConfigDefault.ACCOUNT_STATUS));
            }
            if (configurationJson.has(RESPONSE_ATTR_IN_APP_STATE)) {
                configuration.setInAppStatus(RemoteConfiguration.getStateFromResponse(configurationJson, RESPONSE_ATTR_IN_APP_STATE, RemoteConfigDefault.IN_APP_STATUS));
            }
            if (configurationJson.has(RESPONSE_ATTR_GEO_STATE)) {
                configuration.setGeofenceStatus(RemoteConfiguration.getStateFromResponse(configurationJson, RESPONSE_ATTR_GEO_STATE, RemoteConfigDefault.GEO_FENCE_STATUS));
            }
            if (configurationJson.has(RESPONSE_ATTR_PUSH_AMP_STATE)) {
                configuration.setPushAmpStatus(RemoteConfiguration.getStateFromResponse(configurationJson, RESPONSE_ATTR_PUSH_AMP_STATE, RemoteConfigDefault.PUSH_AMP_STATUS));
            }
            if (configurationJson.has(RESPONSE_ATTR_EVENT_SYNC_COUNT)) {
                configuration.setEventBatchCount(configurationJson.getInt(RESPONSE_ATTR_EVENT_SYNC_COUNT));
            }
            if (configurationJson.has(RESPONSE_ATTR_DATA_SYNC_RETRY_INTERVAL)) {
                configuration.setDataSyncRetryInterval(configurationJson.getLong(RESPONSE_ATTR_DATA_SYNC_RETRY_INTERVAL) * 1000L);
            }
            if (configurationJson.has(RESPONSE_ATTR_FLUSH_EVENTS)) {
                configuration.setFlushEventList(ApiResponseUtility.jsonArrayToStringSet(configurationJson.getJSONArray(RESPONSE_ATTR_FLUSH_EVENTS)));
            }
            if (configurationJson.has(RESPONSE_ATTR_PERIODIC_FLUSH_STATE)) {
                configuration.setPeriodicFlushStatus(RemoteConfiguration.getStateFromResponse(configurationJson, RESPONSE_ATTR_PERIODIC_FLUSH_STATE, RemoteConfigDefault.PERIODIC_FLUSH_STATE));
            }
            if (configurationJson.has(RESPONSE_ATTR_PERIODIC_FLUSH_TIME)) {
                configuration.setPeriodicFlushTime(configurationJson.getLong(RESPONSE_ATTR_PERIODIC_FLUSH_TIME));
            }
            if (configurationJson.has(RESPONSE_ATTR_CAMPAIGN_ID_EXPIRY)) {
                configuration.setPushAmpCampaignExpiryTime(configurationJson.getLong(RESPONSE_ATTR_CAMPAIGN_ID_EXPIRY));
            }
            if (configurationJson.has(RESPONSE_ATTR_REAL_TIME_TRIGGER_STATE)) {
                configuration.setRealTimeTriggerStatus(RemoteConfiguration.getStateFromResponse(configurationJson, RESPONSE_ATTR_REAL_TIME_TRIGGER_STATE, RemoteConfigDefault.REAL_TIME_TRIGGER_STATUS));
            }
            if (configurationJson.has(RESPONSE_ATTR_REAL_TIME_TRIGGER_SYNC_TIME)) {
                configuration.setRealTimeTriggerSyncTime(configurationJson.getLong(RESPONSE_ATTR_REAL_TIME_TRIGGER_SYNC_TIME) * 1000L);
            }
            if (configurationJson.has(RESPONSE_ATTR_GDPR_WHITELIST_EVENTS)) {
                configuration.setGdprWhitelistEventList(ApiResponseUtility.jsonArrayToStringSet(configurationJson.getJSONArray(RESPONSE_ATTR_GDPR_WHITELIST_EVENTS)));
            }
            if (configurationJson.has(RESPONSE_ATTR_USER_ATTRIBUTE_CACHING_TIME)) {
                configuration.setUserAttributeCachingTime(configurationJson.getLong(RESPONSE_ATTR_USER_ATTRIBUTE_CACHING_TIME) * 1000L);
            }
            if (configurationJson.has(RESPONSE_ATTR_BLOCKED_UNIQUE_ID_REGEX)) {
                configuration.setBlockedUniqueIdRegex(ApiResponseUtility.jsonArrayToStringList(configurationJson.getJSONArray(RESPONSE_ATTR_BLOCKED_UNIQUE_ID_REGEX)));
            }
            if (configurationJson.has(RESPONSE_ATTR_SESSION_INACTIVE_TIME)) {
                configuration.setSessionInActiveTime(configurationJson.getLong(RESPONSE_ATTR_SESSION_INACTIVE_TIME) * 1000L);
            }
            if (configurationJson.has(RESPONSE_ATTR_TRAFFIC_SOURCE_EXTRA_IDENTIFIERS) && (identifiers = ApiResponseUtility.jsonArrayToStringSet(configurationJson.getJSONArray(RESPONSE_ATTR_TRAFFIC_SOURCE_EXTRA_IDENTIFIERS))) != null) {
                configuration.setSourceExtraIdentifier(identifiers);
            }
            if (configurationJson.has(RESPONSE_ATTR_SESSION_TRACKING_STATE)) {
                configuration.setSessionTrackingStatus(RemoteConfiguration.getStateFromResponse(configurationJson, RESPONSE_ATTR_SESSION_TRACKING_STATE, RemoteConfigDefault.SESSION_TRACKING_STATUS));
            }
            if (configurationJson.has(RESPONSE_ATTR_MI_PUSH_APP_ID)) {
                configuration.setMiAppId(configurationJson.getString(RESPONSE_ATTR_MI_PUSH_APP_ID));
            }
            if (configurationJson.has(RESPONSE_ATTR_MI_PUSH_APP_KEY)) {
                configuration.setMiAppKey(configurationJson.getString(RESPONSE_ATTR_MI_PUSH_APP_KEY));
            }
            if (configurationJson.has(RESPONSE_ATTR_MI_PUSH_STATUS)) {
                configuration.setMiPushStatus(RemoteConfiguration.getStateFromResponse(configurationJson, RESPONSE_ATTR_MI_PUSH_STATUS, RemoteConfigDefault.MI_PUSH_APP_STATUS));
            }
            return configuration;
        }
        catch (Exception e) {
            Logger.f("RemoteConfiguration parseConfigApiResponse() : Exception ", e);
            return null;
        }
    }

    private static boolean getStateFromResponse(@NonNull JSONObject responseJSON, @NonNull String responseAttr, boolean defaultValue) {
        try {
            String state;
            switch (state = responseJSON.getString(responseAttr)) {
                case "blocked": {
                    return false;
                }
                case "allowed": {
                    return true;
                }
            }
        }
        catch (JSONException e) {
            Logger.f(" getStateFromResponse ", e);
        }
        return defaultValue;
    }
}

