/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.analytics;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;
import com.moengage.core.model.TrafficSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class SourceProcessor {
    private static final String TAG = "SourceProcessor";
    private static List<String> sourceKeys = new ArrayList<String>(2);
    private static List<String> mediumKeys;
    private static List<String> campaignNameKeys;
    private static List<String> campaignIdKeys;
    private static List<String> contentKeys;
    private static List<String> termKeys;
    private static final String SOURCE_PARAM_SOURCE = "source";
    private static final String SOURCE_PARAM_UTM_SOURCE = "utm_source";
    private static final String CAMPAIGN_PARAM_UTM_CAMPAIGN = "utm_campaign";
    private static final String CAMPAIGN_PARAM_CAMPAIGN = "campaign";
    private static final String MEDIUM_PARAM_UTM_MEDIUM = "utm_medium";
    private static final String MEDIUM_PARAM_MEDIUM = "medium";
    private static final String CAMPAIGN_ID_PARAM_UTM_CAMPAIGN_ID = "utm_id";
    private static final String CAMPAIGN_ID_PARAM_CAMPAIGN_ID = "id";
    private static final String CONTENT_PARAM_UTM_CONTENT = "utm_content";
    private static final String CONTENT_PARAM_CONTENT = "content";
    private static final String TERM_PARAM_UTM_TERM = "utm_term";
    private static final String TERM_PARAM_TERM = "term";
    private static final int SOURCE_PROPERTIES_LIST_SIZE = 2;

    TrafficSource getTrafficSourceFromActivity(Activity activity, Set<String> extraSourceIdentifiers) {
        TrafficSource sourceIntentExtra;
        TrafficSource uriSource;
        Intent intent = activity.getIntent();
        if (intent == null) {
            return null;
        }
        TrafficSource source = null;
        Uri intentUri = intent.getData();
        Bundle extras = intent.getExtras();
        if (intentUri != null && !TrafficSource.isEmpty(uriSource = this.getTrafficSourceFromUrl(intentUri, extraSourceIdentifiers))) {
            source = uriSource;
        }
        if (source == null && extras != null && !TrafficSource.isEmpty(sourceIntentExtra = this.getTrafficSourceFromExtras(extras, extraSourceIdentifiers))) {
            source = sourceIntentExtra;
        }
        if (source == null) {
            source = new TrafficSource();
        }
        return source;
    }

    TrafficSource getTrafficSourceFromUrl(Uri intentUri, Set<String> extraSourceIdentifiers) {
        Set queryParamKeys = intentUri.getQueryParameterNames();
        TrafficSource source = new TrafficSource();
        source.setSource(this.paramValueForParamName(intentUri, sourceKeys, queryParamKeys));
        source.setMedium(this.paramValueForParamName(intentUri, mediumKeys, queryParamKeys));
        source.setCampaignName(this.paramValueForParamName(intentUri, campaignNameKeys, queryParamKeys));
        source.setCampaignId(this.paramValueForParamName(intentUri, campaignIdKeys, queryParamKeys));
        source.setContent(this.paramValueForParamName(intentUri, contentKeys, queryParamKeys));
        source.setTerm(this.paramValueForParamName(intentUri, termKeys, queryParamKeys));
        source.setSourceUrl(intentUri.toString());
        source.setExtras(this.getExtraIdentifiersIfPresent(intentUri, (Set<String>)queryParamKeys, extraSourceIdentifiers));
        return source;
    }

    TrafficSource getTrafficSourceFromExtras(Bundle extras, Set<String> extraSourceIdentifiers) {
        Set bundleKeySet = extras.keySet();
        TrafficSource source = new TrafficSource();
        source.setSource(this.paramValueForParamName(extras, bundleKeySet, sourceKeys));
        source.setMedium(this.paramValueForParamName(extras, bundleKeySet, mediumKeys));
        source.setCampaignName(this.paramValueForParamName(extras, bundleKeySet, campaignNameKeys));
        source.setCampaignId(this.paramValueForParamName(extras, bundleKeySet, campaignIdKeys));
        source.setContent(this.paramValueForParamName(extras, bundleKeySet, contentKeys));
        source.setTerm(this.paramValueForParamName(extras, bundleKeySet, termKeys));
        source.setExtras(this.getExtraIdentifiersIfPresent(extras, (Set<String>)bundleKeySet, extraSourceIdentifiers));
        return source;
    }

    @Nullable
    private String paramValueForParamName(Uri uri, List<String> keys, Set<String> queryParamKeys) {
        for (String key : keys) {
            if (!queryParamKeys.contains(key)) continue;
            return uri.getQueryParameter(key);
        }
        return null;
    }

    private String paramValueForParamName(Bundle extras, Set<String> extraKeySet, List<String> keys) {
        for (String key : keys) {
            if (!extraKeySet.contains(key)) continue;
            return extras.getString(key);
        }
        return null;
    }

    private HashMap<String, String> getExtraIdentifiersIfPresent(Uri uri, Set<String> queryParamsKeys, Set<String> extraSourceIdentifiers) {
        HashMap<String, String> extraIdentifierMap = new HashMap<String, String>();
        if (queryParamsKeys == null || extraSourceIdentifiers == null) {
            return extraIdentifierMap;
        }
        for (String identifier : extraSourceIdentifiers) {
            if (!queryParamsKeys.contains(identifier)) continue;
            extraIdentifierMap.put(identifier, uri.getQueryParameter(identifier));
        }
        return extraIdentifierMap;
    }

    private HashMap<String, String> getExtraIdentifiersIfPresent(Bundle extras, Set<String> bundleKeySet, Set<String> extraSourceIdentifiers) {
        HashMap<String, String> extraIdentifierMap = new HashMap<String, String>();
        if (bundleKeySet == null || extraSourceIdentifiers == null) {
            return extraIdentifierMap;
        }
        for (String identifier : extraSourceIdentifiers) {
            if (!bundleKeySet.contains(identifier)) continue;
            extraIdentifierMap.put(identifier, extras.getString(identifier));
        }
        return extraIdentifierMap;
    }

    static {
        sourceKeys.add(SOURCE_PARAM_UTM_SOURCE);
        sourceKeys.add(SOURCE_PARAM_SOURCE);
        campaignNameKeys = new ArrayList<String>(2);
        campaignNameKeys.add(CAMPAIGN_PARAM_UTM_CAMPAIGN);
        campaignNameKeys.add(CAMPAIGN_PARAM_CAMPAIGN);
        mediumKeys = new ArrayList<String>(2);
        mediumKeys.add(MEDIUM_PARAM_UTM_MEDIUM);
        mediumKeys.add(MEDIUM_PARAM_MEDIUM);
        campaignIdKeys = new ArrayList<String>(2);
        campaignIdKeys.add(CAMPAIGN_ID_PARAM_UTM_CAMPAIGN_ID);
        campaignIdKeys.add(CAMPAIGN_ID_PARAM_CAMPAIGN_ID);
        contentKeys = new ArrayList<String>(2);
        contentKeys.add(CONTENT_PARAM_UTM_CONTENT);
        contentKeys.add(CONTENT_PARAM_CONTENT);
        termKeys = new ArrayList<String>(2);
        termKeys.add(TERM_PARAM_UTM_TERM);
        termKeys.add(TERM_PARAM_TERM);
    }
}

