/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.moengage.core.ConfigurationCache;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import org.json.JSONObject;

public class MoEDTManager {
    private static final String TAG = "MoEDTManager";
    private DTHandler triggerHandler;
    private static MoEDTManager instance;

    private MoEDTManager() {
        this.loadHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MoEDTManager getInstance() {
        if (instance != null) return instance;
        Class<MoEDTManager> clazz = MoEDTManager.class;
        synchronized (MoEDTManager.class) {
            if (instance != null) return instance;
            instance = new MoEDTManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void loadHandler() {
        try {
            Class<?> handler = Class.forName("com.moengage.addon.trigger.DTHandlerImpl");
            this.triggerHandler = (DTHandler)handler.newInstance();
        }
        catch (Exception e) {
            Logger.e("MoEDTManagerloadHandler() : ");
        }
    }

    @Nullable
    DTHandler getTriggerHandler(Context context) {
        if (ConfigurationCache.getInstance().getRemoteConfiguration().isRealTimeTriggerEnabled() && !ConfigurationProvider.getInstance(context).isPushNotificationOptedOut()) {
            return this.triggerHandler;
        }
        return null;
    }

    public void showTriggerIfPossible(Context context, String eventName, JSONObject eventAttributes) {
        DTHandler dtHandler = this.getTriggerHandler(context);
        if (dtHandler != null) {
            dtHandler.showTriggerCampaignIfPossible(context, eventName, eventAttributes);
        }
    }

    public void syncDeviceTriggersIfRequired(Context context) {
        DTHandler dtHandler = this.getTriggerHandler(context);
        if (dtHandler != null) {
            dtHandler.syncTriggersIfRequired(context);
        }
    }

    public void forceSyncDeviceTriggers(Context context) {
        DTHandler dtHandler = this.getTriggerHandler(context);
        if (dtHandler != null) {
            dtHandler.forceSyncDeviceTriggers(context);
        }
    }

    void scheduleBackgroundSync(Context context) {
        DTHandler dtHandler = this.getTriggerHandler(context);
        if (dtHandler != null) {
            dtHandler.scheduleBackgroundSync(context);
        }
    }

    public static interface DTHandler {
        public void syncTriggersIfRequired(@NonNull Context var1);

        public void showTriggerCampaignIfPossible(@NonNull Context var1, @NonNull String var2, @NonNull JSONObject var3);

        public void forceSyncDeviceTriggers(@NonNull Context var1);

        public void scheduleBackgroundSync(Context var1);
    }
}

