/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core.userattributes;

import android.content.Context;
import com.moe.pushlibrary.models.Event;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEDAO;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.MoEUtils;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.core.model.MoEAttribute;
import org.json.JSONException;
import org.json.JSONObject;

public class TrackAttributeTask
extends SDKTask {
    private static final String TAG = "TrackAttributeTask";
    private JSONObject attributeJson;
    private boolean isCustomAttribute;

    TrackAttributeTask(Context context, JSONObject attributeJson, boolean isCustomAttribute) {
        super(context);
        this.attributeJson = attributeJson;
        this.isCustomAttribute = isCustomAttribute;
    }

    @Override
    public TaskResult execute() {
        try {
            Logger.v("TrackAttributeTask executing Task : ");
            if (this.isCustomAttribute) {
                Logger.v("TrackAttributeTask execute() : No need to cache custom attributes, will track attribute.");
                this.writeUserAttributeToStorage(this.attributeJson);
                this.mTaskResult.setIsSuccess(true);
                return this.mTaskResult;
            }
            MoEAttribute trackedAttribute = MoEUtils.convertJsonToAttributeObject(this.attributeJson);
            if (trackedAttribute == null) {
                Logger.v("TrackAttributeTask execute() : Conversion from Json to object failed cannot decide whether to track attribute or not, will track attribute.");
                this.writeUserAttributeToStorage(this.attributeJson);
                this.mTaskResult.setIsSuccess(true);
                return this.mTaskResult;
            }
            Logger.v("TrackAttributeTask execute() : Will try to send attribute to server. Attribute: " + trackedAttribute.toString());
            MoEAttribute savedAttribute = MoEDAO.getInstance(this.mContext).getAttributeByName(trackedAttribute.getName());
            String currentUniqueId = MoEUtils.getUserAttributeUniqueId(this.mContext);
            if (trackedAttribute.getName().equals("USER_ATTRIBUTE_UNIQUE_ID") && currentUniqueId != null && !trackedAttribute.getValue().equals(currentUniqueId)) {
                Logger.v("TrackAttributeTask execute(): User Attribute Unique Id has changed will trigger force logout.");
                MoEDispatcher.getInstance(this.mContext).handleLogout(true);
                return this.createTaskResult(this.attributeJson, false);
            }
            if (savedAttribute == null) {
                Logger.v("TrackAttributeTask execute() : This attribute hasn't been cached yet, will track this attribute");
                this.writeUserAttributeToStorage(this.attributeJson);
                this.cacheAttribute(trackedAttribute);
                this.mTaskResult.setIsSuccess(true);
                return this.mTaskResult;
            }
            Logger.v("TrackAttributeTask execute(): Saved user attribute: " + savedAttribute.toString());
            if (this.shouldTrackAttribute(trackedAttribute, savedAttribute, ConfigurationProvider.getInstance(this.mContext).getUserAttributeCachingTime())) {
                this.writeUserAttributeToStorage(this.attributeJson);
                this.cacheAttribute(trackedAttribute);
            } else {
                Logger.v("TrackAttributeTask execute() : Attribute Already tracked. Will not be sent to server.");
            }
            Logger.v("TrackAttributeTask execute() : completed execution");
        }
        catch (JSONException e) {
            Logger.f("TrackAttributeTask execute() : Exception ", e);
        }
        this.mTaskResult.setIsSuccess(true);
        return this.mTaskResult;
    }

    @Override
    public String getTaskTag() {
        return "TRACK_ATTRIBUTE";
    }

    @Override
    public boolean isSynchronous() {
        return false;
    }

    private void writeUserAttributeToStorage(JSONObject attributeJson) {
        Event event = new Event(MoEHelperUtils.getDatapointJSON("EVENT_ACTION_USER_ATTRIBUTE", attributeJson));
        MoEDispatcher.getInstance(this.mContext).writeDataPointToStorage(event);
    }

    private boolean shouldTrackAttribute(MoEAttribute trackedAttribute, MoEAttribute savedAttribute, long sendDelay) {
        if (!trackedAttribute.getName().equals(savedAttribute.getName())) {
            return true;
        }
        if (!trackedAttribute.getValue().equals(savedAttribute.getValue())) {
            return true;
        }
        if (!trackedAttribute.getDataType().equals(savedAttribute.getDataType())) {
            return true;
        }
        return savedAttribute.getLastTrackedTime() + sendDelay < trackedAttribute.getLastTrackedTime();
    }

    private void cacheAttribute(MoEAttribute attribute) {
        Logger.v("TrackAttributeTask cacheAttribute(): Will cache attribute: " + attribute.toString());
        if (attribute == null) {
            Logger.e("TrackAttributeTask cacheAttribute() : Attribute object is null cannot cache it.");
            return;
        }
        if (attribute.getName().equals("USER_ATTRIBUTE_UNIQUE_ID")) {
            Logger.v("TrackAttributeTask cacheAttribute(): Attribute to cache is USER_ATTRIBUTE_UNIQUE_ID will copy it to shared preference as well");
            MoEDAO.getInstance(this.mContext).saveUserAttributeUniqueId(attribute);
            return;
        }
        MoEDAO.getInstance(this.mContext).addOrUpdateAttributeToCache(attribute);
    }
}

