/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.moengage.core.APIManager;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import org.json.JSONObject;

class SendLogEntriesTask
extends SDKTask {
    private static final String TAG = "SendLogEntriesTask";
    private String API = "https://webhook.logentries.com/noformat/logs/";
    private Throwable mThrowable;
    private String mErrorMessage;
    private String mErrorType;

    SendLogEntriesTask(Context context, String errorMessage, Throwable throwable, String errorType) {
        super(context);
        this.mThrowable = throwable;
        this.mErrorMessage = errorMessage;
        this.mErrorType = errorType;
    }

    @Override
    public TaskResult execute() {
        Logger.v("SendLogEntriesTask : executing Task");
        ConfigurationProvider provider = ConfigurationProvider.getInstance(this.mContext);
        if (provider == null) {
            return null;
        }
        try {
            if (provider.isLogEntryEnabled()) {
                String token;
                String trace;
                JSONObject logObject = new JSONObject();
                logObject.put("uid", (Object)provider.getCurrentUserId());
                logObject.put("appid", (Object)MoEUtils.getAppId(this.mContext));
                logObject.put("sdk_ver", 9300);
                logObject.put("tm_s", System.currentTimeMillis());
                if (!TextUtils.isEmpty((CharSequence)this.mErrorType)) {
                    logObject.put("|v|", (Object)this.mErrorType);
                }
                if (!TextUtils.isEmpty((CharSequence)this.mErrorMessage)) {
                    logObject.put("msg", (Object)this.mErrorMessage);
                }
                if (!TextUtils.isEmpty((CharSequence)(trace = Log.getStackTraceString((Throwable)this.mThrowable)))) {
                    logObject.put("tb", (Object)trace);
                }
                if (TextUtils.isEmpty((CharSequence)(token = provider.getLogEntryKey()))) {
                    Logger.e("SendLogEntriesTask execute() : Log-entry token empty.");
                    return null;
                }
                boolean bl = APIManager.uploadLogsToLogEntries(this.mContext, this.API + token, logObject);
            } else {
                Logger.v("SendLogEnteriesTask : LogEnteries disabled");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Logger.v("SendLogEntriesTask : execution completed");
        return null;
    }

    @Override
    public String getTaskTag() {
        return "SEND_LOG";
    }

    @Override
    public boolean isSynchronous() {
        return false;
    }
}

