/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.moe.pushlibrary.MoEHelper;
import com.moe.pushlibrary.models.Event;
import com.moe.pushlibrary.utils.MoEHelperConstants;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEDTManager;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.MoEUtils;
import com.moengage.inapp.InAppController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.json.JSONObject;

public class MoEEventManager {
    private static final String TAG = "MoEEventManager";
    private static MoEEventManager _INSTANCE = null;
    private List<String> mBlackListedEvents = null;
    private ConfigurationProvider mConfigProvider = null;
    private Context mContext;
    private int mEventCounter = 0;
    private List<String> mTriggerEvents;
    private List<String> mFlushEvents;
    private LinkedHashSet<String> mGDPRWhiteList;

    private MoEEventManager(Context context) {
        this.mContext = context;
        this.mConfigProvider = ConfigurationProvider.getInstance(context);
        this.updateBlackListedEvents();
        this.getTriggerEvents();
        this.addDefaultFlushEvents();
        this.addDefaultGDPRWhiteList();
        this.updateFlushEvents();
        this.updateGDPRWhiteList();
    }

    public static MoEEventManager getInstance(Context context) {
        if (_INSTANCE == null) {
            _INSTANCE = new MoEEventManager(context);
        }
        return _INSTANCE;
    }

    private boolean isEventBlackListed(String eventName) {
        return !this.mBlackListedEvents.isEmpty() && this.mBlackListedEvents.contains(eventName);
    }

    void updateBlackListedEvents() {
        try {
            String[] blackListEventArray;
            this.mBlackListedEvents = new ArrayList<String>();
            String blackListEventsString = this.mConfigProvider.getBlackListEvents();
            if (!TextUtils.isEmpty((CharSequence)blackListEventsString) && (blackListEventArray = blackListEventsString.split(";")) != null && blackListEventArray.length > 0) {
                this.mBlackListedEvents.addAll(Arrays.asList(blackListEventArray));
            }
        }
        catch (Exception e) {
            Logger.e("MoEEventManager: updateBlackListedEvents() ", e);
        }
    }

    int getEventCounter() {
        return this.mEventCounter;
    }

    void incrementEventCounter() {
        ++this.mEventCounter;
    }

    void setEventCounter(int counter) {
        this.mEventCounter = counter;
    }

    public void trackEvent(String action, JSONObject attrs) {
        try {
            if (!this.mConfigProvider.isAppEnabled()) {
                return;
            }
            if (this.mConfigProvider.isDataTrackingOptedOut() && !this.isGDPRWhiteListEvent(action)) {
                Logger.e("MoEEventManager trackEvent() : Data tracking is opted out and this is not a GDPR whitelist event cannot track. Event: " + action);
                return;
            }
            if (this.isEventBlackListed(action)) {
                Logger.e("MoEEventManager: Event Blacklisted : " + action);
                return;
            }
            Event event = new Event(action.trim(), attrs);
            if (action.equals("INSTALL")) {
                MoEUtils.setInstallRegistered(this.mContext);
            }
            if (this.isSmartTriggerEvent(action)) {
                Logger.v("MoEEventManager:acting on auto trigger");
                InAppController.getInstance().registerAutoTriggerEvent(this.mContext, event);
            }
            MoEDTManager.getInstance().showTriggerIfPossible(this.mContext, action, attrs);
            MoEDispatcher.getInstance(this.mContext).writeDataPointToStorage(event);
            this.flushIfRequired(event);
        }
        catch (Exception e) {
            Logger.f("MoEEventManager: trackEvent() ", e);
        }
    }

    private boolean isSmartTriggerEvent(String action) {
        return this.mTriggerEvents != null && this.mTriggerEvents.contains(action) || "INSTALL".equals(action);
    }

    public void getTriggerEvents() {
        try {
            String list = this.mConfigProvider.getSmartTriggerList();
            if (list == null) {
                Logger.v("MoEEventManager:No smart triggers found");
                return;
            }
            String[] triggers = list.split(";");
            this.mTriggerEvents = new ArrayList<String>(triggers.length);
            for (String event : triggers) {
                this.mTriggerEvents.add(event);
            }
        }
        catch (Exception e) {
            Logger.e("MoEEventManager: getTriggerEvents()", e);
        }
    }

    void updateFlushEvents() {
        try {
            String events = this.mConfigProvider.getFlushEvents();
            if (TextUtils.isEmpty((CharSequence)events)) {
                Logger.v("MoEEventManager: updateFlushEvents() No flush events");
                return;
            }
            String[] flushEvents = events.split(";");
            if (this.mFlushEvents == null) {
                this.mFlushEvents = new ArrayList<String>();
            }
            this.mFlushEvents.addAll(Arrays.asList(flushEvents));
        }
        catch (Exception e) {
            Logger.e("MoEEventManager: updateFlushEvents()");
        }
    }

    private boolean isFlushEvent(String eventName) {
        return this.mFlushEvents != null && this.mFlushEvents.contains(eventName);
    }

    private void flushIfRequired(@NonNull Event event) {
        if (event.eventName != null && this.isFlushEvent(event.eventName)) {
            Logger.v("MoEEventManager flushIfRequired() flush event : " + event.eventName);
            MoEHelper.getInstance(this.mContext).syncInteractionDataNow();
        }
    }

    private void addDefaultFlushEvents() {
        if (this.mFlushEvents == null) {
            this.mFlushEvents = new ArrayList<String>();
        }
        this.mFlushEvents.add("NOTIFICATION_RECEIVED_MOE");
    }

    private void addDefaultGDPRWhiteList() {
        if (this.mGDPRWhiteList == null) {
            this.mGDPRWhiteList = new LinkedHashSet();
        }
        this.mGDPRWhiteList.add("NOTIFICATION_RECEIVED_MOE");
        this.mGDPRWhiteList.add("NOTIFICATION_CLICKED_MOE");
        this.mGDPRWhiteList.add("NOTIFICATION_CLEARED_MOE");
        this.mGDPRWhiteList.add(MoEHelperConstants.EVENT_IN_APP_SHOWN);
        this.mGDPRWhiteList.add(MoEHelperConstants.EVENT_IN_APP_CLICKED);
        this.mGDPRWhiteList.add(MoEHelperConstants.EVENT_IN_APP_AUTO_DISMISS);
        this.mGDPRWhiteList.add(MoEHelperConstants.EVENT_IN_APP_CLOSE_CLICKED);
        this.mGDPRWhiteList.add(MoEHelperConstants.IN_APP_CHECK_FAILURE_EVENT);
        this.mGDPRWhiteList.add(MoEHelperConstants.EVENT_ACTION_WEB_ACTIVITY_CLICK);
        this.mGDPRWhiteList.add("EVENT_ACTION_COUPON_CODE_COPY");
        this.mGDPRWhiteList.add(MoEHelperConstants.NOTIFICATION_OFFLINE_MOE);
        this.mGDPRWhiteList.add(MoEHelperConstants.DT_CAMPAIGN_SCHEDULED);
        this.mGDPRWhiteList.add("EVENT_ACTION_ACTIVITY_START");
        this.mGDPRWhiteList.add(MoEHelperConstants.APP_RATED_EVENT);
        this.mGDPRWhiteList.add("TOKEN_EVENT");
        this.mGDPRWhiteList.add("MOE_APP_EXIT");
    }

    void updateGDPRWhiteList() {
        if (this.mGDPRWhiteList == null) {
            this.mGDPRWhiteList = new LinkedHashSet();
        }
        try {
            String events = this.mConfigProvider.getGDPRWhiteListEvents();
            if (TextUtils.isEmpty((CharSequence)events)) {
                Logger.v("MoEEventManager updateGDPRWhiteList() No flush events");
                return;
            }
            String[] gdprWhiteListEvents = events.split(";");
            this.mGDPRWhiteList.addAll(Arrays.asList(gdprWhiteListEvents));
        }
        catch (Exception e) {
            Logger.e("MoEEventManagerupdateGDPRWhiteList()", e);
        }
    }

    private boolean isGDPRWhiteListEvent(String eventName) {
        return this.mGDPRWhiteList != null && this.mGDPRWhiteList.contains(eventName);
    }

    public void updateEventListFromRemote() {
        this.updateBlackListedEvents();
        this.updateFlushEvents();
        this.updateGDPRWhiteList();
    }
}

