/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.Context;
import android.os.Build;
import com.moe.pushlibrary.models.GeoLocation;
import com.moengage.core.APIManager;
import com.moengage.core.APIResponse;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import java.util.HashMap;

public class IntegrationVerificationNetworkCallTask
extends SDKTask {
    private TASK_TYPE task_type;

    public IntegrationVerificationNetworkCallTask(Context context, TASK_TYPE task_type) {
        super(context);
        this.task_type = task_type;
    }

    @Override
    public TaskResult execute() {
        try {
            switch (this.task_type) {
                case REGISTER_DEVICE: {
                    this.createResult(this.registerDevice());
                    break;
                }
                case UNREGISTER_DEVICE: {
                    this.createResult(this.unregisterDevice());
                    break;
                }
                default: {
                    Logger.e("IntegrationVerificationNetworkCallTask: invalid case");
                    break;
                }
            }
        }
        catch (Exception e) {
            Logger.f("IntegrationVerificationNetworkCallTask: Exception ", e);
        }
        return this.mTaskResult;
    }

    private APIResponse unregisterDevice() {
        String API = MoEUtils.getAPIRoute(this.mContext) + "/integration/unregister_device";
        return APIManager.registerUnregisterDeviceForIntegrationVerification(this.mContext, API, null);
    }

    private APIResponse registerDevice() {
        String API = MoEUtils.getAPIRoute(this.mContext) + "/integration/register_device";
        GeoLocation geoLocation = ConfigurationProvider.getInstance(this.mContext).getLastKnownUserLocation();
        if (geoLocation == null) {
            geoLocation = new GeoLocation(0.0, 0.0);
        }
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("lat", String.valueOf(geoLocation.latitude));
        paramsMap.put("lng", String.valueOf(geoLocation.longitude));
        paramsMap.put("manufacturer", Build.MANUFACTURER);
        return APIManager.registerUnregisterDeviceForIntegrationVerification(this.mContext, API, paramsMap);
    }

    @Override
    public String getTaskTag() {
        return "INTEGRATION_VERIFICATION_NETWORK_TASK";
    }

    @Override
    public boolean isSynchronous() {
        return true;
    }

    private void createResult(APIResponse apiResponse) {
        this.mTaskResult.setPayload(apiResponse);
    }

    public static enum TASK_TYPE {
        REGISTER_DEVICE,
        UNREGISTER_DEVICE;

    }
}

