/*
 * Decompiled with CFR 0.152.
 */
package com.moe.pushlibrary;

import android.location.Location;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.moe.pushlibrary.models.GeoLocation;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.ISO8601Utils;
import com.moengage.core.Logger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONObject;

public class PayloadBuilder {
    private static final String TAG = "PayloadBuilder";
    private JSONObject generalAttrs;
    private JSONObject customAttrs;
    private static final String ATTR_TIMESTAMP = "timestamp";
    private static final String ATTR_LOCATION = "location";

    private void notNullCheck(String attrName) throws Exception {
        if (TextUtils.isEmpty((CharSequence)attrName)) {
            throw new Exception("Action name cannot be empty");
        }
    }

    public PayloadBuilder putAttrInt(String attrName, int attrValue) {
        try {
            this.notNullCheck(attrName);
            if (null == this.generalAttrs) {
                this.generalAttrs = new JSONObject();
            }
            this.generalAttrs.put(attrName.trim(), attrValue);
        }
        catch (Exception e) {
            Logger.f("PayloadBuilder: putAttrInt", e);
        }
        return this;
    }

    public PayloadBuilder putAttrString(String attrName, String attrValue) {
        try {
            this.notNullCheck(attrName);
            if (null == this.generalAttrs) {
                this.generalAttrs = new JSONObject();
            }
            this.generalAttrs.put(attrName.trim(), (Object)attrValue);
        }
        catch (Exception e) {
            Logger.f("PayloadBuilder: putAttrString", e);
        }
        return this;
    }

    public PayloadBuilder putAttrBoolean(String attrName, boolean attrValue) {
        try {
            this.notNullCheck(attrName);
            if (null == this.generalAttrs) {
                this.generalAttrs = new JSONObject();
            }
            this.generalAttrs.put(attrName.trim(), attrValue);
        }
        catch (Exception e) {
            Logger.f("PayloadBuilder: putAttrBoolean", e);
        }
        return this;
    }

    public PayloadBuilder putAttrFloat(String attrName, float attrValue) {
        try {
            this.notNullCheck(attrName);
            if (null == this.generalAttrs) {
                this.generalAttrs = new JSONObject();
            }
            this.generalAttrs.put(attrName.trim(), (double)attrValue);
        }
        catch (Exception e) {
            Logger.f("PayloadBuilder: putAttrFloat", e);
        }
        return this;
    }

    public PayloadBuilder putAttrDouble(String attrName, double attrValue) {
        try {
            this.notNullCheck(attrName);
            if (null == this.generalAttrs) {
                this.generalAttrs = new JSONObject();
            }
            this.generalAttrs.put(attrName.trim(), attrValue);
        }
        catch (Exception e) {
            Logger.f("PayloadBuilder: putAttrDouble", e);
        }
        return this;
    }

    public PayloadBuilder putAttrLong(String attrName, long attrValue) {
        try {
            this.notNullCheck(attrName);
            if (null == this.generalAttrs) {
                this.generalAttrs = new JSONObject();
            }
            this.generalAttrs.put(attrName.trim(), attrValue);
        }
        catch (Exception e) {
            Logger.f("PayloadBuilder: putAttrLong", e);
        }
        return this;
    }

    public PayloadBuilder putAttrDate(String attrName, Date attrValue) {
        try {
            this.notNullCheck(attrName);
            if (null == this.customAttrs) {
                this.customAttrs = new JSONObject();
            }
            JSONArray timeStamp = this.customAttrs.has(ATTR_TIMESTAMP) ? this.customAttrs.getJSONArray(ATTR_TIMESTAMP) : new JSONArray();
            JSONObject attr = new JSONObject();
            attr.put(attrName.trim(), attrValue.getTime());
            timeStamp.put((Object)attr);
            this.customAttrs.put(ATTR_TIMESTAMP, (Object)timeStamp);
        }
        catch (Exception e) {
            Logger.f("EventPayload: putAttrDate: ", e);
        }
        return this;
    }

    public PayloadBuilder putAttrDate(String attrName, String dateString, String dateFormat) {
        try {
            this.notNullCheck(attrName);
            SimpleDateFormat format = new SimpleDateFormat(dateFormat, Locale.ENGLISH);
            return this.putAttrDate(attrName.trim(), format.parse(dateString));
        }
        catch (Exception e) {
            Logger.f("EventPayload: putAttrDate 2: ", e);
            return this;
        }
    }

    public PayloadBuilder putAttrLocation(String attrName, GeoLocation attrValue) {
        try {
            this.notNullCheck(attrName);
            if (null == this.customAttrs) {
                this.customAttrs = new JSONObject();
            }
            JSONArray location = this.customAttrs.has(ATTR_LOCATION) ? this.customAttrs.getJSONArray(ATTR_LOCATION) : new JSONArray();
            JSONObject attr = new JSONObject();
            attr.put(attrName.trim(), (Object)(attrValue.latitude + "," + attrValue.longitude));
            location.put((Object)attr);
            this.customAttrs.put(ATTR_LOCATION, (Object)location);
        }
        catch (Exception e) {
            Logger.f("EventPayload: putAttrLocation1: ", e);
        }
        return this;
    }

    public PayloadBuilder putAttrLocation(String attrName, Location attrValue) {
        try {
            this.notNullCheck(attrName);
            if (null == this.customAttrs) {
                this.customAttrs = new JSONObject();
            }
            JSONArray location = this.customAttrs.has(ATTR_LOCATION) ? this.customAttrs.getJSONArray(ATTR_LOCATION) : new JSONArray();
            JSONObject attr = new JSONObject();
            attr.put(attrName.trim(), (Object)(attrValue.getLatitude() + "," + attrValue.getLongitude()));
            location.put((Object)attr);
            this.customAttrs.put(ATTR_LOCATION, (Object)location);
        }
        catch (Exception e) {
            Logger.f("EventPayload: putAttrLocation2: ", e);
        }
        return this;
    }

    public PayloadBuilder putAttrLocation(String attrName, double latitude, double longitude) {
        try {
            this.notNullCheck(attrName);
            if (null == this.customAttrs) {
                this.customAttrs = new JSONObject();
            }
            JSONArray location = this.customAttrs.has(ATTR_LOCATION) ? this.customAttrs.getJSONArray(ATTR_LOCATION) : new JSONArray();
            JSONObject attr = new JSONObject();
            attr.put(attrName.trim(), (Object)(latitude + "," + longitude));
            location.put((Object)attr);
            this.customAttrs.put(ATTR_LOCATION, (Object)location);
        }
        catch (Exception e) {
            Logger.f("EventPayload: putAttrLocation3: ", e);
        }
        return this;
    }

    public PayloadBuilder putAttrDateEpoch(String attrName, long attrValue) {
        try {
            this.notNullCheck(attrName);
            if (null == this.customAttrs) {
                this.customAttrs = new JSONObject();
            }
            JSONArray timeStamp = this.customAttrs.has(ATTR_TIMESTAMP) ? this.customAttrs.getJSONArray(ATTR_TIMESTAMP) : new JSONArray();
            JSONObject attr = new JSONObject();
            attr.put(attrName.trim(), attrValue);
            timeStamp.put((Object)attr);
            this.customAttrs.put(ATTR_TIMESTAMP, (Object)timeStamp);
        }
        catch (Exception e) {
            Logger.f("EventPayload: putAttrDate: ", e);
        }
        return this;
    }

    public PayloadBuilder putAttrJSONArray(@NonNull String attrName, @NonNull JSONArray attrValue) {
        try {
            this.notNullCheck(attrName);
            if (attrValue == null) {
                return this;
            }
            if (null == this.generalAttrs) {
                this.generalAttrs = new JSONObject();
            }
            this.generalAttrs.put(attrName.trim(), (Object)attrValue);
        }
        catch (Exception e) {
            Logger.f("EventPayload: putAttrJSONArray: ", e);
        }
        return this;
    }

    public PayloadBuilder putAttrJSONObject(@NonNull String attrName, @NonNull JSONObject attrValue) {
        try {
            this.notNullCheck(attrName);
            if (attrValue == null) {
                return this;
            }
            if (null == this.generalAttrs) {
                this.generalAttrs = new JSONObject();
            }
            this.generalAttrs.put(attrName.trim(), (Object)attrValue);
        }
        catch (Exception e) {
            Logger.f("EventPayload: putAttrJSONObject: ", e);
        }
        return this;
    }

    public PayloadBuilder putAttrObject(@NonNull String attrName, @NonNull Object attrValue) {
        try {
            this.notNullCheck(attrName);
            if (attrValue == null) {
                return this;
            }
            if (null == this.generalAttrs) {
                this.generalAttrs = new JSONObject();
            }
            this.generalAttrs.put(attrName.trim(), attrValue);
        }
        catch (Exception e) {
            Logger.f("EventPayload: putAttrObject() : Exception ", e);
        }
        return this;
    }

    public PayloadBuilder putAttrISO8601Date(@NonNull String attrName, @NonNull String attrValue) {
        try {
            this.notNullCheck(attrName);
            if (TextUtils.isEmpty((CharSequence)attrValue)) {
                Logger.e("PayloadBuilder putAttrISO8601Date() : Attribute value cannot be empty");
                return this;
            }
            long epochValue = ISO8601Utils.parse(attrValue).getTime();
            this.putAttrDateEpoch(attrName, epochValue);
        }
        catch (Exception e) {
            Logger.f("PayloadBuilder putAttrISO8601Date() : ");
        }
        return this;
    }

    public JSONObject build() {
        return MoEHelperUtils.getDatapointJSON(this.generalAttrs, this.customAttrs);
    }
}

