/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.app.job.JobParameters;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import com.moengage.core.APIManager;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.OnJobComplete;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.push.MoEMessagingManager;
import java.util.HashMap;
import org.json.JSONObject;

public class FetchMessagesFromServerTask
extends SDKTask {
    private static final String TAG = "FetchMessagesFromServerTask";
    private String API;
    private HashMap<String, String> paramsMap;
    private JSONObject requestBody;
    private OnJobComplete jobCompleteCallback;
    private JobParameters jobParameters;

    public FetchMessagesFromServerTask(Context context, String API, HashMap<String, String> paramsMap, OnJobComplete jobCompleteCallback, JobParameters parameters) {
        super(context);
        this.API = API;
        this.paramsMap = paramsMap;
        this.jobCompleteCallback = jobCompleteCallback;
        this.jobParameters = parameters;
    }

    @Override
    public TaskResult execute() {
        String response = null;
        try {
            JSONObject responseJSON;
            if (!ConfigurationProvider.getInstance(this.mContext).isInboxEnabled() || !ConfigurationProvider.getInstance(this.mContext).isAppEnabled()) {
                return null;
            }
            response = APIManager.fetchMessages(this.mContext, this.API, this.paramsMap);
            if (!TextUtils.isEmpty((CharSequence)response) && (responseJSON = new JSONObject(response)) != null) {
                ConfigurationProvider.getInstance(this.mContext).setLastMessageFetchTime(System.currentTimeMillis());
                MoEMessagingManager.MessagingHandler messageHandler = MoEMessagingManager.getInstance().getMessagingHandler(this.mContext);
                if (messageHandler != null) {
                    messageHandler.parsePayloadAndShowPush(this.mContext, responseJSON);
                }
            }
            this.releaseJobLockIfRequired();
        }
        catch (Exception e) {
            Logger.f("FetchMessagesFromServerTask : response : " + response + "execute ", e);
        }
        return null;
    }

    private void releaseJobLockIfRequired() {
        if (Build.VERSION.SDK_INT >= 21 && this.jobCompleteCallback != null && this.jobParameters != null) {
            Logger.v("FetchMessagesFromServerTask releaseJobLockIfRequired() : Trying to release job lock.");
            this.jobCompleteCallback.jobCompleted(this.jobParameters, false);
        }
    }

    @Override
    public String getTaskTag() {
        return "FETCH_MESSAGES";
    }

    @Override
    public boolean isSynchronous() {
        return false;
    }
}

