/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.text.TextUtils;
import com.moe.pushlibrary.MoEHelper;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.DataSyncJob;
import com.moengage.core.Logger;
import com.moengage.core.MoEAlarmReceiver;
import com.moengage.core.MoEDTManager;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.core.listeners.OnAppBackgroundListener;
import com.moengage.inapp.InAppController;
import com.moengage.push.MoEMessagingManager;

class ActivityStopTask
extends SDKTask {
    private static final String TAG = "ActivityStopTask";
    private String mCurrentActivityName;
    private int DATA_SYNC_JOB_ID = 99999;

    ActivityStopTask(Context context, String currentActivityName) {
        super(context);
        this.mCurrentActivityName = currentActivityName;
    }

    @Override
    public TaskResult execute() {
        Logger.v("ActivityStopTask : executing task");
        if (!TextUtils.isEmpty((CharSequence)this.mCurrentActivityName)) {
            Logger.v("ActivityLifecycleStop : " + this.mCurrentActivityName + " stopped");
        }
        Logger.d("ActivityStopTask: activity counter " + MoEHelper.getActivityCounter());
        if (MoEHelper.getActivityCounter() == 0) {
            Logger.v("ActivityStopTask: Activity counter zero, will try to send interaction data");
            OnAppBackgroundListener listener = MoEHelper.getInstance(this.mContext).getOnAppBackgroundListener();
            if (listener != null) {
                listener.goingToBackground();
            } else {
                Logger.v("ActivityStopTask execute() : on app background listener not set cannot provide callback");
            }
            this.trackAppExitIfRequired();
            MoEDispatcher.getInstance(this.mContext).shutDownPeriodicFlush();
            InAppController.getInstance().writeInAppCheckFailureCounterToStorage(this.mContext);
            if (Build.VERSION.SDK_INT < 21) {
                this.scheduleDataSending();
            } else {
                this.scheduleDataSendingJob();
            }
            MoEMessagingManager.MessagingHandler messagingHandler = MoEMessagingManager.getInstance().getMessagingHandler(this.mContext);
            if (messagingHandler != null) {
                messagingHandler.scheduleMessageSync(this.mContext);
            }
            MoEDTManager.getInstance().scheduleBackgroundSync(this.mContext);
            MoEDispatcher.getInstance(this.mContext).resetStates();
            ConfigurationProvider.getInstance(this.mContext).storeSentScreenList();
        }
        Logger.v("ActivityStopTask : completed execution");
        return null;
    }

    @Override
    public String getTaskTag() {
        return "ACTIVITY_STOP";
    }

    @Override
    public boolean isSynchronous() {
        return false;
    }

    private void scheduleDataSending() {
        Logger.v("ActivityStopTask: scheduleDataSending()");
        Intent alarmIntent = new Intent(this.mContext, MoEAlarmReceiver.class);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)123, (Intent)alarmIntent, (int)0x8000000);
        AlarmManager alarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        if (alarmManager != null) {
            alarmManager.set(0, System.currentTimeMillis() + 3000L, pendingIntent);
        }
    }

    @TargetApi(value=21)
    private void scheduleDataSendingJob() {
        Logger.v("ActivityStopTask: scheduleDataSendingJob()");
        ComponentName serviceComponent = new ComponentName(this.mContext, DataSyncJob.class);
        JobInfo.Builder builder = new JobInfo.Builder(this.DATA_SYNC_JOB_ID, serviceComponent);
        builder.setRequiredNetworkType(1);
        builder.setOverrideDeadline(System.currentTimeMillis() + 5000L);
        builder.setMinimumLatency(2000L);
        JobScheduler jobScheduler = (JobScheduler)this.mContext.getSystemService("jobscheduler");
        if (jobScheduler != null) {
            jobScheduler.schedule(builder.build());
        }
    }

    private void trackAppExitIfRequired() {
        if (ConfigurationProvider.getInstance(this.mContext).shouldTrackAppExit()) {
            MoEHelper.getInstance(this.mContext).trackEvent("MOE_APP_EXIT");
        }
    }
}

