package com.moengage.core;

import android.app.job.JobParameters;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import com.moengage.push.MoEMessagingManager;
import java.util.HashMap;
import org.json.JSONObject;

/**
 * @author Umang Chamaria
 */

public class FetchMessagesFromServerTask extends SDKTask {

  private static final String TAG = "FetchMessagesFromServerTask";

  private String API;
  private HashMap<String, String> paramsMap;
  private JSONObject requestBody;
  private OnJobComplete jobCompleteCallback;
  private JobParameters jobParameters;

  public FetchMessagesFromServerTask(Context context, String API, HashMap<String, String> paramsMap,
      OnJobComplete jobCompleteCallback, JobParameters parameters) {
    super(context);
    this.API = API;
    this.paramsMap = paramsMap;
    this.jobCompleteCallback = jobCompleteCallback;
    this.jobParameters = parameters;
  }

  @Override public TaskResult execute() {
    String response = null;
    try {
      if (!ConfigurationProvider.getInstance(mContext).isInboxEnabled()
          || !ConfigurationProvider.getInstance(mContext).isAppEnabled()) {
        return null;
      }
      response = APIManager.fetchMessages(mContext, API, paramsMap);
      if (!TextUtils.isEmpty(response)) {
        JSONObject responseJSON = new JSONObject(response);
        if (responseJSON != null) {
          ConfigurationProvider.getInstance(mContext)
              .setLastMessageFetchTime(System.currentTimeMillis());
          MoEMessagingManager.MessagingHandler messageHandler =
              MoEMessagingManager.getInstance().getMessagingHandler(mContext);
          if (messageHandler != null) {
            messageHandler.parsePayloadAndShowPush(mContext, responseJSON);
          }
        }
      }
      releaseJobLockIfRequired();
    } catch (Exception e) {
      Logger.f("FetchMessagesFromServerTask : response : " + response + "execute ", e);
    }
    return null;
  }

  private void releaseJobLockIfRequired() {
    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP
        && jobCompleteCallback != null
        && jobParameters != null) {
      Logger.v(TAG + " releaseJobLockIfRequired() : Trying to release job lock.");
      jobCompleteCallback.jobCompleted(jobParameters, false);
    }
  }

  @Override public String getTaskTag() {
    return TAG_FETCH_MESSAGES;
  }

  @Override public boolean isSynchronous() {
    return false;
  }
}
