/* ************************************************************************
 *
 * MOENGAGE CONFIDENTIAL
 * __________________
 *
 *  [2014] - [2015] MoEngage Inc.
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of MoEngage Inc. The intellectual and technical concepts
 * contained herein are proprietary to MoEngage Incorporated
 * and its suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from MoEngage Incorporated.
 */
package com.moe.pushlibrary.utils;

import com.moengage.core.Logger;
import java.lang.reflect.InvocationTargetException;

/**
 * A Utility class which helps to invoke methods using Java Reflection API in order to avoid
 * @author MoEngage (abhishek@moenegage.com)
 * @since 5.0
 * @version 5.0
 */
public final class ReflectionUtils {

  private ReflectionUtils() {
    throw new IllegalStateException("This class cannot be instantiated");
  }

  public static Object invokeStatic(Class<?> classObject, String methodName, Class<?>[] types,
      Object[] args) {
    return invocationHelper(null, classObject, null, methodName, null, types, args);
  }

  public static Object invokeStatic(String className, String methodName, Class<?>[] types,
      Object[] args) {
    return invocationHelper(null, null, className, methodName, null, types, args);
  }

  public static Object getAttribute(String className, String attrName){
    if( null == attrName || attrName.isEmpty()){
      return null;
    }
    return invocationHelper(null, null, className, attrName, null, null, null);
  }

  public static Object invokeInstance(Object target, String methodName, Class<?>[] types,
      Object[] args) {
    return invocationHelper(target, null, null, methodName, null, types, args);
  }
  private static Object invocationHelper(Object target, Class<?> classObject, String className,
      String methodName, String attributeName, Class<?>[] argTypes, Object[] args) {
    try {
      Class cls;
      if (classObject != null) {
        cls = classObject;
      } else {
        if (target != null) {
          cls = target.getClass();
        } else {
          cls = Class.forName(className);
        }
      }
      if( attributeName != null){
        return cls.getField(attributeName);
      }else if(null != methodName ){
        return cls.getMethod(methodName, argTypes).invoke(target, args);
      }else{
        return cls;
      }
    } catch (NoSuchMethodException e) {
      Logger.e("ReflectionUtils:invocationHelper" + e.getMessage());
    } catch (IllegalAccessException e) {
      Logger.e("ReflectionUtils:invocationHelper" + e.getMessage());
    } catch (InvocationTargetException e) {
      Logger.e("ReflectionUtils:invocationHelper" + e.getMessage());
    } catch (ClassNotFoundException e) {
      Logger.e("ReflectionUtils:invocationHelper" + e.getMessage());
    } catch (Exception e){
      Logger.e("ReflectionUtils:invocationHelper" + e.getMessage());
    }
    return null;
  }

  public static boolean isClassPresentInPath(String className){
    try{
     Class.forName(className);
      return true;
    }catch(Exception e){
      Logger.e("ReflectionUtils:isClassPresentInPath" + e.getMessage());
    }
    return false;
  }
}
