package com.moe.pushlibrary.models;

import android.os.Parcel;
import android.os.Parcelable;
import com.moengage.core.Logger;
import org.json.JSONObject;

/**
 * @author Umang Chamaria
 */

public class BatchData implements Parcelable {

  public long _id;
  public JSONObject batchData;

  public BatchData(long _id, JSONObject batchData){
    this._id = _id;
    this.batchData = batchData;
  }

  public BatchData(Parcel in) {
    readFromParcel(in);
  }

  public static final Creator<BatchData> CREATOR = new Creator<BatchData>() {
    @Override public BatchData createFromParcel(Parcel in) {
      return new BatchData(in);
    }

    @Override public BatchData[] newArray(int size) {
      return new BatchData[size];
    }
  };

  @Override public int describeContents() {
    return 0;
  }

  @Override public void writeToParcel(Parcel dest, int flags) {
    dest.writeLong(_id);
    dest.writeString(batchData.toString());
  }

  public void readFromParcel(Parcel in) {
    try {
      _id = in.readLong();
      String batchDataString = in.readString();
      batchData = new JSONObject(batchDataString);
    } catch (Exception e) {
      Logger.e( "BatchDate readFromParcel() : Exception ", e);
    }
  }
}
