/* ************************************************************************
 * 
 * MOENGAGE CONFIDENTIAL
 * __________________
 * 
 *  [2014] - [2015] MoEngage Inc. 
 *  All Rights Reserved.
 * 
 * NOTICE:  All information contained herein is, and remains
 * the property of MoEngage Inc. The intellectual and technical concepts
 * contained herein are proprietary to MoEngage Incorporated
 * and its suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from MoEngage Incorporated.
 */
package com.moe.pushlibrary;

import android.app.IntentService;
import android.content.Intent;
import android.os.Bundle;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.Logger;
import com.moengage.core.MoEAlarmReceiver;
import com.moengage.core.MoEDispatcher;

/**
 * @author MoEngage (abhishek@moengage.com)
 * @version 5.0
 * @since 5.0
 */
// This Intent Service has the ability to do different kind of work based on the
// intent extra that is passed to this service
public class MoEWorker extends IntentService {

  public MoEWorker() {
    super("MoEWorker");
  }

  public static final int REQ_CODE_SEND_DATA = 123;
  public static final String EXTRA_SERVICE_TYPE_SEND_DATA = "DEAL_WITH_SENDING_DATA";

  /*
   * (non-Javadoc)
   *
   * @see android.app.IntentService#onHandleIntent(android.content.Intent)
   */
  @Override protected void onHandleIntent(Intent intent) {
    try {
      if (null == intent) return;
      Bundle extras = intent.getExtras();
      MoEHelperUtils.dumpIntentExtras(extras);
      if (extras.containsKey(EXTRA_SERVICE_TYPE_SEND_DATA)) {
        MoEDispatcher.getInstance(getApplicationContext()).sendInteractionData();
        MoEAlarmReceiver.completeWakefulIntent(intent);
      } else{
        Logger.e("Did not understand request");
      }
    } catch (Exception e) {
      Logger.f("MoEWorker: onHandleIntent", e);
    }
  }
}
