package com.moe.pushlibrary;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.os.Build;
import android.os.Bundle;
import com.moengage.core.Logger;

/**
 * Lifecycle Callbacks for auto-integration {@link Application#registerActivityLifecycleCallbacks(Application.ActivityLifecycleCallbacks)}<br>
 * @author  Umang Chamaria
 */
@TargetApi(Build.VERSION_CODES.ICE_CREAM_SANDWICH)
public class MoEActivityLifeCycleCallBacks implements Application.ActivityLifecycleCallbacks {

  private MoEHelper moEHelper;

  @Override
  public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    try {
      initializeMoEngageHelper(activity);
    } catch (Exception e) {
      Logger.f("MoEActivityLifeCycleCallBacks : onActivityCreated", e);
    }
  }

  @Override
  public void onActivityStarted(Activity activity) {
    try {
      initializeMoEngageHelper(activity);
      if (moEHelper != null) {
        moEHelper.onStartInternal(activity);
      }
    } catch (Exception e) {
      Logger.f("MoEActivityLifeCycleCallBacks : onActivityStarted", e);
    }
  }

  @Override
  public void onActivityResumed(Activity activity) {
    try {
      initializeMoEngageHelper(activity);
      if (moEHelper != null) {
        moEHelper.onResumeInternal(activity);
      }
    } catch (Exception e) {
      Logger.f("MoEActivityLifeCycleCallBacks : onActivityResumed", e);
    }
  }

  @Override
  public void onActivityPaused(Activity activity) {
    //Do Nothing
  }

  @Override
  public void onActivityStopped(Activity activity) {
    try {
      initializeMoEngageHelper(activity);
      if (moEHelper != null) {
        moEHelper.onStopInternal(activity);
      }
    } catch (Exception e) {
      Logger.f("MoEActivityLifeCycleCallBacks : onActivityStopped", e);
    }
  }

  @Override
  public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    try {
      initializeMoEngageHelper(activity);
      if (moEHelper != null) {
        moEHelper.onSaveInstanceState(outState);
      }
    } catch (Exception e) {
      Logger.f("MoEActivityLifeCycleCallBacks : onActivitySaveInstanceState", e);
    }
  }

  @Override
  public void onActivityDestroyed(Activity activity) {
    //Do Nothing
  }

  private void initializeMoEngageHelper(Activity activity){
    if (moEHelper == null && activity != null) {
      moEHelper = MoEHelper.getInstance(activity.getApplicationContext());
    }
  }
}
