/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import com.moe.pushlibrary.exceptions.SDKNotInitializedException;
import com.moengage.core.AdvertisingIdClient;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEUtils;
import com.moengage.push.PushManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.net.ssl.HttpsURLConnection;

final class MoERestClient {
    private static final String ENCODING_CHARSET_UTF8 = "UTF-8";
    private static final String URL_PARAM_SEPARATOR = "&";
    private static final String URL_PARAM_ASSIGNER = "=";
    private static final String URL_QUERY_PARAM_SEPARATOR = "?";
    private static String ANDROID_ID = null;
    private static boolean androidIDRetrieved = false;
    private HashMap<String, String> params;
    private String mStringBody = null;
    private byte[] mByteArray = null;
    private String url;
    private int responseCode;
    private String response;
    private String errorResponse;
    private String appID;
    private static final String SCHEME_HTTPS = "https://";

    public String getResponse() {
        return this.response;
    }

    int getResponseCode() {
        return this.responseCode;
    }

    MoERestClient(String url, Context con, API_VERSION apiVersion) throws SDKNotInitializedException {
        this.url = url;
        this.params = new HashMap();
        if (!androidIDRetrieved) {
            androidIDRetrieved = true;
            ANDROID_ID = MoEUtils.getAndroidID(con);
        }
        this.appID = ConfigurationProvider.getInstance(con).getAppId();
        if (API_VERSION.V1 == apiVersion) {
            this.initializeRestClientV1(con);
        } else {
            this.initializeRestClientV2(con);
        }
    }

    private void initializeRestClientV1(Context con) throws SDKNotInitializedException {
        this.params.put("os_value", "ANDROID");
        ConfigurationProvider provider = ConfigurationProvider.getInstance(con);
        String registrationId = provider.getGCMToken();
        String appId = provider.getAppId();
        String newUniqueID = provider.getCurrentUserId();
        appId = MoEUtils.addDebugIfRequired(con, appId);
        if (!TextUtils.isEmpty((CharSequence)registrationId)) {
            this.addParam("gcmId", registrationId);
        }
        if (!TextUtils.isEmpty((CharSequence)appId)) {
            this.addParam("appId", appId);
        } else {
            appId = provider.getAppId();
            if (TextUtils.isEmpty((CharSequence)appId)) {
                throw new SDKNotInitializedException("APP ID has not been set");
            }
            this.addParam("appId", appId);
        }
        if (!TextUtils.isEmpty((CharSequence)newUniqueID)) {
            this.addParam("unique_id", newUniqueID);
        }
        this.addParam("version", Integer.toString(provider.getAppVersion()));
        this.addParam("libVersion", Integer.toString(9102));
        this.addBaiduParamIfRequired();
        this.addSegmentParamIfRequired(con);
    }

    private void initializeRestClientV2(Context con) throws SDKNotInitializedException {
        ConfigurationProvider provider = ConfigurationProvider.getInstance(con);
        String registrationId = provider.getGCMToken();
        String appId = provider.getAppId();
        String newUniqueID = provider.getCurrentUserId();
        String appVersion = Integer.toString(provider.getAppVersion());
        long millis = System.currentTimeMillis();
        appId = MoEUtils.addDebugIfRequired(con, appId);
        if (!TextUtils.isEmpty((CharSequence)registrationId) && !provider.isPushNotificationOptedOut()) {
            this.addParam("push_id", registrationId);
        }
        if (!TextUtils.isEmpty((CharSequence)appId)) {
            this.addParam("app_id", appId);
        } else {
            appId = provider.getAppId();
            if (TextUtils.isEmpty((CharSequence)appId)) {
                throw new SDKNotInitializedException("APP ID has not been set");
            }
            this.addParam("app_id", appId);
        }
        if (!TextUtils.isEmpty((CharSequence)newUniqueID)) {
            this.addParam("unique_id", newUniqueID);
        }
        if (!TextUtils.isEmpty((CharSequence)appVersion)) {
            this.addParam("app_ver", appVersion);
        }
        this.addParam("os", "ANDROID");
        this.addParam("sdk_ver", Integer.toString(9102));
        this.addParam("device_tz_offset", String.valueOf(TimeZone.getDefault().getOffset(millis)));
        this.addParam("device_ts", String.valueOf(millis));
        this.addParam("device_tz", TimeZone.getDefault().getID());
        this.addPlatformIfRequired(provider);
        this.addBaiduParamIfRequired();
        this.addSegmentParamIfRequired(con);
        if (!provider.isDataTrackingOptedOut()) {
            if (!TextUtils.isEmpty((CharSequence)ANDROID_ID)) {
                this.addParam("android_id", ANDROID_ID);
            }
            if (!provider.isAdIdCollectionProhibitted()) {
                AdvertisingIdClient.AdInfo adInfo;
                String gaid = provider.getStoredGAID();
                if (TextUtils.isEmpty((CharSequence)gaid) && (adInfo = MoEUtils.getAdvertisementInfo(con)) != null) {
                    gaid = adInfo.getId();
                    provider.storeGAID(gaid);
                }
                if (!TextUtils.isEmpty((CharSequence)gaid)) {
                    this.addParam("moe_gaid", gaid);
                }
            }
            this.addParam("os_ver", String.valueOf(Build.VERSION.SDK_INT));
            this.addParam("model", Build.MODEL);
            this.addParam("app_version_name", provider.getAppVersionName());
            String nwType = MoEUtils.getNetworkType(con);
            if (!TextUtils.isEmpty((CharSequence)nwType)) {
                this.addParam("networkType", nwType);
            }
        }
    }

    private void addParam(String name, String Value) {
        this.params.put(name, Value);
    }

    void addParam(HashMap<String, String> paramsMap) {
        for (Map.Entry<String, String> entry : paramsMap.entrySet()) {
            this.params.put(entry.getKey(), entry.getValue());
        }
    }

    void addBody(String requestBody) {
        this.mStringBody = requestBody;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String convertStreamToString(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            Logger.f("MoERestClient:executeRequest: IOException", e);
        }
        catch (Exception e) {
            Logger.f("MoERestClient:executeRequest: Exception", e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                Logger.f("MoERestClient:executeRequest: IOException", e);
            }
            catch (Exception e) {
                Logger.f("MoERestClient:executeRequest: Exception", e);
            }
        }
        return sb.toString();
    }

    private String getFinalURI(String URI2) {
        StringBuilder builder = new StringBuilder(URI2);
        if (!this.params.isEmpty()) {
            builder.append(URL_QUERY_PARAM_SEPARATOR);
            int size = this.params.size();
            Set<Map.Entry<String, String>> mapParams = this.params.entrySet();
            int index = 0;
            for (Map.Entry<String, String> param : mapParams) {
                try {
                    builder.append(param.getKey());
                    builder.append(URL_PARAM_ASSIGNER);
                    builder.append(URLEncoder.encode(param.getValue(), ENCODING_CHARSET_UTF8));
                    if (index <= size - 2) {
                        builder.append(URL_PARAM_SEPARATOR);
                    }
                    ++index;
                }
                catch (Exception e) {
                    Logger.f("MoERestClient: getFinalURI ", e);
                }
            }
        }
        return builder.toString();
    }

    public void execute(RequestMethod method) throws IOException {
        URL finalURL = new URL(this.getFinalURI(this.url));
        Logger.d("MoERestClient: executing API: " + finalURL.toString());
        HttpURLConnection urlConnection = null;
        if (this.url.startsWith(SCHEME_HTTPS)) {
            urlConnection = (HttpsURLConnection)urlConnection;
            urlConnection = (HttpsURLConnection)finalURL.openConnection();
        } else {
            urlConnection = (HttpURLConnection)finalURL.openConnection();
        }
        if (method == RequestMethod.POST) {
            this.addBody(urlConnection);
        } else {
            urlConnection.setRequestMethod("GET");
            urlConnection.addRequestProperty("X-MOENGAGE-APP-KEY", this.appID);
        }
        this.responseCode = urlConnection.getResponseCode();
        Logger.d("MoERestClient: ResponseCode: " + this.responseCode);
        if (200 != this.responseCode) {
            this.errorResponse = this.convertStreamToString(urlConnection.getErrorStream());
            Logger.f("MoERestClient: Response: API Failed: " + this.url + " response code :" + this.responseCode + "reason : " + this.errorResponse);
            if (!TextUtils.isEmpty((CharSequence)this.errorResponse)) {
                Logger.f("MoERestClient: with reason: " + this.errorResponse);
            }
            return;
        }
        InputStream in = urlConnection.getInputStream();
        this.response = this.convertStreamToString(in);
        urlConnection.disconnect();
        if (!TextUtils.isEmpty((CharSequence)this.response)) {
            Logger.d("MoERestClient: Response: " + this.response);
        }
    }

    private void addBody(HttpURLConnection connection) throws IOException {
        connection.setDoOutput(true);
        connection.setRequestProperty("Accept-Charset", ENCODING_CHARSET_UTF8);
        connection.setRequestProperty("Content-type", "application/json");
        connection.addRequestProperty("X-MOENGAGE-APP-KEY", this.appID);
        OutputStream output = connection.getOutputStream();
        if (null != this.mStringBody) {
            Logger.d("MoERestClient: addBody: string: " + this.mStringBody);
            output.write(this.mStringBody.getBytes(ENCODING_CHARSET_UTF8));
        } else if (null != this.mByteArray) {
            Logger.d("MoERestClient: addBody: bytes: " + this.mByteArray.toString());
            output.write(this.mByteArray);
        }
        output.close();
    }

    private void addPlatformIfRequired(ConfigurationProvider provider) {
        String platform = provider.getUnityVersion();
        if (!TextUtils.isEmpty((CharSequence)platform)) {
            this.addParam("unity_ver", platform);
        }
    }

    private void addBaiduParamIfRequired() {
        if (PushManager.getInstance().isIsBaiduEnabled()) {
            this.addParam("moe_push_ser", "baidu");
        } else {
            this.addParam("moe_push_ser", "android");
        }
    }

    private void addSegmentParamIfRequired(Context context) {
        if (ConfigurationProvider.getInstance(context).isSegmentEnabled()) {
            this.addParam("integration_type", "segment");
        }
    }

    public static enum API_VERSION {
        V1,
        V2;

    }

    public static enum RequestMethod {
        GET,
        POST;

    }
}

