/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.ContentProviderOperation;
import android.content.ContentValues;
import android.content.Context;
import android.content.OperationApplicationException;
import android.database.Cursor;
import android.net.Uri;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.moe.pushlibrary.models.BatchData;
import com.moe.pushlibrary.models.Event;
import com.moe.pushlibrary.models.UserAttribute;
import com.moe.pushlibrary.providers.MoEDataContract;
import com.moengage.core.Logger;
import java.util.ArrayList;

public final class MoEDAO {
    private static MoEDAO _INSTANCE = null;
    private Uri MESSAGES_CONTENT_URI = null;
    private Uri INAPP_CONTENT_URI = null;
    private Uri DATAPOINTS_CONTENT_URI = null;
    private Uri USER_ATTRIBUTES_URI = null;
    private Uri CAMPAIGN_LIST_URI = null;
    private Uri BATCHED_DATA_URI = null;
    private String AUTHORITY = null;
    private Context mContext;

    public static MoEDAO getInstance(Context context) {
        if (null == _INSTANCE) {
            _INSTANCE = new MoEDAO(context);
        }
        return _INSTANCE;
    }

    private MoEDAO(Context context) {
        this.MESSAGES_CONTENT_URI = MoEDataContract.MessageEntity.getContentUri(context);
        this.INAPP_CONTENT_URI = MoEDataContract.InAppMessageEntity.getContentUri(context);
        this.DATAPOINTS_CONTENT_URI = MoEDataContract.DatapointEntity.getContentUri(context);
        this.USER_ATTRIBUTES_URI = MoEDataContract.UserAttributeEntity.getContentUri(context);
        this.CAMPAIGN_LIST_URI = MoEDataContract.CampaignListEntity.getContentUri(context);
        this.BATCHED_DATA_URI = MoEDataContract.BatchDataEntity.getContentUri(context);
        this.AUTHORITY = MoEDataContract.getAuthority(context);
        this.mContext = context;
    }

    int getUnreadMessageCount() {
        Cursor cur = this.mContext.getContentResolver().query(this.MESSAGES_CONTENT_URI, MoEDataContract.MessageEntity.PROJECTION, "msgclicked = ?", new String[]{"0"}, "gtime DESC");
        int unReadCount = 0;
        if (null != cur) {
            unReadCount = cur.getCount();
            this.closeCursor(cur);
        }
        Logger.v("Getting Unread PromotionalMessage Count: count=" + unReadCount);
        return unReadCount;
    }

    void addEvent(Event event, Context context) {
        if (null == event) {
            Logger.v("Null event passed, skipping it");
            return;
        }
        Logger.v("Event : " + event.details);
        ContentValues values = new ContentValues();
        values.put("gtime", Long.valueOf(event.gtime));
        values.put("details", event.details);
        Uri newRecord = context.getContentResolver().insert(this.DATAPOINTS_CONTENT_URI, values);
        if (null != newRecord) {
            Logger.v("New Event added with Uri: " + newRecord.toString());
        } else {
            Logger.v("Unable to add event");
        }
    }

    ArrayList<Event> getInteractionData(int batchSize) {
        Uri CONTENT_URI = this.DATAPOINTS_CONTENT_URI.buildUpon().appendQueryParameter("LIMIT", String.valueOf(batchSize)).build();
        Cursor cur = this.mContext.getContentResolver().query(CONTENT_URI, MoEDataContract.DatapointEntity.PROJECTION, null, null, "gtime ASC");
        if (null == cur || cur.getCount() == 0) {
            Logger.v("Empty cursor");
            this.closeCursor(cur);
            return null;
        }
        ArrayList<Event> eventList = new ArrayList<Event>();
        while (cur.moveToNext()) {
            eventList.add(new Event(cur.getInt(0), cur.getString(2)));
        }
        this.closeCursor(cur);
        return eventList;
    }

    void deleteInteractionData(ArrayList<Event> events, Context context) {
        ArrayList<ContentProviderOperation> operations = new ArrayList<ContentProviderOperation>();
        for (Event item : events) {
            ContentProviderOperation operation = ContentProviderOperation.newDelete((Uri)this.DATAPOINTS_CONTENT_URI).withSelection("_id = ?", new String[]{String.valueOf(item._id)}).build();
            operations.add(operation);
        }
        try {
            context.getContentResolver().applyBatch(this.AUTHORITY, operations);
        }
        catch (RemoteException e) {
            Logger.f("MoEDAO: deleteInteractionData", e);
        }
        catch (OperationApplicationException e) {
            Logger.f("MoEDAO: deleteInteractionData", e);
        }
        catch (Exception e) {
            Logger.f("MoEDAO: deleteInteractionData", e);
        }
    }

    Cursor getMessages(Context context) {
        return context.getContentResolver().query(this.MESSAGES_CONTENT_URI, MoEDataContract.MessageEntity.PROJECTION, null, null, "gtime DESC");
    }

    boolean setMessageClicked(long id2) {
        Uri updateRec = this.MESSAGES_CONTENT_URI.buildUpon().appendPath(String.valueOf(id2)).build();
        ContentValues values = new ContentValues();
        values.put("msgclicked", Integer.valueOf(1));
        int rowCount = this.mContext.getContentResolver().update(updateRec, values, null, null);
        this.mContext.getContentResolver().notifyChange(updateRec, null);
        return rowCount > 0;
    }

    void removeExpiredData() {
        String currTime = Long.toString(System.currentTimeMillis());
        int rows = this.mContext.getContentResolver().delete(this.INAPP_CONTENT_URI, "ttl < ? AND status = ?", new String[]{Long.toString(System.currentTimeMillis() / 1000L), "expired"});
        Logger.v("MoEDAO:removeExpiredData: Number of IN APP records deleted: " + rows);
        rows = this.mContext.getContentResolver().delete(this.MESSAGES_CONTENT_URI, "msgttl < ?", new String[]{currTime});
        Logger.v("MoEDAO:removeExpiredData: Number of PromotionalMessage records deleted: " + rows);
        rows = this.mContext.getContentResolver().delete(this.CAMPAIGN_LIST_URI, "ttl < ?", new String[]{currTime});
        Logger.v("MoEDAO:removeExpiredData: Number of CampaignList records deleted: " + rows);
        this.mContext.getContentResolver().notifyChange(this.INAPP_CONTENT_URI, null);
        this.mContext.getContentResolver().notifyChange(this.MESSAGES_CONTENT_URI, null);
    }

    boolean setMessageClickedByTime(long gtime) {
        ContentValues values = new ContentValues();
        values.put("msgclicked", Integer.valueOf(1));
        int rowCount = this.mContext.getContentResolver().update(this.MESSAGES_CONTENT_URI, values, "gtime = ? ", new String[]{String.valueOf(gtime)});
        this.mContext.getContentResolver().notifyChange(this.MESSAGES_CONTENT_URI, null);
        return rowCount > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addOrUpdateUserAttribute(@NonNull UserAttribute userAttribute) {
        if (userAttribute == null) {
            return;
        }
        Logger.v("User Attribute -->" + userAttribute.userAttributeName + ":" + userAttribute.userAttributeValue);
        ContentValues contentValues = new ContentValues();
        contentValues.put("attribute_name", userAttribute.userAttributeName);
        contentValues.put("attribute_value", userAttribute.userAttributeValue);
        try (Cursor cursor = null;){
            cursor = this.mContext.getContentResolver().query(this.USER_ATTRIBUTES_URI, MoEDataContract.UserAttributeEntity.PROJECTION, "attribute_name=?", new String[]{userAttribute.userAttributeName}, null);
            if (cursor != null && cursor.moveToFirst()) {
                this.updateUserAttribute(userAttribute, contentValues);
            } else {
                this.addUserAttribute(contentValues);
            }
        }
    }

    private void addUserAttribute(ContentValues contentValues) {
        Uri newRecord = this.mContext.getContentResolver().insert(this.USER_ATTRIBUTES_URI, contentValues);
        if (null != newRecord) {
            Logger.v("New user attribute added with Uri: " + newRecord.toString());
        } else {
            Logger.v("Unable to user attribute");
        }
    }

    private void updateUserAttribute(@NonNull UserAttribute userAttribute, ContentValues contentValues) {
        int updateCount = this.mContext.getContentResolver().update(this.USER_ATTRIBUTES_URI, contentValues, "attribute_name=?", new String[]{userAttribute.userAttributeName});
        if (updateCount > 0) {
            Logger.v("New user attribute updated, count: " + updateCount);
        } else {
            Logger.v("Unable to user attribute");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    UserAttribute getUserAttributesForKey(@NonNull String attributeName) {
        if (TextUtils.isEmpty((CharSequence)attributeName)) {
            return null;
        }
        Cursor cursor = null;
        UserAttribute userAttribute = null;
        try {
            cursor = this.mContext.getContentResolver().query(this.USER_ATTRIBUTES_URI, MoEDataContract.UserAttributeEntity.PROJECTION, "attribute_name=?", new String[]{attributeName}, null);
            if (cursor != null && cursor.moveToFirst()) {
                userAttribute = new UserAttribute();
                userAttribute.userAttributeName = cursor.getString(1);
                userAttribute.userAttributeValue = cursor.getString(2);
            }
            this.closeCursor(cursor);
        }
        catch (Throwable throwable) {
            this.closeCursor(cursor);
            throw throwable;
        }
        return userAttribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    ArrayList<BatchData> getBatchedData(int batchSize) {
        Uri CONTENT_URI = this.BATCHED_DATA_URI.buildUpon().appendQueryParameter("LIMIT", String.valueOf(batchSize)).build();
        Cursor cursor = null;
        ArrayList<BatchData> batchList = null;
        try {
            cursor = this.mContext.getContentResolver().query(CONTENT_URI, MoEDataContract.BatchDataEntity.PROJECTION, null, null, null);
            if (cursor == null || cursor.getCount() == 0) {
                Logger.v("Empty cursor");
                this.closeCursor(cursor);
                ArrayList<BatchData> arrayList = null;
                this.closeCursor(cursor);
                return arrayList;
            }
            batchList = new ArrayList<BatchData>(cursor.getCount());
            if (cursor.moveToFirst()) {
                do {
                    long _id = cursor.getLong(cursor.getColumnIndex("_id"));
                    String data = cursor.getString(cursor.getColumnIndex("batch_data"));
                    batchList.add(new BatchData(_id, data));
                } while (cursor.moveToNext());
            }
            this.closeCursor(cursor);
        }
        catch (Exception e) {
            Logger.f("MoEDAO getBatchedData() :exception ", e);
        }
        finally {
            this.closeCursor(cursor);
        }
        return batchList;
    }

    void writeBatch(@NonNull String batch) {
        if (batch == null) {
            return;
        }
        ContentValues values = new ContentValues();
        values.put("batch_data", batch);
        Uri newBatch = this.mContext.getContentResolver().insert(this.BATCHED_DATA_URI, values);
        if (newBatch != null) {
            Logger.v("MoEDAO: writeBatch() New batch added : uri " + newBatch.toString());
        } else {
            Logger.f("MoEDAO: writeBatch() unable to add batch");
        }
    }

    void deleteBatch(BatchData batch) {
        ArrayList<ContentProviderOperation> operations = new ArrayList<ContentProviderOperation>();
        ContentProviderOperation operation = ContentProviderOperation.newDelete((Uri)this.BATCHED_DATA_URI).withSelection("_id = ?", new String[]{String.valueOf(batch._id)}).build();
        operations.add(operation);
        try {
            this.mContext.getContentResolver().applyBatch(this.AUTHORITY, operations);
        }
        catch (RemoteException e) {
            Logger.f("MoEDAO: deleteInteractionData", e);
        }
        catch (OperationApplicationException e) {
            Logger.f("MoEDAO: deleteInteractionData", e);
        }
        catch (Exception e) {
            Logger.f("MoEDAO: deleteInteractionData", e);
        }
    }

    @WorkerThread
    void deleteAllEvents() {
        this.mContext.getContentResolver().delete(MoEDataContract.DatapointEntity.getContentUri(this.mContext), null, null);
    }

    @WorkerThread
    void deleteAllBatches() {
        this.mContext.getContentResolver().delete(MoEDataContract.BatchDataEntity.getContentUri(this.mContext), null, null);
    }

    private void closeCursor(Cursor cursor) {
        if (cursor != null) {
            cursor.close();
        }
    }
}

