/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.core;

import android.content.Context;
import android.support.annotation.NonNull;
import com.moe.pushlibrary.models.Event;
import com.moe.pushlibrary.models.UserAttribute;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.core.Logger;
import com.moengage.core.MoEDAO;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.MoEUtils;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import org.json.JSONObject;

class SetDeviceAttributeTask
extends SDKTask {
    private JSONObject mDeviceAttribute;

    SetDeviceAttributeTask(@NonNull Context context, @NonNull JSONObject deviceAttribute) {
        super(context);
        this.mDeviceAttribute = deviceAttribute;
    }

    @Override
    public TaskResult execute() {
        Logger.v("SetDeviceAttributeTask: executing Task");
        UserAttribute currentUserAttribute = MoEUtils.getUserAttributePoJo(this.mDeviceAttribute);
        UserAttribute savedUserAttribute = null;
        if (currentUserAttribute != null) {
            savedUserAttribute = MoEUtils.getSavedUserAttribute(this.mContext, currentUserAttribute.userAttributeName);
        }
        if (MoEUtils.shouldSendUserAttribute(currentUserAttribute, savedUserAttribute)) {
            Logger.d("SetDeviceAttributeTask : setUserAttribute User attribute not yet sent to server will send : " + this.mDeviceAttribute.toString());
            Event event = new Event(MoEHelperUtils.getDatapointJSON("EVENT_ACTION_DEVICE_ATTRIBUTE", this.mDeviceAttribute));
            MoEDispatcher.getInstance(this.mContext).writeDataPointToStorage(event);
            MoEDAO.getInstance(this.mContext).addOrUpdateUserAttribute(currentUserAttribute);
            this.mTaskResult.setIsSuccess(true);
        } else {
            Logger.d("SetDeviceAttributeTask : setUserAttributes already sent once, need not send duplicate attribute : " + this.mDeviceAttribute.toString());
            this.mTaskResult.setIsSuccess(false);
        }
        Logger.v("SetDeviceAttributeTask: completed Task");
        return this.mTaskResult;
    }

    @Override
    public String getTaskTag() {
        return "SET_DEVICE_ATTRIBUTES";
    }

    @Override
    public boolean isSynchronous() {
        return false;
    }
}

