package com.moengage.mi;

import android.content.Context;
import android.support.annotation.Nullable;
import com.moengage.core.ConfigurationCache;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.MoEUtils;

/**
 * @author Umang Chamaria
 */
class MiPushRepository {

  private ConfigurationCache configurationCache;

  MiPushRepository() {
    configurationCache = ConfigurationCache.getInstance();
  }

  String getDeviceManufacturer() {
    return MoEUtils.deviceManufacturer();
  }

  @Nullable String getMiAppKey() {
    return configurationCache.getMiAppKey();
  }

  @Nullable String getMiAppId() {
    return configurationCache.getMiAppId();
  }

  boolean isMiPushEnabled() {
    return configurationCache.isMiPushEnabled();
  }

  @Nullable String getSavedToken(Context context) {
    return ConfigurationProvider.getInstance(context).getMiPushToken();
  }

  void savePushToken(Context context, String pushToken){
    ConfigurationProvider.getInstance(context).saveMiPushToken(pushToken);
  }

  /**
   * Returns the state of Push Opt-in.
   * @param context Application Context
   * @return true if push notification is opted out via GDPR else false.
   */
  boolean isPushNotificationOptedOut(Context context){
    return ConfigurationProvider.getInstance(context).isPushNotificationOptedOut();
  }

  boolean hasSentMiPushTokenToServer(Context context){
    return ConfigurationProvider.getInstance(context).hasSentMiPushTokenToServer();
  }
}
