/*
 * Decompiled with CFR 0.152.
 */
package com.moengage.addon.trigger;

import android.content.ContentProviderOperation;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.moe.pushlibrary.providers.MoEDataContract;
import com.moengage.addon.trigger.TriggerMessage;
import com.moengage.core.Logger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.json.JSONObject;

class DTDAO {
    private Context mContext;
    private Uri DT_CONTENT_URI;
    private static DTDAO _INSTANCE = null;
    private static final String TAG = "DTDAO";

    private DTDAO(Context context) {
        this.mContext = context;
        this.DT_CONTENT_URI = MoEDataContract.DTEntity.getContentUri((Context)this.mContext);
    }

    static DTDAO getInstance(Context context) {
        if (_INSTANCE == null) {
            _INSTANCE = new DTDAO(context);
        }
        return _INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @WorkerThread
    LinkedList<TriggerMessage> getCampaignsForEvent(String eventName) {
        Cursor cursor = null;
        LinkedList<TriggerMessage> triggerCampaign = new LinkedList<TriggerMessage>();
        try {
            Object triggerMessage;
            cursor = this.mContext.getContentResolver().query(this.DT_CONTENT_URI, MoEDataContract.DTEntity.PROJECTION, "event_name = ? AND status = ?", new String[]{eventName, "active"}, MoEDataContract.DTEntity.DEFAULT_SORT_ORDER);
            if (cursor != null && cursor.moveToFirst()) {
                do {
                    if ((triggerMessage = this.marshallTriggerMessage(cursor)) == null) continue;
                    triggerCampaign.add((TriggerMessage)triggerMessage);
                } while (cursor.moveToNext());
            }
            triggerMessage = triggerCampaign;
            this.closeCursor(cursor);
            return triggerMessage;
        }
        catch (Exception e) {
            Logger.f((String)"DTDAOgetCampaignsForEvent() : ", (Throwable)e);
        }
        finally {
            this.closeCursor(cursor);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @WorkerThread
    LinkedList<TriggerMessage> getStoredCampaigns() {
        Cursor cursor = null;
        try {
            cursor = this.mContext.getContentResolver().query(this.DT_CONTENT_URI, MoEDataContract.DTEntity.PROJECTION, null, null, null);
            if (cursor != null && cursor.moveToFirst()) {
                LinkedList<TriggerMessage> storedCampaignList = new LinkedList<TriggerMessage>();
                do {
                    TriggerMessage message;
                    if ((message = this.marshallTriggerMessage(cursor)) == null) continue;
                    storedCampaignList.add(message);
                } while (cursor.moveToNext());
                LinkedList<TriggerMessage> linkedList = storedCampaignList;
                this.closeCursor(cursor);
                return linkedList;
            }
            this.closeCursor(cursor);
        }
        catch (Exception e) {
            Logger.f((String)"DTDAOgetStoredCampaigns() : ", (Throwable)e);
        }
        finally {
            this.closeCursor(cursor);
        }
        return null;
    }

    @WorkerThread
    boolean updateCampaignState(TriggerMessage triggerMessage) {
        Uri updateRec = this.DT_CONTENT_URI.buildUpon().appendPath(String.valueOf(triggerMessage._id)).build();
        ContentValues values = new ContentValues();
        values.put("last_show_time", Long.valueOf(triggerMessage.state.lastShowTime));
        values.put("show_count", Long.valueOf(triggerMessage.state.showCount));
        int rowsUpdated = this.mContext.getContentResolver().update(updateRec, values, null, null);
        this.mContext.getContentResolver().notifyChange(updateRec, null);
        return rowsUpdated > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @WorkerThread
    HashSet<String> getTriggerEventsIfAny() {
        Cursor cursor = null;
        HashSet<String> triggerEvents = new HashSet<String>();
        try {
            cursor = this.mContext.getContentResolver().query(this.DT_CONTENT_URI, new String[]{"event_name"}, "status = ?", new String[]{"active"}, null);
            if (cursor != null && cursor.moveToFirst()) {
                do {
                    triggerEvents.add(cursor.getString(0));
                } while (cursor.moveToNext());
            }
            HashSet<String> hashSet = triggerEvents;
            this.closeCursor(cursor);
            return hashSet;
        }
        catch (Exception e) {
            Logger.f((String)"DTDAOgetTriggerEventsIfAny() : ", (Throwable)e);
        }
        finally {
            this.closeCursor(cursor);
        }
        return null;
    }

    @Nullable
    @WorkerThread
    void addOrUpdateTriggerCampaigns(@NonNull LinkedList<TriggerMessage> campaignList) {
        try {
            LinkedList<TriggerMessage> storedCampaigns = this.getStoredCampaigns();
            ArrayList<ContentProviderOperation> addOperations = new ArrayList<ContentProviderOperation>();
            ArrayList<ContentProviderOperation> updateOperations = new ArrayList<ContentProviderOperation>();
            if (storedCampaigns == null) {
                for (TriggerMessage campaign : campaignList) {
                    addOperations.add(ContentProviderOperation.newInsert((Uri)this.DT_CONTENT_URI).withValues(this.getContentValues(campaign)).build());
                }
            } else {
                for (TriggerMessage campaign : campaignList) {
                    boolean found = false;
                    for (TriggerMessage storedCampaign : storedCampaigns) {
                        if (!storedCampaign.campaignId.equals(campaign.campaignId)) continue;
                        campaign._id = storedCampaign._id;
                        campaign.state.showCount = storedCampaign.state.showCount;
                        campaign.state.lastShowTime = storedCampaign.state.lastShowTime;
                        found = true;
                        break;
                    }
                    if (found) {
                        updateOperations.add(ContentProviderOperation.newUpdate((Uri)this.DT_CONTENT_URI.buildUpon().appendPath(String.valueOf(campaign._id)).build()).withValues(this.getContentValues(campaign)).build());
                        continue;
                    }
                    addOperations.add(ContentProviderOperation.newInsert((Uri)this.DT_CONTENT_URI).withValues(this.getContentValues(campaign)).build());
                }
            }
            if (!updateOperations.isEmpty()) {
                this.mContext.getContentResolver().applyBatch(MoEDataContract.getAuthority((Context)this.mContext), updateOperations);
            }
            if (!addOperations.isEmpty()) {
                this.mContext.getContentResolver().applyBatch(MoEDataContract.getAuthority((Context)this.mContext), addOperations);
            }
        }
        catch (Exception e) {
            Logger.f((String)"DTDAOaddOrUpdateTriggerCampaigns() : ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @WorkerThread
    LinkedHashMap<String, TriggerMessage> getAllActiveCampaigns() {
        Cursor cursor = null;
        try {
            cursor = this.mContext.getContentResolver().query(this.DT_CONTENT_URI, MoEDataContract.DTEntity.PROJECTION, "status = ?", new String[]{"active"}, MoEDataContract.DTEntity.DEFAULT_SORT_ORDER);
            if (cursor != null && cursor.moveToFirst()) {
                LinkedHashMap<String, TriggerMessage> activeCampaigns = new LinkedHashMap<String, TriggerMessage>();
                do {
                    TriggerMessage triggerMessage;
                    if ((triggerMessage = this.marshallTriggerMessage(cursor)) == null) continue;
                    activeCampaigns.put(triggerMessage.campaignId, triggerMessage);
                } while (cursor.moveToNext());
                LinkedHashMap<String, TriggerMessage> linkedHashMap = activeCampaigns;
                this.closeCursor(cursor);
                return linkedHashMap;
            }
            this.closeCursor(cursor);
        }
        catch (Exception e) {
            Logger.f((String)"DTDAOgetAllActiveCampaigns() : ", (Throwable)e);
        }
        finally {
            this.closeCursor(cursor);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @WorkerThread
    LinkedList<String> getAllCampaignId() {
        block9: {
            LinkedList<String> linkedList;
            Cursor cursor = null;
            try {
                cursor = this.mContext.getContentResolver().query(this.DT_CONTENT_URI, new String[]{"campaign_id"}, null, null, null);
                if (cursor == null || cursor.getCount() == 0) {
                    if (cursor != null) {
                        this.closeCursor(cursor);
                    }
                    LinkedList<String> linkedList2 = null;
                    this.closeCursor(cursor);
                    return linkedList2;
                }
                LinkedList<String> campaignIdList = new LinkedList<String>();
                while (cursor.moveToNext()) {
                    String id = cursor.getString(0);
                    if (TextUtils.isEmpty((CharSequence)id)) continue;
                    campaignIdList.add(id);
                }
                linkedList = campaignIdList;
                this.closeCursor(cursor);
            }
            catch (Exception e) {
                Logger.f((String)"DTDAOgetAllCampaignId() : ", (Throwable)e);
                break block9;
            }
            finally {
                this.closeCursor(cursor);
            }
            return linkedList;
        }
        return null;
    }

    void removeExpiredCampaigns() {
        try {
            int rows = this.mContext.getContentResolver().delete(this.DT_CONTENT_URI, "expiry_time < ?", new String[]{Long.toString(System.currentTimeMillis())});
            int rows1 = this.mContext.getContentResolver().delete(this.DT_CONTENT_URI, "status = ?", new String[]{"expired"});
            Logger.v((String)("DTDAOremoveExpiredCampaigns(): Number of device triggers records deleted: " + (rows + rows1)));
        }
        catch (Exception e) {
            Logger.e((String)"DTDAOremoveExpiredCampaigns() : ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    TriggerMessage getCampaignById(String campaignId) {
        Cursor cursor = null;
        try {
            cursor = this.mContext.getContentResolver().query(this.DT_CONTENT_URI, MoEDataContract.DTEntity.PROJECTION, "campaign_id = ?", new String[]{campaignId}, null);
            if (cursor != null && cursor.moveToFirst()) {
                TriggerMessage triggerMessage = this.marshallTriggerMessage(cursor);
                this.closeCursor(cursor);
                return triggerMessage;
            }
            this.closeCursor(cursor);
        }
        catch (Exception e) {
            Logger.e((String)"DTDAO getCampaignById() : ", (Throwable)e);
        }
        finally {
            this.closeCursor(cursor);
        }
        return null;
    }

    @Nullable
    private ContentValues getContentValues(@NonNull TriggerMessage campaign) {
        if (campaign == null) {
            return null;
        }
        try {
            ContentValues values = new ContentValues();
            if (campaign._id != 0L) {
                values.put("_id", Long.valueOf(campaign._id));
            }
            values.put("campaign_id", campaign.campaignId);
            values.put("campaign_type", campaign.campaignType);
            values.put("event_name", campaign.triggerEventName);
            if (campaign.payload != null) {
                values.put("payload", campaign.payload.toString());
            }
            if (campaign.campaignPayload != null) {
                values.put("campaign_payload", campaign.campaignPayload.toString());
            }
            values.put("max_count", Long.valueOf(campaign.rules.maxCount));
            values.put("minimum_delay", Long.valueOf(campaign.rules.minimumDelay));
            values.put("should_show_offline", Integer.valueOf(campaign.rules.shouldShowOffline ? 1 : 0));
            values.put("max_sync_delay_time", Long.valueOf(campaign.rules.maxSyncDelay));
            values.put("expiry_time", Long.valueOf(campaign.rules.expiryTime));
            values.put("priority", Long.valueOf(campaign.rules.priority));
            values.put("should_ignore_dnd", Integer.valueOf(campaign.rules.shouldIgnoreDND ? 1 : 0));
            values.put("delay_before_showing", Long.valueOf(campaign.rules.showDelay));
            values.put("status", campaign.state.status);
            values.put("last_updated_time", Long.valueOf(campaign.state.lastUpdatedTime));
            values.put("show_count", Long.valueOf(campaign.state.showCount));
            values.put("last_show_time", Long.valueOf(campaign.state.lastShowTime));
            return values;
        }
        catch (Exception e) {
            Logger.f((String)"DTDAOgetContentValues() : ", (Throwable)e);
            return null;
        }
    }

    private void closeCursor(Cursor cursor) {
        if (cursor != null) {
            cursor.close();
        }
    }

    private TriggerMessage marshallTriggerMessage(Cursor cursor) {
        try {
            String campaignPayloadString;
            TriggerMessage triggerMessage = new TriggerMessage();
            triggerMessage._id = cursor.getLong(0);
            triggerMessage.campaignId = cursor.getString(1);
            triggerMessage.triggerEventName = cursor.getString(2);
            String pushPayload = cursor.getString(3);
            if (!TextUtils.isEmpty((CharSequence)pushPayload)) {
                triggerMessage.payload = new JSONObject(pushPayload);
            }
            if (!TextUtils.isEmpty((CharSequence)(campaignPayloadString = cursor.getString(4)))) {
                triggerMessage.campaignPayload = new JSONObject(campaignPayloadString);
            }
            triggerMessage.campaignType = cursor.getString(5);
            triggerMessage.rules.maxCount = cursor.getLong(6);
            triggerMessage.rules.minimumDelay = cursor.getLong(7);
            triggerMessage.rules.shouldShowOffline = cursor.getInt(8) == 1;
            triggerMessage.rules.maxSyncDelay = cursor.getLong(9);
            triggerMessage.rules.expiryTime = cursor.getLong(10);
            triggerMessage.rules.priority = cursor.getInt(11);
            triggerMessage.rules.shouldIgnoreDND = cursor.getInt(16) == 1;
            triggerMessage.rules.showDelay = cursor.getInt(17);
            triggerMessage.state.lastShowTime = cursor.getLong(12);
            triggerMessage.state.showCount = cursor.getLong(13);
            triggerMessage.state.lastUpdatedTime = cursor.getLong(14);
            triggerMessage.state.status = cursor.getString(15);
            triggerMessage.state.isActive = triggerMessage.state.status.equals("active");
            return triggerMessage;
        }
        catch (Exception e) {
            Logger.e((String)"DTDAOmarshallTriggerMessage() : ", (Throwable)e);
            return null;
        }
    }
}

