package com.moengage.addon.trigger;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.moengage.core.APIResponse;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import java.util.LinkedList;
import org.json.JSONArray;
import org.json.JSONObject;

/**
 * @author Umang Chamaria
 */

public class DTParser {

  private static final String TAG = "DTParser";


  /**
   * Parse and save the fetch trigger API response.
   *
   * @param response response from the network request
   */
  static void parseAndSaveSyncAPIResponse(APIResponse response, Context context) {
    Logger.v(TAG + "parseAndSaveSyncAPIResponse() : will try to parse API response app");
    if (DTParser.parseAndSaveCampaign(context, response)) DTController.getInstance(context)
        .updateDTCache();
  }

  /**
   * Parse user in segment API Response
   * @param response response from the API
   * @param message Campaign for which API was hit
   */
  static void parseUserInSegmentAPIResponse(APIResponse response, TriggerMessage message, Context
      context) {
    try {
      if (response == null){
        // null response or exception, try offline
        DTController.getInstance(context).showOrScheduleNotificationOffline(message);
        return;
      }
      if (response.responseCode == 200) {
        // response 200 but empty body, can't do a thing
        if (TextUtils.isEmpty(response.responseBody)) return;
        //success response from API, try showing online
        JSONObject responseObject = new JSONObject(response.responseBody);
        //user in segment, FC, DND, expiry check from backend
        if (!responseObject.getBoolean(DTConstants.RESPONSE_ATTR_USER_IN_SEGMENT) ||
            !responseObject.getBoolean(DTConstants.RESPONSE_ATTR_SHOW_NOTIFICATION)) return;
        message.payload = responseObject.getJSONObject(DTConstants.RESPONSE_ATTR_PAYLOAD);
        DTController.getInstance(context).showOrScheduleNotificationOnline(message);
      } else {
        // API did not return 200, try offline
        DTController.getInstance(context).showOrScheduleNotificationOffline(message);
      }
    } catch (Exception e) {
      Logger.f(TAG + "parseUserInSegmentAPIResponse() : ", e);
    }
  }

  @WorkerThread
  static boolean parseAndSaveCampaign(@NonNull Context context, APIResponse response) {
    try {
      if (response == null) return false;
      if (response.responseCode != 200) return false;
      if (TextUtils.isEmpty(response.responseBody)) return false;

      JSONObject responseJSON = new JSONObject(response.responseBody);
      // update last sync time
      if (responseJSON.has(DTConstants.RESPONSE_ATTR_USER_NOT_FOUND)){
        if (!responseJSON.getBoolean(DTConstants.RESPONSE_ATTR_USER_NOT_FOUND)){
          ConfigurationProvider.getInstance(context).saveLastDTSyncTime(System.currentTimeMillis());
        }
      }else {
        ConfigurationProvider.getInstance(context).saveLastDTSyncTime(System.currentTimeMillis());
      }
      //minimum delay between campaigns
      if (responseJSON.has(DTConstants.RESPONSE_ATTR_MINIMUM_DELAY_ACROSS_CAMPAIGNS)) {
        ConfigurationProvider.getInstance(context)
            .saveDTMinimumDelay(
                responseJSON.getLong(DTConstants.RESPONSE_ATTR_MINIMUM_DELAY_ACROSS_CAMPAIGNS));
      }
      //parse and save dnd settings
      if (responseJSON.has(DTConstants.RESPONSE_ATTR_DND_START_TIME)){
        ConfigurationProvider.getInstance(context).saveDTDNDStartTime(responseJSON.getLong
            (DTConstants.RESPONSE_ATTR_DND_START_TIME));
      }
      if (responseJSON.has(DTConstants.RESPONSE_ATTR_DND_END_TIME)){
        ConfigurationProvider.getInstance(context).saveDNDEndTime(responseJSON.getLong
            (DTConstants.RESPONSE_ATTR_DND_END_TIME));
      }
      //parse campaign
      if (responseJSON.has(DTConstants.RESPONSE_ATTR_CAMPAIGN_LIST)) {
        JSONArray campaignList = responseJSON.getJSONArray(DTConstants.RESPONSE_ATTR_CAMPAIGN_LIST);
        LinkedList<TriggerMessage> triggerCampaignList = new LinkedList<>();
        for (int i = 0; i < campaignList.length(); i++) {
          TriggerMessage message = parseDTCampaign(campaignList.getJSONObject(i));
          if (message != null) {
            message.dump();
            triggerCampaignList.add(message);
          }
        }
        DTDAO.getInstance(context).addOrUpdateTriggerCampaigns(triggerCampaignList);
      }
      return true;
    } catch (Exception e) {
      Logger.f(TAG + "parseAndSaveCampaign() : ", e);
    }
    return false;
  }

  @Nullable static TriggerMessage parseDTCampaign(JSONObject campaignObject) {
    try {
      TriggerMessage triggerMessage = new TriggerMessage();
      //mandatory keys
      triggerMessage.campaignId = campaignObject.getString(DTConstants.RESPONSE_ATTR_CAMPAIGN_ID);
      triggerMessage.state.status = campaignObject.getString(DTConstants.RESPONSE_ATTR_STATUS);
      // saving entire campaign payload
      triggerMessage.campaignPayload = campaignObject;

      if (campaignObject.has(DTConstants.RESPONSE_ATTR_CAMPAIGN_TYPE)) {
        triggerMessage.campaignType =
            campaignObject.getString(DTConstants.RESPONSE_ATTR_CAMPAIGN_TYPE);
      }
      if (campaignObject.has(DTConstants.RESPONSE_ATTR_PAYLOAD)) {
        triggerMessage.payload = campaignObject.getJSONObject(DTConstants.RESPONSE_ATTR_PAYLOAD);
      }
      if (campaignObject.has(DTConstants.RESPONSE_ATTR_EVENT_NAME)) {
        triggerMessage.triggerEventName =
            campaignObject.getString(DTConstants.RESPONSE_ATTR_EVENT_NAME);
      }
      if (campaignObject.has(DTConstants.RESPONSE_ATTR_MAX_TIMES)) {
        triggerMessage.rules.maxCount = campaignObject.getLong(DTConstants.RESPONSE_ATTR_MAX_TIMES);
      }
      if (campaignObject.has(DTConstants.RESPONSE_ATTR_SHOW_CAMPAIGN_AFTER)) {
        triggerMessage.rules.showDelay =
            campaignObject.getLong(DTConstants.RESPONSE_ATTR_SHOW_CAMPAIGN_AFTER);
      }
      if (campaignObject.has(DTConstants.RESPONSE_ATTR_MINIMUM_DELAY_BETWEEN)) {
        triggerMessage.rules.minimumDelay =
            campaignObject.getLong(DTConstants.RESPONSE_ATTR_MINIMUM_DELAY_BETWEEN);
      }
      if (campaignObject.has(DTConstants.RESPONSE_ATTR_SHOULD_SUPPORT_OFFLINE)) {
        triggerMessage.rules.shouldShowOffline =
            campaignObject.getBoolean(DTConstants.RESPONSE_ATTR_SHOULD_SUPPORT_OFFLINE);
      }
      if (campaignObject.has(DTConstants.RESPONSE_ATTR_MAXIMUM_SYNC_DELAY)) {
        triggerMessage.rules.maxSyncDelay =
            campaignObject.getLong(DTConstants.RESPONSE_ATTR_MAXIMUM_SYNC_DELAY);
      }
      if (campaignObject.has(DTConstants.RESPONSE_ATTR_EXPIRY)) {
        triggerMessage.rules.expiryTime = campaignObject.getLong(DTConstants.RESPONSE_ATTR_EXPIRY);
      }
      if (campaignObject.has(DTConstants.RESPONSE_ATTR_PRIORITY)) {
        triggerMessage.rules.priority = campaignObject.getInt(DTConstants.RESPONSE_ATTR_PRIORITY);
      }
      if (campaignObject.has(DTConstants.RESPONSE_ATTR_SHOULD_IGNORE_DND)) {
        triggerMessage.rules.shouldIgnoreDND =
            campaignObject.getBoolean(DTConstants.RESPONSE_ATTR_SHOULD_IGNORE_DND);
      }
      if (campaignObject.has(DTConstants.RESPONSE_ATTR_LAST_UPDATED_TIME)){
        triggerMessage.state.lastUpdatedTime = campaignObject.getLong(DTConstants
            .RESPONSE_ATTR_LAST_UPDATED_TIME);
      }
      return triggerMessage;
    } catch (Exception e) {
      Logger.f(TAG + "parseDTCampaign() :", e);
    }
    return null;
  }
}
