package com.moengage.addon.trigger;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobInfo.Builder;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Build.VERSION_CODES;
import android.support.annotation.NonNull;
import com.moengage.core.ConfigurationProvider;
import com.moengage.core.Logger;
import com.moengage.core.MoEDTManager.DTHandler;
import com.moengage.core.MoEDispatcher;
import org.json.JSONObject;

/**
 * @author Umang Chamaria
 */

public class DTHandlerImpl implements DTHandler {

  private static final String TAG = "DTHandlerImpl";

  private static DTHandlerImpl _INSTANCE = null;

  public DTHandlerImpl(){
    _INSTANCE = this;
  }

  public static DTHandlerImpl getInstance(){
    if (_INSTANCE == null){
      _INSTANCE = new DTHandlerImpl();
    }
    return _INSTANCE;
  }

  @Override public void syncTriggersIfRequired(@NonNull Context context) {
    try {
      Logger.v(TAG + "syncTriggersIfRequired() : will sync if required");
      long lastSyncTime = ConfigurationProvider.getInstance(context).getDTLastSyncTime();
      long minimumSyncDelay = ConfigurationProvider.getInstance(context).getDTMinimumSyncDelay();
      if (lastSyncTime + minimumSyncDelay < System.currentTimeMillis()){
        forceSyncDeviceTriggers(context);
        scheduleBackgroundSync(context);
      }else {
        Logger.v(TAG + " syncTriggersIfRequired() : DT trigger sync not required");
      }
    } catch (Exception e) {
      Logger.f( TAG + " syncTriggersIfRequired() : ", e);
    }
  }

  @Override
  public void showTriggerCampaignIfPossible(@NonNull Context context, @NonNull String eventName,
      @NonNull JSONObject eventAttributes) {
    try {
      Logger.v(TAG + " showTriggerCampaignIfPossible() : trying to show trigger campaign");
      MoEDispatcher.getInstance(context).addTaskToQueueBeginning(new CheckAndShowDTCampaignTask
          (context, eventName, eventAttributes));
    } catch (Exception e) {
      Logger.f( TAG + " showTriggerCampaignIfPossible() : ", e);
    }
  }

  @Override public void forceSyncDeviceTriggers(@NonNull Context context) {
    try {
      Logger.v(TAG + " forceSyncDeviceTriggers() : force sync device trigger");
      MoEDispatcher.getInstance(context).addTaskToQueue(new DTNetworkTask(context,
          DTController.NETWORK_CALL_TYPE.SYNC_API));
    } catch (Exception e) {
      Logger.f( TAG + " forceSyncDeviceTriggers() : ", e);
    }
  }

  @Override public void scheduleBackgroundSync(Context context) {
    Logger.v(TAG + " scheduleBackgroundSync() : scheduling background fetch");
    try {
      long minimumDelayDuration =
          ConfigurationProvider.getInstance(context).getMessageFetchDelayDuration();
      Intent alarmIntent = new Intent(context, DTSyncAlarmReceiver.class);
      alarmIntent.setAction(DTConstants.ACTION_SYNC_MESSAGES);
      PendingIntent pendingIntent =
          PendingIntent.getBroadcast(context, DTConstants.REQ_CODE_FETCH_TRIGGERS,
              alarmIntent, PendingIntent.FLAG_UPDATE_CURRENT);
      AlarmManager alarmManager = (AlarmManager) context.getSystemService(Context.ALARM_SERVICE);
      if (Build.VERSION.SDK_INT >= VERSION_CODES.LOLLIPOP) {
        scheduleFetchJob(context, minimumDelayDuration);
      }else{
        alarmManager.set(AlarmManager.RTC_WAKEUP, System.currentTimeMillis() + minimumDelayDuration,
            pendingIntent);
      }
    } catch (Exception e) {
      Logger.f( TAG + "scheduleBackgroundSync() : ", e);
    }
  }

  @TargetApi(VERSION_CODES.LOLLIPOP)
  private void scheduleFetchJob(Context context, long minimumDelayDuration) {
    ComponentName serviceComponent = new ComponentName(context, DTSyncJob.class);
    Builder builder = new Builder(DTConstants.MESSAGE_SYNC_JOB_ID, serviceComponent);
    builder.setOverrideDeadline(System.currentTimeMillis() + minimumDelayDuration + (3600 *1000));
    builder.setMinimumLatency(minimumDelayDuration);
    builder.setRequiredNetworkType(JobInfo.NETWORK_TYPE_ANY);
    /*if (MoEHelperUtils.hasPermission(context, permission.RECEIVE_BOOT_COMPLETED)){
      builder.setPersisted(true);
    }*/
    JobScheduler jobScheduler =
        (JobScheduler) context.getSystemService(Context.JOB_SCHEDULER_SERVICE);
    if (jobScheduler != null) {
      jobScheduler.schedule(builder.build());
    }
  }
}
