package com.moengage.addon.trigger;

import android.content.Context;
import com.moe.pushlibrary.models.Event;
import com.moe.pushlibrary.utils.MoEHelperUtils;
import com.moengage.addon.trigger.DTController.NETWORK_CALL_TYPE;
import com.moengage.core.Logger;
import com.moengage.core.MoEDispatcher;
import com.moengage.core.executor.SDKTask;
import com.moengage.core.executor.TaskResult;
import org.json.JSONObject;

/**
 * @author Umang Chamaria
 */

public class CheckAndShowDTCampaignTask extends SDKTask {

  private static final String TAG = "CheckAndShowDTCampaignTask";

  private String mEventName;
  private JSONObject mEventAttributes;

  public CheckAndShowDTCampaignTask(Context context, String eventName, JSONObject eventAttributes) {
    super(context);
    mEventName = eventName;
    mEventAttributes = eventAttributes;
  }

  @Override public TaskResult execute() {
    Logger.v(TAG + "executing :");
    try {
      DTConditionEvaluator conditionEvaluator = new DTConditionEvaluator();
      DTController dtController = DTController.getInstance(mContext);
      if (!conditionEvaluator.shouldShowTrigger(dtController.getLastShowTime(),
          dtController.getGlobalMinimumDelay(), System.currentTimeMillis())) {
        Logger.v(TAG + "execute() : device trigger was shown recently cannot show now.");
        return null;
      }
      if (conditionEvaluator.isDTEvent(dtController.getTriggerEvents(), mEventName)){
        Logger.v(TAG + "execute() : " + mEventName + " is a device trigger");
        TriggerMessage campaign = DTController.getInstance(mContext).getCampaignToShown(mEventName,
            mEventAttributes);
        if (campaign != null){
          Logger.v(TAG + "execute() : Will try to show campaign, id: " + campaign.campaignId);
          campaign.dump();
          MoEDispatcher.getInstance(mContext).addTaskToQueueBeginning(new DTNetworkTask(mContext,
           NETWORK_CALL_TYPE.USER_IN_SEGMENT, new Event(
              MoEHelperUtils.getDatapointJSON(mEventName.trim(), mEventAttributes)), campaign));
        }else {
          Logger.e( TAG + "execute() : Did not find any suitable device trigger campaign to show");
        }
      }else {
        Logger.v(TAG + " execute() : Tracked event is not a device trigger, event: " + mEventName);
      }
    }catch (Exception e){
      Logger.f( TAG + "execute() : ", e);
    }
    Logger.v(TAG + "completed execution : ");
    return null;

  }

  @Override public String getTaskTag() {
    return TAG_CHECK_AND_SHOW_DT;
  }

  @Override public boolean isSynchronous() {
    return false;
  }
}
