/*
 * Decompiled with CFR 0.152.
 */
package com.modrinth.minotaur.responses;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.modrinth.minotaur.dependencies.Dependency;
import com.modrinth.minotaur.request.VersionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import masecla.modrinth4j.model.version.ProjectVersion;
import org.jetbrains.annotations.ApiStatus;

@Deprecated
public class ResponseUpload {
    @Expose
    @SerializedName(value="id")
    private String id;
    @Expose
    @SerializedName(value="project_id")
    private String projectId;
    @Expose
    @SerializedName(value="author_id")
    private String authorId;
    @Expose
    @SerializedName(value="featured")
    private boolean featured;
    @Expose
    @SerializedName(value="name")
    private String name;
    @Expose
    @SerializedName(value="version_number")
    private String versionNumber;
    @Expose
    @SerializedName(value="changelog")
    private String changelog;
    @Expose
    @SerializedName(value="date_published")
    private Date datePublished;
    @Expose
    @SerializedName(value="downloads")
    private int downloads;
    @Expose
    @SerializedName(value="version_type")
    private VersionType versionType;
    @Expose
    @SerializedName(value="files")
    private Collection<VersionFile> files = new ArrayList<VersionFile>();
    @Expose
    @SerializedName(value="game_versions")
    private Collection<String> gameVersions = new ArrayList<String>();
    @Expose
    @SerializedName(value="loaders")
    private Collection<String> loaders = new ArrayList<String>();
    @Expose
    @SerializedName(value="dependencies")
    private Collection<Dependency> dependencies = new ArrayList<Dependency>();

    public String getId() {
        return this.id;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getAuthorId() {
        return this.authorId;
    }

    public boolean isFeatured() {
        return this.featured;
    }

    public String getName() {
        return this.name;
    }

    public String getVersionNumber() {
        return this.versionNumber;
    }

    public String getChangelog() {
        return this.changelog;
    }

    public Date getDatePublished() {
        return this.datePublished;
    }

    public int getDownloads() {
        return this.downloads;
    }

    public VersionType getVersionType() {
        return this.versionType;
    }

    public Collection<VersionFile> getFiles() {
        return this.files;
    }

    public Collection<String> getGameVersions() {
        return this.gameVersions;
    }

    public Collection<String> getLoaders() {
        return this.loaders;
    }

    public Collection<Dependency> getDependencies() {
        return this.dependencies;
    }

    @ApiStatus.Internal
    public ResponseUpload(ProjectVersion newVersion) {
        this.name = newVersion.getName();
        this.versionNumber = newVersion.getVersionNumber();
        this.changelog = newVersion.getChangelog();
        this.dependencies = newVersion.getDependencies().stream().map(Dependency::fromNew).collect(Collectors.toList());
        this.gameVersions = newVersion.getGameVersions();
        this.versionType = VersionType.valueOf(newVersion.getVersionType().name());
        this.loaders = newVersion.getLoaders();
        this.featured = newVersion.isFeatured();
        this.id = newVersion.getId();
        this.projectId = newVersion.getProjectId();
        this.authorId = newVersion.getAuthorId();
        this.datePublished = Date.from(newVersion.getDatePublished());
        this.downloads = newVersion.getDownloads();
        this.files = newVersion.getFiles().stream().map(VersionFile::fromNew).collect(Collectors.toList());
    }

    public static class VersionFile {
        @Expose
        @SerializedName(value="hashes")
        private Map<String, String> hashes;
        @Expose
        @SerializedName(value="url")
        private String url;
        @Expose
        @SerializedName(value="filename")
        private String filename;
        @Expose
        @SerializedName(value="primary")
        private boolean primary;

        public Map<String, String> getHashes() {
            return this.hashes;
        }

        public String getUrl() {
            return this.url;
        }

        public String getFilename() {
            return this.filename;
        }

        public boolean isPrimary() {
            return this.primary;
        }

        public static VersionFile fromNew(ProjectVersion.ProjectFile newFile) {
            VersionFile file = new VersionFile();
            file.hashes = new HashMap<String, String>();
            file.hashes.put("sha1", newFile.getHashes().getSha1());
            file.hashes.put("sha512", newFile.getHashes().getSha512());
            file.url = newFile.getUrl();
            file.filename = newFile.getFilename();
            file.primary = newFile.isPrimary();
            return file;
        }
    }
}

