/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jdbc;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.jdbc.AbstractResultSetHandler;
import com.mockrunner.jdbc.SQLUtil;
import com.mockrunner.mock.jdbc.MockResultSet;
import com.mockrunner.util.common.ArrayUtil;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class MockStatement
implements Statement {
    private AbstractResultSetHandler resultSetHandler;
    private ResultSet[] currentResultSets = null;
    private Integer[] currentUpdateCounts = null;
    private int currentResultSetIndex = 0;
    private int currentUpdateCountIndex = 0;
    private List<String> batches = new ArrayList<String>();
    private String cursorName = "";
    private int querySeconds = 0;
    private int maxRows = 0;
    private int maxFieldSize = 0;
    private int fetchDirection = 1000;
    private int fetchSize = 0;
    private int resultSetType = 1003;
    private int resultSetConcurrency = 1007;
    private int resultSetHoldability = 1;
    private MockResultSet lastGeneratedKeys = null;
    private boolean closed = false;
    private boolean poolable = false;
    private boolean closeOnCompletition = false;
    private Connection connection;

    public MockStatement(Connection connection) {
        this.connection = connection;
        this.resultSetType = 1003;
        this.resultSetConcurrency = 1007;
        try {
            this.resultSetHoldability = connection.getMetaData().getResultSetHoldability();
        }
        catch (SQLException exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
    }

    public MockStatement(Connection connection, int resultSetType, int resultSetConcurrency) {
        this.connection = connection;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        try {
            this.resultSetHoldability = connection.getMetaData().getResultSetHoldability();
        }
        catch (SQLException exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
    }

    public MockStatement(Connection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        this.connection = connection;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public void setResultSetHandler(AbstractResultSetHandler resultSetHandler) {
        this.resultSetHandler = resultSetHandler;
    }

    protected void setResultSets(ResultSet[] resultSets) {
        this.closeCurrentResultSets();
        this.currentUpdateCounts = null;
        this.currentResultSets = resultSets;
        this.currentResultSetIndex = 0;
        this.currentUpdateCountIndex = 0;
    }

    protected void setUpdateCounts(Integer[] updateCounts) {
        this.closeCurrentResultSets();
        this.currentResultSets = null;
        this.currentUpdateCounts = updateCounts;
        this.currentResultSetIndex = 0;
        this.currentUpdateCountIndex = 0;
    }

    public String getCursorName() {
        return this.cursorName;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        SQLException exception = this.resultSetHandler.getSQLException(sql);
        if (null != exception) {
            throw exception;
        }
        this.resultSetHandler.addExecutedStatement(sql);
        MockResultSet[] results = this.resultSetHandler.getResultSets(sql);
        if (results != null && results.length != 0) {
            if (results.length > 1) {
                return this.cloneAndSetMultipleResultSets(results);
            }
            return this.cloneAndSetSingleResultSet(results[0]);
        }
        if (this.resultSetHandler.hasMultipleGlobalResultSets()) {
            return this.cloneAndSetMultipleResultSets(this.resultSetHandler.getGlobalResultSets());
        }
        MockResultSet result = this.resultSetHandler.getGlobalResultSet();
        if (null != result) {
            return this.cloneAndSetSingleResultSet(result);
        }
        return new MockResultSet(String.valueOf(Math.random()));
    }

    private MockResultSet cloneAndSetSingleResultSet(MockResultSet result) {
        if (null != (result = this.cloneResultSet(result))) {
            this.resultSetHandler.addReturnedResultSet(result);
        }
        this.setResultSets(new MockResultSet[]{result});
        this.setLastGeneratedKeysResultSet(null);
        return result;
    }

    private MockResultSet cloneAndSetMultipleResultSets(MockResultSet[] results) {
        if (null != (results = this.cloneResultSets(results))) {
            this.resultSetHandler.addReturnedResultSets(results);
        }
        this.setResultSets(results);
        this.setLastGeneratedKeysResultSet(null);
        if (null != results && results.length > 0) {
            return results[0];
        }
        return null;
    }

    private void closeCurrentResultSets() {
        if (null != this.currentResultSets) {
            for (ResultSet currentResultSet : this.currentResultSets) {
                try {
                    if (null == currentResultSet) continue;
                    currentResultSet.close();
                }
                catch (SQLException exc) {
                    throw new NestedApplicationException((Throwable)exc);
                }
            }
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        SQLException exception = this.resultSetHandler.getSQLException(sql);
        if (null != exception) {
            throw exception;
        }
        this.resultSetHandler.addExecutedStatement(sql);
        Integer[] returnValues = this.resultSetHandler.getUpdateCounts(sql);
        if (returnValues != null && returnValues.length != 0) {
            if (returnValues.length > 1) {
                return this.setMultipleUpdateCounts(returnValues);
            }
            return this.setSingleUpdateCount(returnValues[0]);
        }
        if (this.resultSetHandler.hasMultipleGlobalUpdateCounts()) {
            return this.setMultipleUpdateCounts(this.resultSetHandler.getGlobalUpdateCounts());
        }
        return this.setSingleUpdateCount(this.resultSetHandler.getGlobalUpdateCount());
    }

    private int setSingleUpdateCount(int updateCount) {
        this.setUpdateCounts(new Integer[]{updateCount});
        this.setLastGeneratedKeysResultSet(null);
        return updateCount;
    }

    private int setMultipleUpdateCounts(Integer[] updateCounts) {
        this.setUpdateCounts(updateCounts);
        this.setLastGeneratedKeysResultSet(null);
        if (null != updateCounts && updateCounts.length > 0) {
            return updateCounts[0];
        }
        return 0;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        boolean callExecuteQuery = this.isQuery(sql);
        if (callExecuteQuery) {
            this.executeQuery(sql);
        } else {
            this.executeUpdate(sql);
        }
        return callExecuteQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        try {
            int[] results = new int[this.batches.size()];
            Throwable exception = null;
            for (int ii = 0; ii < results.length; ++ii) {
                String nextSQL = this.batches.get(ii);
                if (this.isQuery(nextSQL)) {
                    exception = this.prepareFailedResult(results, ii, "SQL " + this.batches.get(ii) + " in the list of batches returned a ResultSet.", null);
                } else {
                    try {
                        results[ii] = this.executeUpdate(nextSQL);
                    }
                    catch (SQLException exc) {
                        exception = this.prepareFailedResult(results, ii, null, exc);
                    }
                }
                if (null == exception || this.resultSetHandler.getContinueProcessingOnBatchFailure()) continue;
                throw exception;
            }
            if (null != exception) {
                throw new BatchUpdateException(exception.getMessage(), ((SQLException)exception).getSQLState(), ((SQLException)exception).getErrorCode(), results);
            }
            int[] nArray = results;
            return nArray;
        }
        finally {
            this.clearBatch();
        }
    }

    protected SQLException prepareFailedResult(int[] actualResults, int index, String message, SQLException caughtException) {
        actualResults[index] = -3;
        if (caughtException instanceof BatchUpdateException) {
            return caughtException;
        }
        int[] partialResults = (int[])ArrayUtil.truncateArray((Object)actualResults, (int)index);
        if (null == caughtException) {
            return new BatchUpdateException(message, partialResults);
        }
        return new BatchUpdateException(caughtException.getMessage(), caughtException.getSQLState(), caughtException.getErrorCode(), partialResults);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        int updateCount = this.executeUpdate(sql);
        this.setGeneratedKeysResultSet(sql, autoGeneratedKeys);
        return updateCount;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.executeUpdate(sql, 1);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.executeUpdate(sql, 1);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        boolean isQuery = this.execute(sql);
        this.setGeneratedKeysResultSet(sql, autoGeneratedKeys);
        return isQuery;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.execute(sql, 1);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.execute(sql, 1);
    }

    private void setGeneratedKeysResultSet(String sql, int autoGeneratedKeys) throws SQLException {
        if (1 != autoGeneratedKeys && 2 != autoGeneratedKeys) {
            throw new SQLException("autoGeneratedKeys must be either Statement.RETURN_GENERATED_KEYS or Statement.NO_GENERATED_KEYS");
        }
        if (1 == autoGeneratedKeys) {
            this.setLastGeneratedKeysResultSet(this.determineGeneratedKeysResultSet(sql));
        } else {
            this.setLastGeneratedKeysResultSet(null);
        }
    }

    protected void setLastGeneratedKeysResultSet(MockResultSet generatedKeys) {
        this.lastGeneratedKeys = generatedKeys;
    }

    protected MockResultSet determineGeneratedKeysResultSet(String sql) {
        MockResultSet generatedKeys = this.resultSetHandler.getGeneratedKeys(sql);
        if (null != generatedKeys) {
            return generatedKeys;
        }
        return this.resultSetHandler.getGlobalGeneratedKeys();
    }

    @Override
    public void close() throws SQLException {
        this.closed = true;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int maxFieldSize) throws SQLException {
        this.maxFieldSize = maxFieldSize;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int maxRows) throws SQLException {
        this.maxRows = maxRows;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.querySeconds;
    }

    @Override
    public void setQueryTimeout(int querySeconds) throws SQLException {
        this.querySeconds = querySeconds;
    }

    @Override
    public void cancel() throws SQLException {
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void setCursorName(String cursorName) throws SQLException {
        this.cursorName = cursorName;
    }

    protected boolean isQuery(String sql) {
        Boolean returnsResultSet = this.resultSetHandler.getReturnsResultSet(sql);
        boolean isQuery = null != returnsResultSet ? returnsResultSet : SQLUtil.isSelect(sql);
        return isQuery;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (null == this.currentResultSets) {
            return null;
        }
        if (this.currentResultSetIndex >= this.currentResultSets.length) {
            return null;
        }
        return this.currentResultSets[this.currentResultSetIndex];
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (null == this.currentUpdateCounts) {
            return -1;
        }
        if (this.currentUpdateCountIndex >= this.currentUpdateCounts.length) {
            return -1;
        }
        return this.currentUpdateCounts[this.currentUpdateCountIndex];
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.getMoreResults(current != 2);
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(true);
    }

    private boolean getMoreResults(boolean doCloseCurrentResult) throws SQLException {
        if (null != this.currentResultSets) {
            if (this.currentResultSetIndex < this.currentResultSets.length) {
                if (null != this.currentResultSets[this.currentResultSetIndex] && doCloseCurrentResult) {
                    this.currentResultSets[this.currentResultSetIndex].close();
                }
                ++this.currentResultSetIndex;
            }
            return this.currentResultSetIndex < this.currentResultSets.length;
        }
        if (null != this.currentUpdateCounts && this.currentUpdateCountIndex < this.currentUpdateCounts.length) {
            ++this.currentUpdateCountIndex;
        }
        return false;
    }

    @Override
    public void setFetchDirection(int fetchDirection) throws SQLException {
        this.fetchDirection = fetchDirection;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        this.fetchSize = fetchSize;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.batches.add(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.batches.clear();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        if (null == this.lastGeneratedKeys) {
            MockResultSet resultSet = new MockResultSet("Last statement did not generate any keys");
            resultSet.setStatement(this);
            return resultSet;
        }
        return this.cloneResultSet(this.lastGeneratedKeys);
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.resultSetType;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.resultSetHoldability;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.poolable;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.poolable = poolable;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("No object found for " + iface);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.closeOnCompletition = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.closeOnCompletition;
    }

    protected MockResultSet cloneResultSet(MockResultSet resultSet) {
        if (this.resultSetConcurrency == 1007) {
            return resultSet.shallowCopy();
        }
        if (null == resultSet) {
            return null;
        }
        MockResultSet clone = (MockResultSet)resultSet.clone();
        clone.setStatement(this);
        return clone;
    }

    protected MockResultSet[] cloneResultSets(MockResultSet[] resultSets) {
        if (null == resultSets) {
            return null;
        }
        MockResultSet[] clonedResultsSets = new MockResultSet[resultSets.length];
        for (int ii = 0; ii < resultSets.length; ++ii) {
            if (null == resultSets[ii]) continue;
            if (this.resultSetConcurrency == 1007) {
                clonedResultsSets[ii] = resultSets[ii].shallowCopy();
                continue;
            }
            clonedResultsSets[ii] = (MockResultSet)resultSets[ii].clone();
            clonedResultsSets[ii].setStatement(this);
        }
        return clonedResultsSets;
    }
}

