/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jdbc;

import com.mockrunner.base.NestedApplicationException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class MockClob
implements Clob,
Cloneable {
    private StringBuffer clobData;
    private boolean wasFreeCalled;

    public MockClob(String data) {
        this.clobData = new StringBuffer(data);
        this.wasFreeCalled = false;
    }

    @Override
    public long length() throws SQLException {
        return this.clobData.length();
    }

    @Override
    public void truncate(long len) throws SQLException {
        if (this.wasFreeCalled) {
            throw new SQLException("free() was called");
        }
        this.clobData.setLength((int)len);
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        if (this.wasFreeCalled) {
            throw new SQLException("free() was called");
        }
        try {
            return new ByteArrayInputStream(this.clobData.toString().getBytes("ISO-8859-1"));
        }
        catch (UnsupportedEncodingException exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        if (this.wasFreeCalled) {
            throw new SQLException("free() was called");
        }
        return new ClobOutputStream((int)(pos - 1L));
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        if (this.wasFreeCalled) {
            throw new SQLException("free() was called");
        }
        return new StringReader(this.clobData.toString());
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        if (this.wasFreeCalled) {
            throw new SQLException("free() was called");
        }
        length = this.verifyAndFixLength(pos, (int)length);
        return new StringReader(this.getSubString(pos, (int)length));
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        if (this.wasFreeCalled) {
            throw new SQLException("free() was called");
        }
        return new ClobWriter((int)(pos - 1L));
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        if (this.wasFreeCalled) {
            throw new SQLException("free() was called");
        }
        length = this.verifyAndFixLength(pos, length);
        return this.clobData.substring((int)(pos - 1L), (int)(pos - 1L) + length);
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        return this.setString(pos, str, 0, str.length());
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        if (this.wasFreeCalled) {
            throw new SQLException("free() was called");
        }
        str = str.substring(offset, offset + len);
        this.clobData.replace((int)(pos - 1L), (int)(pos - 1L) + str.length(), str);
        return len;
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        if (this.wasFreeCalled) {
            throw new SQLException("free() was called");
        }
        int index = this.clobData.toString().indexOf(searchstr, (int)(start - 1L));
        if (-1 != index) {
            ++index;
        }
        return index;
    }

    @Override
    public long position(Clob searchClob, long start) throws SQLException {
        return this.position(searchClob.getSubString(1L, (int)searchClob.length()), start);
    }

    @Override
    public void free() throws SQLException {
        this.wasFreeCalled = true;
    }

    public boolean wasFreeCalled() {
        return this.wasFreeCalled;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        MockClob other = (MockClob)obj;
        if (this.wasFreeCalled != other.wasFreeCalled()) {
            return false;
        }
        return this.clobData.toString().equals(other.clobData.toString());
    }

    public int hashCode() {
        int hashCode = this.clobData.toString().hashCode();
        hashCode = 31 * hashCode + (this.wasFreeCalled ? 31 : 62);
        return hashCode;
    }

    public String toString() {
        return "Clob data: " + this.clobData.toString();
    }

    public Object clone() {
        try {
            MockClob clone = (MockClob)super.clone();
            clone.clobData = new StringBuffer(this.clobData.toString());
            return clone;
        }
        catch (CloneNotSupportedException exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
    }

    private int verifyAndFixLength(long pos, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length must be greater or equals 0");
        }
        if ((long)length + (pos - 1L) > (long)this.clobData.length()) {
            return this.clobData.length() - (int)(pos - 1L);
        }
        return length;
    }

    private class ClobOutputStream
    extends OutputStream {
        private int index;

        public ClobOutputStream(int index) {
            this.index = index;
        }

        @Override
        public void write(int byteValue) throws IOException {
            byte[] bytes = new byte[]{(byte)byteValue};
            try {
                MockClob.this.setString(this.index + 1, new String(bytes));
            }
            catch (SQLException exc) {
                throw new IOException(exc.getMessage());
            }
            ++this.index;
        }
    }

    private class ClobWriter
    extends Writer {
        private int index;

        public ClobWriter(int index) {
            this.index = index;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            try {
                MockClob.this.setString(this.index + 1, new String(cbuf, off, len));
            }
            catch (SQLException exc) {
                throw new IOException(exc.getMessage());
            }
            ++this.index;
        }
    }
}

