/*
 * Decompiled with CFR 0.152.
 */
package com.mobsandgeeks.saripaar.rule;

import com.mobsandgeeks.saripaar.AnnotationRule;
import com.mobsandgeeks.saripaar.annotation.Length;

public class LengthRule
extends AnnotationRule<Length, String> {
    protected LengthRule(Length length) {
        super(length);
    }

    @Override
    public boolean isValid(String text) {
        if (text == null) {
            throw new IllegalArgumentException("'text' cannot be null.");
        }
        int ruleMin = ((Length)this.mRuleAnnotation).min();
        int ruleMax = ((Length)this.mRuleAnnotation).max();
        this.assertMinMax(ruleMin, ruleMax);
        int length = ((Length)this.mRuleAnnotation).trim() ? text.trim().length() : text.length();
        boolean minIsValid = true;
        if (ruleMin != Integer.MIN_VALUE) {
            minIsValid = length >= ruleMin;
        }
        boolean maxIsValid = true;
        if (ruleMax != Integer.MAX_VALUE) {
            maxIsValid = length <= ruleMax;
        }
        return minIsValid && maxIsValid;
    }

    private void assertMinMax(int min, int max) {
        if (min > max) {
            String message = String.format("'min' (%d) should be less than or equal to 'max' (%d).", min, max);
            throw new IllegalStateException(message);
        }
    }
}

