/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.adapter.MaxAdViewAdapter;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.sdk.AppLovinSdk;
import com.mobilefuse.sdk.AdError;
import com.mobilefuse.sdk.MobileFuse;
import com.mobilefuse.sdk.MobileFuseBannerAd;
import com.mobilefuse.sdk.MobileFuseInterstitialAd;
import com.mobilefuse.sdk.SdkInitListener;
import java.util.concurrent.atomic.AtomicBoolean;

public class MobileFuseMediationAdapter
extends MediationAdapterBase
implements MaxAdViewAdapter,
MaxInterstitialAdapter {
    private static final String PARAM_NAME_APP_KEY = "app_id";
    private static final String PARAM_NAME_CUSTOM_PARAMS_JSON = "custom_parameters";
    private static final String PARAM_NAME_BG_COLOR = "background_color";
    private Handler handler = new Handler(Looper.getMainLooper());
    private static final AtomicBoolean initialized = new AtomicBoolean();
    private static MaxAdapter.InitializationStatus initializationStatus;
    private MobileFuseBannerAd bannerAd;
    private MobileFuseInterstitialAd interstitialAd;

    public MobileFuseMediationAdapter(AppLovinSdk appLovinSdk) {
        super(appLovinSdk);
    }

    public void initialize(MaxAdapterInitializationParameters parameters, Activity activity, final MaxAdapter.OnCompletionListener onCompletionListener) {
        if (initialized.compareAndSet(false, true)) {
            Context context = activity != null ? activity.getApplicationContext() : this.getApplicationContext();
            Bundle serverParameters = parameters.getServerParameters();
            String appKey = serverParameters.getString(PARAM_NAME_APP_KEY, null);
            this.log("Initializing MobileFuse SDK with App Key: " + appKey + "...");
            if (appKey == null) {
                this.log("Can't initialize MobileFuse SDK. The appKey is null.");
                initialized.set(false);
                onCompletionListener.onCompletion(MaxAdapter.InitializationStatus.INITIALIZED_FAILURE, null);
                return;
            }
            initializationStatus = MaxAdapter.InitializationStatus.INITIALIZING;
            this.handler.post(() -> MobileFuse.init((Context)context, (String)appKey, (SdkInitListener)new SdkInitListener(){

                public void onInitSuccess() {
                    MobileFuseMediationAdapter.this.log("MobileFuse SDK initialized");
                    initializationStatus = MaxAdapter.InitializationStatus.INITIALIZED_SUCCESS;
                    onCompletionListener.onCompletion(initializationStatus, null);
                }

                public void onInitError() {
                    MobileFuseMediationAdapter.this.log("MobileFuse SDK failed to initialize");
                    initializationStatus = MaxAdapter.InitializationStatus.INITIALIZED_FAILURE;
                    onCompletionListener.onCompletion(initializationStatus, "failed to initialize MobileFuse sdk");
                }
            }));
        } else {
            this.log("MobileFuse SDK already initialized");
            onCompletionListener.onCompletion(initializationStatus, null);
        }
    }

    public void loadAdViewAd(MaxAdapterResponseParameters parameters, MaxAdFormat maxAdFormat, Activity activity, final MaxAdViewAdapterListener maxListener) {
        Bundle serverParameters;
        String backgroundColorValue;
        String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading banner ad for placement \"" + placementId);
        MobileFuseBannerAd.AdSize adSize = MobileFuseBannerAd.AdSize.BANNER_320x50;
        if (maxAdFormat == MaxAdFormat.BANNER) {
            adSize = MobileFuseBannerAd.AdSize.BANNER_320x50;
        } else if (maxAdFormat == MaxAdFormat.LEADER) {
            adSize = MobileFuseBannerAd.AdSize.BANNER_728x90;
        } else if (maxAdFormat == MaxAdFormat.MREC) {
            adSize = MobileFuseBannerAd.AdSize.BANNER_300x250;
        }
        this.bannerAd = new MobileFuseBannerAd(activity, placementId, adSize);
        this.bannerAd.setListener(new MobileFuseBannerAd.Listener(){

            public void onAdExpanded() {
                maxListener.onAdViewAdExpanded();
            }

            public void onAdCollapsed() {
                maxListener.onAdViewAdCollapsed();
            }

            public void onAdLoaded() {
                maxListener.onAdViewAdLoaded((View)MobileFuseMediationAdapter.this.bannerAd);
            }

            public void onAdNotFilled() {
                maxListener.onAdViewAdLoadFailed(MaxAdapterError.NO_FILL);
            }

            public void onAdRendered() {
                maxListener.onAdViewAdDisplayed();
            }

            public void onAdClicked() {
                maxListener.onAdViewAdClicked();
            }

            public void onAdExpired() {
                maxListener.onAdViewAdLoadFailed(MaxAdapterError.AD_EXPIRED);
            }

            public void onAdError(AdError adError) {
            }
        });
        if (parameters.getServerParameters() != null && (backgroundColorValue = this.getCustomParamValue(serverParameters = parameters.getServerParameters(), PARAM_NAME_BG_COLOR)) != null) {
            if (backgroundColorValue.startsWith("#")) {
                backgroundColorValue = backgroundColorValue.substring(1);
            } else if (backgroundColorValue.startsWith("0x")) {
                backgroundColorValue = backgroundColorValue.substring(2);
            }
            if (backgroundColorValue.length() <= 6) {
                backgroundColorValue = "ff" + backgroundColorValue;
            }
            long backgroundColor = -1L;
            try {
                backgroundColor = Long.parseLong(backgroundColorValue, 16);
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
            }
            if (backgroundColor > -1L) {
                this.bannerAd.setBackground((Drawable)new ColorDrawable((int)backgroundColor));
            }
        }
        this.bannerAd.loadAd();
    }

    private String getCustomParamValue(Bundle serverParameters, String customParamName) {
        if (!serverParameters.containsKey(PARAM_NAME_CUSTOM_PARAMS_JSON)) {
            return null;
        }
        try {
            Bundle customParams = serverParameters.getBundle(PARAM_NAME_CUSTOM_PARAMS_JSON);
            if (!customParams.containsKey(customParamName)) {
                return null;
            }
            return customParams.getString(customParamName).trim();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void loadInterstitialAd(MaxAdapterResponseParameters parameters, Activity activity, final MaxInterstitialAdapterListener maxListener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading interstitial ad for placement \"" + placementId);
        this.interstitialAd = new MobileFuseInterstitialAd(activity, placementId);
        this.interstitialAd.setListener(new MobileFuseInterstitialAd.Listener(){

            public void onAdClosed() {
                maxListener.onInterstitialAdHidden();
            }

            public void onAdLoaded() {
                maxListener.onInterstitialAdLoaded();
            }

            public void onAdNotFilled() {
                maxListener.onInterstitialAdLoadFailed(MaxAdapterError.NO_FILL);
            }

            public void onAdRendered() {
                maxListener.onInterstitialAdDisplayed();
            }

            public void onAdClicked() {
                maxListener.onInterstitialAdClicked();
            }

            public void onAdExpired() {
                maxListener.onInterstitialAdLoadFailed(MaxAdapterError.AD_EXPIRED);
            }

            public void onAdError(AdError adError) {
            }
        });
        this.interstitialAd.loadAd();
    }

    public void showInterstitialAd(MaxAdapterResponseParameters parameters, Activity activity, MaxInterstitialAdapterListener maxListener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Showing interstitial ad for placement \"" + placementId);
        if (this.interstitialAd == null || !this.interstitialAd.isLoaded()) {
            maxListener.onInterstitialAdDisplayFailed(MaxAdapterError.AD_NOT_READY);
            return;
        }
        this.interstitialAd.showAd();
    }

    public String getSdkVersion() {
        return MobileFuse.getSdkVersion();
    }

    public String getAdapterVersion() {
        return "1.0.0.0";
    }

    public void onDestroy() {
        try {
            if (this.bannerAd != null) {
                this.bannerAd.destroy();
                this.bannerAd = null;
            }
            this.interstitialAd = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

