/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.model;

import com.google.gson.annotations.SerializedName;
import com.mobgame.model.MobMenuItem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MobMenu {
    @SerializedName(value="menu")
    ArrayList<MobMenuItem> menuItems;

    public static MobMenu parse(String json) {
        try {
            ArrayList<MobMenuItem> menuItems = new ArrayList<MobMenuItem>();
            JSONArray menuJsonAray = new JSONArray(json);
            for (int i = 0; i < menuJsonAray.length(); ++i) {
                try {
                    MobMenuItem menuItem = new MobMenuItem();
                    JSONObject menuItemJSON = menuJsonAray.getJSONObject(i);
                    if (menuItemJSON.has("id")) {
                        menuItem.setId(menuItemJSON.getInt("id"));
                    }
                    if (menuItemJSON.has("priority")) {
                        menuItem.setPriority(menuItemJSON.getInt("priority"));
                    }
                    if (menuItemJSON.has("is_tab") && menuItemJSON.getBoolean("is_tab")) {
                        menuItem.setTab(true);
                    }
                    if (menuItemJSON.has("external") && menuItemJSON.getBoolean("external")) {
                        menuItem.setExternal(true);
                    }
                    if (menuItemJSON.has("show") && menuItemJSON.getBoolean("show")) {
                        menuItem.setShouldShow(true);
                    }
                    if (menuItemJSON.has("icon")) {
                        menuItem.setIconUrl(menuItemJSON.getString("icon"));
                    }
                    if (menuItemJSON.has("title")) {
                        menuItem.setLabel(menuItemJSON.getString("title"));
                    }
                    if (menuItemJSON.has("horizontal_show") && menuItemJSON.getBoolean("horizontal_show")) {
                        menuItem.setShouldShowHorizontal(true);
                    }
                    if (menuItemJSON.has("horizontal_icon")) {
                        menuItem.setIconUrlHorizontal(menuItemJSON.getString("horizontal_icon"));
                    }
                    if (menuItemJSON.has("horizontal_title")) {
                        menuItem.setLabelHorizontal(menuItemJSON.getString("horizontal_title"));
                    }
                    if (menuItem.isTab()) {
                        try {
                            JSONArray menuActions = menuItemJSON.getJSONArray("action");
                            menuItem.setCommand("dashboard");
                            menuItem.setParams(menuActions.toString());
                            int[] subMenuIds = new int[menuActions.length()];
                            for (int j = 0; j < menuActions.length(); ++j) {
                                JSONObject obj = menuActions.getJSONObject(j);
                                subMenuIds[j] = obj.getInt("id");
                            }
                            menuItem.setSubMenuIds(subMenuIds);
                        }
                        catch (JSONException menuActions) {}
                    } else {
                        String menuAction = menuItemJSON.getString("action");
                        try {
                            JSONObject menuActionJSON = new JSONObject(menuAction);
                            menuItem.setCommand(menuActionJSON.getString("command"));
                            menuItem.setParams(menuActionJSON.getString("param"));
                        }
                        catch (JSONException e) {
                            try {
                                JSONArray menuActions = new JSONArray();
                                menuActions.put((Object)menuItemJSON);
                                menuItem.setCommand("dashboard");
                                menuItem.setParams(menuActions.toString());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    menuItems.add(menuItem);
                    continue;
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            MobMenu mobMenu = new MobMenu();
            mobMenu.setMenuItems(menuItems);
            return mobMenu;
        }
        catch (JSONException e) {
            return new MobMenu();
        }
    }

    public ArrayList<MobMenuItem> getMenuItems() {
        if (this.menuItems == null) {
            this.menuItems = new ArrayList();
        }
        return this.menuItems;
    }

    public void setMenuItems(ArrayList<MobMenuItem> menuItems) {
        this.menuItems = menuItems;
    }

    public MobMenuItem getMobMenuItemById(int menuId) {
        for (MobMenuItem menuItem : this.menuItems) {
            if (menuItem.getId() == menuId) {
                return menuItem;
            }
            for (int id2 : menuItem.getSubMenuIds()) {
                if (id2 != menuId) continue;
                return menuItem;
            }
        }
        return null;
    }

    public ArrayList<MobMenuItem> getMobMenuItemsByIds(ArrayList<Integer> menuIds) {
        HashSet<Integer> setMenuIds = new HashSet<Integer>(menuIds);
        ArrayList<MobMenuItem> result = new ArrayList<MobMenuItem>();
        if (this.menuItems == null) {
            return result;
        }
        Iterator iterator = setMenuIds.iterator();
        while (iterator.hasNext()) {
            int menuId = (Integer)iterator.next();
            for (MobMenuItem menuItem : this.menuItems) {
                if (menuItem.getId() == menuId) {
                    result.add(menuItem);
                    continue;
                }
                for (int id2 : menuItem.getSubMenuIds()) {
                    if (id2 != menuId) continue;
                    result.add(menuItem);
                }
            }
        }
        return result;
    }
}

