package com.mobgame.model;

import android.os.Parcel;
import android.os.Parcelable;

public class CharacterInfo implements Parcelable {

	private String areaId;
	private String areaName;
	private String roleId;
	private String roleName;
	
	public CharacterInfo() {
		
	}
	
	public CharacterInfo(Parcel in) {
		this.areaId = in.readString();
		this.areaName = in.readString();
		this.roleId = in.readString();
		this.roleName = in.readString();
	}

	public String getAreaId() {
		return areaId;
	}

	public void setAreaId(String areaId) {
		this.areaId = areaId;
	}

	public String getAreaName() {
		return areaName;
	}

	public void setAreaName(String areaName) {
		this.areaName = areaName;
	}

	public String getRoleId() {
		return roleId;
	}

	public void setRoleId(String roleId) {
		this.roleId = roleId;
	}

	public String getRoleName() {
		return roleName;
	}

	public void setRoleName(String roleName) {
		this.roleName = roleName;
	}
	
	@Override
	public int describeContents() {
		return 0;
	}

	@Override
	public void writeToParcel(Parcel dest, int flags) {
		dest.writeString(areaId);
		dest.writeString(areaName);
		dest.writeString(roleId);
		dest.writeString(roleName);
	}

	public static final Parcelable.Creator<CharacterInfo> CREATOR = new Parcelable.Creator<CharacterInfo>() {

		public CharacterInfo createFromParcel(Parcel in) {
			return new CharacterInfo(in);
		}

		public CharacterInfo[] newArray(int size) {
			return new CharacterInfo[size];
		}
	};
	
}
