/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.gui;

import android.animation.Animator;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Fragment;
import android.graphics.Color;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.annotation.Nullable;
import androidx.legacy.app.FragmentPagerAdapter;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.game.sdk.comon.config.GameConfigs;
import com.mobgame.R;
import com.mobgame.gui.MobGamePagerTabStrip;
import com.mobgame.gui.MobGameViewPager;
import com.mobgame.gui.MobGameWebFragment;
import com.mobgame.gui.view.MobIndicator;

public class MobGamePagerFragment
extends Fragment {
    private static final String TAG = MobGamePagerFragment.class.getSimpleName();
    private View layoutMain;
    private Activity activity;
    private MobGameViewPager viewPager;
    private MobGamePagerTabStrip tabs;
    private MobIndicator layoutIndicators;
    private FragmentPagerAdapter adapter;
    private MobGameWebFragment.EventListener mWebEventListener;
    private ViewPager.OnPageChangeListener mOnPageChangeListener;
    private int selectedIndex;
    private Animator.AnimatorListener mAnimatorListener = new Animator.AnimatorListener(){

        public void onAnimationStart(Animator animation) {
            try {
                MobGamePagerFragment.this.activity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        ((ViewGroup)MobGamePagerFragment.this.layoutMain).updateViewLayout((View)MobGamePagerFragment.this.viewPager, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, MobGamePagerFragment.this.layoutMain.getHeight()));
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void onAnimationEnd(Animator animation) {
            try {
                MobGamePagerFragment.this.activity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        MobGamePagerFragment.this.updateTabs();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void onAnimationCancel(Animator animation) {
        }

        public void onAnimationRepeat(Animator animation) {
        }
    };

    public MobGamePagerFragment() {
    }

    @SuppressLint(value={"ValidFragment"})
    public MobGamePagerFragment(Activity activity) {
        this.activity = activity;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_pager, container, false);
        this.layoutMain = view.findViewById(R.id.layout_main);
        this.viewPager = (MobGameViewPager)view.findViewById(R.id.pager);
        this.layoutIndicators = (MobIndicator)view.findViewById(R.id.layout_indicator_bottom);
        this.tabs = (MobGamePagerTabStrip)view.findViewById(R.id.pager_title_strip);
        try {
            String lang = "eng";
            if (GameConfigs.getInstance().getLang() != null) {
                lang = GameConfigs.getInstance().getLang();
            }
            if ("vie".equalsIgnoreCase(lang)) {
                this.tabs.setIndicatorColor(Color.rgb((int)252, (int)102, (int)32));
                this.tabs.setTextColor(this.getActivity().getResources().getColor(R.color.active_text));
            } else {
                this.tabs.setIndicatorColor(Color.rgb((int)252, (int)102, (int)32));
                this.tabs.setTextColor(this.getActivity().getResources().getColor(R.color.active_text));
            }
            if (this.adapter != null) {
                this.setAdapter(this.adapter);
            }
            if (this.mOnPageChangeListener != null) {
                this.viewPager.addOnPageChangeListener(this.mOnPageChangeListener);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return view;
    }

    public void setAdapter(FragmentPagerAdapter adapter) {
        this.setAdapter(adapter, this.selectedIndex);
    }

    public void setAdapter(FragmentPagerAdapter adapter, int selectedIndex) {
        try {
            if (this.viewPager != null && this.tabs != null) {
                this.viewPager.setAdapter(null);
                this.viewPager.setAdapter((PagerAdapter)adapter);
                this.layoutIndicators.setViewPager(this.viewPager);
                this.tabs.setViewPager(this.viewPager);
                if (adapter.getCount() <= 1 && this.adapter.getCount() > 1) {
                    this.hideTabs(false);
                } else if (adapter.getCount() > 1) {
                    this.showTabs(false);
                }
                for (int i = 0; i < adapter.getCount(); ++i) {
                    Fragment frag = adapter.getItem(i);
                    if (!(frag instanceof MobGameWebFragment)) continue;
                    ((MobGameWebFragment)frag).setWebViewTag(i + "");
                    if (this.mWebEventListener == null) continue;
                    ((MobGameWebFragment)frag).setEventListener(this.mWebEventListener);
                }
                this.viewPager.setCurrentItem(selectedIndex, false);
                if (this.mOnPageChangeListener != null) {
                    this.mOnPageChangeListener.onPageSelected(selectedIndex);
                    this.layoutIndicators.updatePosition(selectedIndex);
                }
            }
            this.adapter = adapter;
            this.selectedIndex = selectedIndex;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void notifiTabsChanged() {
        try {
            if (this.tabs != null) {
                this.tabs.notifyDataSetChanged();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setWebEventListener(MobGameWebFragment.EventListener eventListener) {
        try {
            this.mWebEventListener = eventListener;
            if (this.adapter != null) {
                for (int i = 0; i < this.adapter.getCount(); ++i) {
                    Fragment frag = this.adapter.getItem(i);
                    if (!(frag instanceof MobGameWebFragment)) continue;
                    ((MobGameWebFragment)frag).setEventListener(this.mWebEventListener);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addOnPageChangeListener(ViewPager.SimpleOnPageChangeListener onPageChangeListener) {
        try {
            if (this.viewPager != null) {
                this.viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)onPageChangeListener);
            }
            this.mOnPageChangeListener = onPageChangeListener;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int countTabs() {
        return this.adapter.getCount();
    }

    public void showTabs(boolean isAnimated) {
        try {
            this.viewPager.setPagingEnabled(true);
            this.tabs.setVisibility(0);
            if (isAnimated) {
                this.tabs.animate().setDuration(250L).y(0.0f);
                this.viewPager.animate().setDuration(250L).y((float)this.tabs.getHeight()).setListener(this.mAnimatorListener);
            } else {
                this.tabs.animate().setDuration(0L).y(0.0f);
                this.viewPager.animate().setDuration(0L).y((float)this.tabs.getHeight()).setListener(this.mAnimatorListener);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void hideTabs(boolean isAnimated) {
        try {
            if (this.viewPager == null) {
                return;
            }
            this.viewPager.setPagingEnabled(false);
            if (isAnimated) {
                this.tabs.animate().setDuration(250L).y((float)(-this.tabs.getHeight()));
                this.viewPager.animate().setDuration(250L).y(0.0f).setListener(this.mAnimatorListener);
            } else {
                this.tabs.animate().setDuration(0L).y((float)(-this.tabs.getHeight()));
                this.viewPager.animate().setDuration(0L).y(0.0f).setListener(this.mAnimatorListener);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateTabs() {
        try {
            ((ViewGroup)this.layoutMain).updateViewLayout((View)this.viewPager, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, this.layoutMain.getHeight() - this.tabs.getHeight() - (int)this.tabs.getY()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

