/*
 * Decompiled with CFR 0.152.
 */
package com.mobgame.gui.view;

import android.content.Context;
import android.os.CountDownTimer;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.TextSwitcher;
import android.widget.TextView;
import android.widget.ViewSwitcher;
import com.mobgame.R;
import java.util.ArrayList;

public class MobAutoScrollTextView
extends TextSwitcher {
    private static final String TAG = MobAutoScrollTextView.class.getName();
    private ArrayList<String> stringArrayList;
    private Long duration;
    private boolean repeat;
    private boolean reverse = true;
    private int i = 0;

    public MobAutoScrollTextView(Context context) {
        super(context);
    }

    public MobAutoScrollTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public boolean isRepeat() {
        return this.repeat;
    }

    public void setRepeat(boolean repeat) {
        this.repeat = repeat;
    }

    public Long getDuration() {
        return this.duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public void setArrayListText(ArrayList<String> arrayListText) {
        this.stringArrayList = arrayListText;
    }

    public ArrayList<String> getArrayListText() {
        return this.stringArrayList;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    public synchronized void startAutoScroll(final ArrayList<String> listText, long duration, boolean repeat, final boolean reverse, final OnTextViewScrollListener onTextViewScrollListener) {
        try {
            Log.d((String)TAG, (String)("startAutoScroll: Switcher childcount: " + this.getChildCount()));
            if (this.getChildCount() == 0) {
                this.setFactory(new ViewSwitcher.ViewFactory(){

                    public View makeView() {
                        TextView myText = new TextView(MobAutoScrollTextView.this.getContext());
                        myText.setGravity(17);
                        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2, 17);
                        myText.setLayoutParams((ViewGroup.LayoutParams)params);
                        myText.setTextSize(15.0f);
                        myText.setTextColor(-1);
                        return myText;
                    }
                });
            }
            this.setInAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.push_up_in));
            this.setOutAnimation(this.getContext(), R.anim.push_up_out);
            long timeCount = (long)(listText.size() + 1) * duration;
            this.i = 0;
            this.setText("");
            CountDownTimer countDownTimer = new CountDownTimer(timeCount, duration){

                public void onTick(long millisUntilFinished) {
                    try {
                        if (onTextViewScrollListener != null) {
                            onTextViewScrollListener.onTextViewScroll((String)listText.get(MobAutoScrollTextView.this.i), reverse);
                        }
                        MobAutoScrollTextView.this.setText((CharSequence)listText.get(MobAutoScrollTextView.this.i));
                        Log.d((String)TAG, (String)("onTick: " + (String)listText.get(MobAutoScrollTextView.this.i)));
                        MobAutoScrollTextView.this.i++;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                public void onFinish() {
                    onTextViewScrollListener.onTextViewScrollFinished();
                    MobAutoScrollTextView.this.removeAllViews();
                    MobAutoScrollTextView.this.i = 0;
                }
            };
            countDownTimer.start();
        }
        catch (Exception e) {
            this.removeAllViews();
            e.printStackTrace();
        }
    }

    public void startAutoScroll(ArrayList<String> listText, long duration, boolean repeat, OnTextViewScrollListener onTextViewScrollListener) {
        this.startAutoScroll(listText, duration, repeat, true, onTextViewScrollListener);
    }

    public void startAutoScroll(ArrayList<String> listText, long duration, OnTextViewScrollListener onTextViewScrollListener) {
        this.startAutoScroll(listText, duration, false, false, onTextViewScrollListener);
    }

    public static interface OnTextViewScrollListener {
        public void onTextViewScroll(String var1, boolean var2);

        public void onTextViewScrollFinished();
    }
}

