/*
 * Decompiled with CFR 0.152.
 */
package com.game.sdk.comon.sharePref;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.NonNull;
import com.game.sdk.comon.object.ListPurchaseHistoryObj;
import com.game.sdk.comon.object.PurchaseHistoryObj;
import com.game.sdk.comon.object.UserObj;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Set;

public class PrefManager {
    private static String PREF_FILE_NAME = "vParentalControl";

    public static boolean isLoggedIn(Context context) {
        return PrefManager.getAccessToken(context) != null;
    }

    public static void saveUser(Context context, UserObj customerObject) {
        SharedPreferences pref = context.getSharedPreferences(PREF_FILE_NAME, 0);
        String userJson = new Gson().toJson((Object)customerObject);
        pref.edit().putString("PREF_USER_JSON", userJson).commit();
    }

    public static void saveUsePurchaseHistory(Context context, String account_id, PurchaseHistoryObj obj) {
        SharedPreferences pref = context.getSharedPreferences(PREF_FILE_NAME, 0);
        ListPurchaseHistoryObj list = PrefManager.getHistoryPurchase(context, account_id);
        list.getData().add(obj);
        String userJson = new Gson().toJson((Object)list);
        pref.edit().putString("MOB_PURCHASE" + account_id, userJson).commit();
    }

    public static void saveUsePurchaseHistory(Context context, String account_id, ListPurchaseHistoryObj obj) {
        SharedPreferences pref = context.getSharedPreferences(PREF_FILE_NAME, 0);
        String userJson = new Gson().toJson((Object)obj);
        pref.edit().putString("MOB_PURCHASE" + account_id, userJson).commit();
    }

    public static ListPurchaseHistoryObj getHistoryPurchase(Context context, String account_id) {
        SharedPreferences pref = context.getSharedPreferences(PREF_FILE_NAME, 0);
        String userJson = pref.getString("MOB_PURCHASE" + account_id, null);
        ListPurchaseHistoryObj list = null;
        if (userJson == null || userJson.isEmpty()) {
            list = new ListPurchaseHistoryObj();
            list.setData(new ArrayList<PurchaseHistoryObj>());
            return list;
        }
        try {
            list = (ListPurchaseHistoryObj)new Gson().fromJson(userJson, ListPurchaseHistoryObj.class);
            if (list == null) {
                list = new ListPurchaseHistoryObj();
            }
            if (list.getData() == null) {
                list.setData(new ArrayList<PurchaseHistoryObj>());
            }
            return list;
        }
        catch (JsonSyntaxException ex) {
            ex.printStackTrace();
            return list;
        }
    }

    public static UserObj getUser(Context context) {
        SharedPreferences pref = context.getSharedPreferences(PREF_FILE_NAME, 0);
        String userJson = pref.getString("PREF_USER_JSON", null);
        if (userJson == null || userJson.isEmpty()) {
            return null;
        }
        try {
            UserObj user = (UserObj)new Gson().fromJson(userJson, UserObj.class);
            return user;
        }
        catch (JsonSyntaxException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void saveAccessToken(Context context, String accessToken) {
        PrefManager.saveSetting(context, "PREF_TOKEN", accessToken);
    }

    public static String getAccessToken(Context context) {
        if (context == null) {
            return "";
        }
        return context.getSharedPreferences(PREF_FILE_NAME, 0).getString("PREF_TOKEN", "");
    }

    public static void saveAdsKey(Context context, String adsKey) {
        if (context == null) {
            return;
        }
        PrefManager.saveSetting(context, "ADS_KEY", adsKey);
    }

    public static String getAdsKey(@NonNull Context context) {
        if (context == null) {
            return "";
        }
        return context.getSharedPreferences(PREF_FILE_NAME, 0).getString("ADS_KEY", "");
    }

    public static void saveAppKey(Context context, String appKey) {
        if (context == null) {
            return;
        }
        PrefManager.saveSetting(context, "APP_KEY", appKey);
    }

    public static String getAppKey(@NonNull Context context) {
        if (context == null) {
            return "";
        }
        return context.getSharedPreferences(PREF_FILE_NAME, 0).getString("APP_KEY", "");
    }

    public static void saveSetting(Context context, String key, String value) {
        SharedPreferences pref = context.getSharedPreferences(PREF_FILE_NAME, 0);
        SharedPreferences.Editor editor = pref.edit();
        editor.putString(key, value);
        editor.commit();
    }

    public static void saveSetting(Context context, String key, int value) {
        SharedPreferences pref = context.getSharedPreferences(PREF_FILE_NAME, 0);
        SharedPreferences.Editor editor = pref.edit();
        editor.putInt(key, value);
        editor.commit();
    }

    public static void saveSetting(Context context, String key, boolean value) {
        SharedPreferences pref = context.getSharedPreferences(PREF_FILE_NAME, 0);
        SharedPreferences.Editor editor = pref.edit();
        editor.putBoolean(key, value);
        editor.commit();
    }

    public static void saveSetting(Context context, String key, float value) {
        SharedPreferences pref = context.getSharedPreferences(PREF_FILE_NAME, 0);
        SharedPreferences.Editor editor = pref.edit();
        editor.putFloat(key, value);
        editor.commit();
    }

    public static void saveSetting(Context context, String key, long value) {
        SharedPreferences pref = context.getSharedPreferences(PREF_FILE_NAME, 0);
        SharedPreferences.Editor editor = pref.edit();
        editor.putLong(key, value);
        editor.commit();
    }

    public static void saveSetting(Context context, String key, Set<String> value) {
        SharedPreferences pref = context.getSharedPreferences(PREF_FILE_NAME, 0);
        SharedPreferences.Editor editor = pref.edit();
        editor.putStringSet(key, value);
        editor.commit();
    }

    public static void saveString(Context context, String key, String value) {
        SharedPreferences pref = context.getSharedPreferences(PREF_FILE_NAME, 0);
        SharedPreferences.Editor editor = pref.edit();
        editor.putString(key, value);
        editor.commit();
    }

    public static void saveBoolean(Context context, String key, boolean value) {
        SharedPreferences pref = context.getSharedPreferences(PREF_FILE_NAME, 0);
        SharedPreferences.Editor editor = pref.edit();
        editor.putBoolean(key, value);
        editor.commit();
    }

    public static void saveInt(Context context, String key, int value) {
        SharedPreferences pref = context.getSharedPreferences(PREF_FILE_NAME, 0);
        SharedPreferences.Editor editor = pref.edit();
        editor.putInt(key, value);
        editor.commit();
    }

    public static void saveLong(Context context, String key, long value) {
        SharedPreferences pref = context.getSharedPreferences(PREF_FILE_NAME, 0);
        SharedPreferences.Editor editor = pref.edit();
        editor.putLong(key, value);
        editor.commit();
    }

    public static String getString(Context context, String key) {
        SharedPreferences pref = context.getSharedPreferences(PREF_FILE_NAME, 0);
        return pref.getString(key, "");
    }

    public static String getString(Context context, String key, String defaultValue) {
        SharedPreferences pref = context.getSharedPreferences(PREF_FILE_NAME, 0);
        return pref.getString(key, defaultValue) == null ? "" : pref.getString(key, defaultValue);
    }

    public static boolean getBoolean(Context context, String key, boolean defaultValue) {
        SharedPreferences pref = context.getSharedPreferences(PREF_FILE_NAME, 0);
        return pref.getBoolean(key, defaultValue);
    }

    public static long getLong(Context context, String key, long defaultValue) {
        try {
            SharedPreferences pref = context.getSharedPreferences(PREF_FILE_NAME, 0);
            return pref.getLong(key, defaultValue);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static int getInt(Context context, String key, int defaultValue) {
        SharedPreferences pref = context.getSharedPreferences(PREF_FILE_NAME, 0);
        return pref.getInt(key, defaultValue);
    }

    public static void logoutApp(Context context) {
        SharedPreferences pref = context.getSharedPreferences(PREF_FILE_NAME, 0);
        SharedPreferences.Editor editor = pref.edit();
        editor.remove("PREF_USER_JSON");
        editor.commit();
    }
}

